function [kpoleT,ParamValues]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,VariableNumber,EndVal,branch,kpole,flow,nopredict,movement)

if nargin<11
    disp('Function for tracking poles as a single parameter is varied. Can vary omega, h, and imag(Z).')
    disp('inputs(w,M,m,h,Mass,Spring,Damper,VariableNumber,EndVal,branch,kpole,flow).')
    Value=input('Would you like input information? 0 N,1 Y :');
    if Value==1
        disp('w value of omega Scalar')
        disp('M mach number Scalar')
        disp('m wave mode Scalar')
        disp('h boundary layer thickness Scalar')
        disp('Mass Mass term for a MSD Impedence Z(omega)')
        disp('Spring Spring term for a MSD Impedence Z(omega)')
        disp('Damper Damper term for a MSD Impedence Z(omega)')
        disp(' Z(omega)=Damper +1i Mass omega - 1i Spring / omega ')
        disp('VariableNumber choose what type of tracking to perform 1 varies imag omega, 2 Varies Z, 3 varies h, 4 varies omega, 5 varies M')
        disp('EndVal value to vary the parameter, initial value given by value given in first 8 parameters')
        disp('kpole vector or scalar list of pole locations to track')
        disp('Optional:')
        disp('flow 1 or 2 for linear or quadratic shear flow, defaults to 2')
        disp('nopredict; if nonzero, measure distance between points, rather than between each point and its predicted location.  Defaults to zero.')
        disp('movement; distance between point and next point.  Defaults to 0.1 if nopredict, and 0.01 if ~nopredict.')
        Value=input('Would you like output information? 0 N,1 Y :');
        if Value==1
            disp('kpoleT, matrix (length(kpole),INT) tracking of kpole as paramter is varied, parameter value corresponds to ParamValues ')
            disp('ParamValues, matrix as above of parameter valus for location of corresponding pole.')
        end
    end
    clear('Value')
    kpoleT=[];
    ParamValues=[];
    return
end

if nargin<12 || flow~=1
    flow=2;
end
if nargin<13
    nopredict=0;
end
if nargin<14
    if nopredict
        movement=0.1;
    else
        movement=0.01;
    end
end

Z=Damper+1i*w*Mass-1i*Spring/w;
if VariableNumber==1
    w=[w,w+1i*EndVal];
elseif VariableNumber==2
    Z=[Z,EndVal];
elseif VariableNumber==3
    h=linspace(h,EndVal,2);
elseif VariableNumber==4
    w=linspace(w,EndVal,2);
elseif VariableNumber==5
    M=linspace(M,EndVal,2);
else
    kpoleT=[];
    ParamValues=[];
    return
end
kpoleT=0;
ParamValues=0;
for j1=1:length(kpole)
    fprintf('  kPoleTrack %4d/%4d: k = %14.6g + %14.6gi', j1, length(kpole), real(kpole(j1)), imag(kpole(j1)));
    [kpoleTnew,ParamValuesnew]=poletrack(kpole(j1),w,M,m,Mass,Spring,Damper,Z,h,branch,VariableNumber,flow,nopredict,movement);
    fprintf(' (length = %6d)\n', length(kpoleTnew));
    if length(kpoleT(1,:))<length(kpoleTnew)
        kpoleT=[kpoleT,kpoleT(:,end)+zeros(length(kpoleT(:,1)),(length(kpoleTnew)-length(kpoleT(1,:))))];
        ParamValues=[ParamValues,ParamValues(:,end)+zeros(length(ParamValues(:,1)),(length(ParamValuesnew)-length(ParamValues(1,:))))];
    elseif length(kpoleT(1,:))>length(kpoleTnew)
        kpoleTnew=[kpoleTnew,kpoleTnew(end)+zeros(1,(length(kpoleT(1,:))-length(kpoleTnew)))];
        ParamValuesnew=[ParamValuesnew,ParamValuesnew(end)+zeros(1,(length(ParamValues(1,:))-length(ParamValuesnew)))];
    end
    kpoleT(j1,:)=kpoleTnew;
    ParamValues(j1,:)=ParamValuesnew;
end


end

function [kpoleT,ParamValues]=poletrack(kpole,w,M,m,Mass,Spring,Damper,Z,h,branch,type,flow,nopredict,movement)
dt=1e-5;
t=0;
j1=1;
dk=0;

% Check we can find the starting value
if branch==0
  kpolenew=PoleLocateFD(kpole,w(1),M(1),m,Z(1),h(1),flow,0.000001,8001,500);
  if isempty(kpolenew) || ~isfinite(kpolenew)
    kpolenew=PoleLocate(kpole,w(1),M(1),m,Z(1),h(1),flow,1,0.00000001);
    if isempty(kpolenew) || ~isfinite(kpolenew)
      kpolenew=PoleLocate(kpole,w(1),M(1),m,Z(1),h(1),flow,-1,0.00000001);
      if isempty(kpolenew) || ~isfinite(kpolenew)
        kpolenew=PoleLocate(kpole,w(1),M(1),m,Z(1),h(1),flow,0,0.00000001);
      end
    end
  end
else
  kpolenew=PoleLocate(kpole,w(1),M(1),m,Z(1),h(1),flow,branch,0.00000001);
end
if isempty(kpolenew) || ~isfinite(kpolenew) || abs(kpolenew-kpole) > movement
  kpoleT = kpolenew;
  if isempty(kpoleT)
    kpoleT = NaN;
  end
  ParamValues = 0;
  return;
end
kpole = kpolenew;

Talloc=512;
kpoleT=zeros(1,Talloc);
ParamValues=zeros(1,Talloc);
kpoleT(1) = kpole;
if type==1
    ParamValues(1)=w(1);
elseif type==2
    ParamValues(1)=Z(1);
elseif type==3
    ParamValues(1)=h(1);
elseif type==4
    ParamValues(1)=w(1);
elseif type==5
    ParamValues(1)=M(1);
end

while t<1 && dt>eps
    tnew = t+dt;
    if (tnew > 1)
        dt = 1-t;
        tnew = 1;
    end
    ktry=kpole + dk*dt; % Predicted location
    if type==1
        if ~isinf(w(2))
            omega=w(1)-tnew*(w(1)-w(2));
            PV=omega;
            Z=Damper+1i*omega*Mass-1i*Spring/omega;
            if branch==0
                kpolenew=PoleLocateFD(ktry,omega,M,m,Z,h,flow,0.000001,8001,500);
                if isempty(kpolenew)
                    kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,1,0.00000001);
                    if isempty(kpolenew)
                        kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,-1,0.00000001);
                        if isempty(kpolenew)
                            kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,0,0.00000001);
                        end
                    end
                end
            else
                kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,branch,0.00000001);
            end
        else
            omega=real(w(1))+1i*imag(w(1))+1i*sign(imag(w(2)))*(tnew)/(1+eps-tnew);
            PV=omega;
            Z=Damper+1i*omega*Mass-1i*Spring/omega;
            if branch==0
                kpolenew=PoleLocateFD(ktry,omega,M,m,Z,h,flow,0.000001,8001,500);
                if isempty(kpolenew)
                    kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,1,0.00000001);
                    if isempty(kpolenew)
                        kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,-1,0.00000001);
                        if isempty(kpolenew)
                            kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,0,0.00000001);
                        end
                    end
                end
            else
                kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,branch,0.00000001);
            end
        end
    elseif type==2
        if ~isinf(Z(2))
            z=Z(1)-tnew*(Z(1)-Z(2));
            PV=z;
            if branch==0
                kpolenew=PoleLocateFD(ktry,w,M,m,z,h,flow,0.000001,8001,500);
                if isempty(kpolenew)
                    kpolenew=PoleLocate(ktry,w,M,m,z,h,flow,1,0.00000001);
                    if isempty(kpolenew)
                        kpolenew=PoleLocate(ktry,w,M,m,z,h,flow,-1,0.00000001);
                        if isempty(kpolenew)
                            kpolenew=PoleLocate(ktry,w,M,m,z,h,flow,0,0.00000001);
                        end
                    end
                end
            else
                kpolenew=PoleLocate(ktry,w,M,m,z,h,flow,branch,0.00000001);
            end
        else
            z=real(Z(1))+1i*imag(Z(1))+1i*sign(Z(2))*tnew/(1+eps-tnew);
            PV=z;
            if branch==0
                kpolenew=PoleLocateFD(ktry,w,M,m,z,h,flow,0.000001,8001,500);
                if isempty(kpolenew)
                    kpolenew=PoleLocate(ktry,w,M,m,z,h,flow,1,0.00000001);
                    if isempty(kpolenew)
                        kpolenew=PoleLocate(ktry,w,M,m,z,h,flow,-1,0.00000001);
                        if isempty(kpolenew)
                            kpolenew=PoleLocate(ktry,w,M,m,z,h,flow,0,0.00000001);
                        end
                    end
                end
            else
                kpolenew=PoleLocate(ktry,w,M,m,z,h,flow,branch,0.00000001);
            end
        end
    elseif type==3
        H=h(1)-tnew*(h(1)-h(2));
        PV=H;
        if branch==0
            kpolenew=PoleLocateFD(ktry,w,M,m,Z,H,flow,0.000001,8001,500);
            if isempty(kpolenew)
                kpolenew=PoleLocate(ktry,w,M,m,Z,H,flow,1,0.00000001);
                if isempty(kpolenew)
                    kpolenew=PoleLocate(ktry,w,M,m,Z,H,flow,-1,0.00000001);
                    if isempty(kpolenew)
                        kpolenew=PoleLocate(ktry,w,M,m,Z,H,flow,0,0.00000001);
                    end
                end
            end
        else
            kpolenew=PoleLocate(ktry,w,M,m,Z,H,flow,branch,0.00000001);
        end
    elseif type==4
        omega=w(1)-tnew*(w(1)-w(2));
        PV=omega;
        Z=Damper+1i*omega*Mass-1i*Spring/omega;
        if branch==0
            kpolenew=PoleLocateFD(ktry,omega,M,m,Z,h,flow,0.000001,8001,500);
            if isempty(kpolenew)
                kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,1,0.00000001);
                if isempty(kpolenew)
                    kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,-1,0.00000001);
                    if isempty(kpolenew)
                        kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,0,0.00000001);
                    end
                end
            end
        else
            kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,branch,0.00000001);
            if isempty(kpolenew)
                kpolenew=PoleLocate(ktry,omega,M,m,Z,h,flow,0,0.00000001);
            end
        end
    elseif type==5
        EM=M(1)-tnew*(M(1)-M(2));
        PV=EM;
        if branch==0
            kpolenew=PoleLocateFD(ktry,w,EM,m,Z,h,flow,0.000001,8001,500);
            if isempty(kpolenew)
                kpolenew=PoleLocate(ktry,w,EM,m,Z,h,flow,1,0.00000001);
                if isempty(kpolenew)
                    kpolenew=PoleLocate(ktry,w,EM,m,Z,h,flow,-1,0.00000001);
                    if isempty(kpolenew)
                        kpolenew=PoleLocate(ktry,w,EM,m,Z,h,flow,0,0.00000001);
                    end
                end
            end
        else
            kpolenew=PoleLocate(ktry,w,EM,m,Z,h,flow,branch,0.00000001);
        end
    end
    if isempty(kpolenew) || ~isfinite(kpolenew)
        dt = 0.5*dt;
    elseif nopredict && abs(kpolenew-kpole)>movement
        dt = dt*0.75*movement/abs(kpolenew-kpole); % Targets 0.75*movement
    elseif ~nopredict && abs(kpolenew-ktry)>movement
        dt = dt*sqrt(0.75*movement/abs(kpolenew-ktry)); % Targets 0.75*movement
    else
        j1=j1+1;
        if j1 > Talloc
            Talloc = j1*2+512;
            kpoleT = [kpoleT, zeros(1,Talloc-length(kpoleT))];
            ParamValues = [ParamValues, zeros(1,Talloc-length(ParamValues))];
        end
        kpoleT(j1)=kpolenew;
        ParamValues(j1)=PV;
        dk=(kpolenew-kpole)/dt;
        if nopredict && abs(kpolenew-kpole)<0.5*movement
            dt=dt*2;
        elseif ~nopredict && abs(kpolenew-ktry)<0.5*movement
            dt=dt*sqrt(2);
        end
        kpole=kpolenew;
        t=tnew;
    end
end

kpoleT = kpoleT(1:j1);
ParamValues = ParamValues(1:j1);
end
