function [Steepest,branchpoint]=SteepestDecent(w,M,m,h,Z,r,r0,x,type,flow,tol)

if nargin<10
    disp('Not enough inputs')
    Value('Would you like input information? 1 Yes 0 No: ')
    if Value==1
        disp('SteepestDecent(w,M,m,h,Z,r,r0,x,type,flow)')
        disp('w value of omega Scalar')
        disp('M Mach number Scalar')
        disp('m wave mode scalar')
        disp('Z Impedence Scalar')
        disp('r radial value Vector or Scalar')
        disp('r0 radial source location scalar')
        disp('x position in duct from source, Scalar or vector')
        disp('type tpye of steepest contour, 0 for kbar, 1 for k0, 2 for kr, will default to 0 if otherwise')
        disp('flow scalar 1 or 2 for linear and quadratic shear respectively, defaults to 2')
        disp('tol is the accuracy required; defaults to 1e-5, but 1e-8 might be better for convergence studies')
    end
    Value('Would you like output information? 1 Yes 0 No: ')
    if Value==1
        disp('[Steepest,branchpoint]')
        disp('Steepest matrix of size (length(x),length(r)) evaluation down the steepest decent contour.')
        disp('branchpoint matrix as above, for the integration around the branchpoint, only non-zero for type==1, r0>1-h')
    end
    clear('Value')
    Steepest=[];
    branchpoint=[];
    return
end
A=max(max(max(length(w),length(M)),max(length(Z),length(r0))),max(length(m),length(h)));
B=min(min(min(length(w),length(M)),min(length(Z),length(r0))),min(min(length(m),length(h)),min(length(r),length(x))));
if A~=B
    disp('Inputs should be scalars/non-empty')
    Value('Would you like input information? 1 Yes 0 No: ')
    if Value==1
        disp('SteepestDecent(w,M,m,h,Z,r,r0,x,type)')
        disp('w value of omega Scalar')
        disp('M Mach number Scalar')
        disp('m wave mode scalar')
        disp('Z Impedence Scalar')
        disp('r radial value Vector or Scalar')
        disp('r0 radial source location scalar')
        disp('x position in duct from source, Scalar or vector')
        disp('type tpye of steepest contour, 0 for kbar, 1 for k0, 2 for kr')
    end
    clear('Value')
    Steepest=[];
    branchpoint=[];
    return
end
if nargin < 11
    tol=1e-5;
end
if length(type)~=1
    type=0;
end 
type(type~=mod(type,3))=0;

if flow~=1
    flow=2;
end
if type==0
    bk=w/M;
    if bk>200
        disp('omega/M is too large for I_{omega/M} to be accurate in reasonable time, setting to 0')
        Steepest=zeros(length(x),length(r));
        branchpoint=zeros(length(x),length(r));
        return
    end
elseif type==1 && r0>1-h
    if flow==2
        bk=w/(M*(1-(1-(1-r0)/h)^2));
    else
        bk=w*h/(M*(1-r0)); 
    end
    if bk>200
        disp(['k_0 is too large for I_{0} to be accurate in reasonable time, setting to 0, r_0= ', num2str(r0)])
        Steepest=zeros(length(x),length(r));
        branchpoint=zeros(length(x),length(r));
        return
    end
elseif type==1 && r0<=1-h
    Steepest=zeros(length(x),length(r));
    branchpoint=zeros(length(x),length(r));
    return
elseif type==2
    if length(r)>1
        Steepest=zeros(length(x),length(r));
        branchpoint=zeros(length(x),length(r));
        for j1=1:length(r)
            if r(j1)<1
                [Steepest(:,j1),~]=SteepestDecent(w,M,m,h,Z,r(j1),r0,x,2,flow,tol);
            else
                Steepest(:,j1)=zeros(length(x),1);
                disp(['r is too large at r= ' , num2str(r(j1)) , 'for accurate computation of Ikr'])
            end
        end
        return
    elseif r>1-h
        if flow==2
            bk=w/(M*(1-(1-(1-r)/h)^2));
        else
            bk=w*h/(M*(1-r)); 
        end
        if bk>200
            disp(['k_r is too large for I_{r} to be accurate in reasonable time, setting to 0, r= ', num2str(r)])
            Steepest=zeros(length(x),length(r));
            branchpoint=zeros(length(x),length(r));
            return
        end
    else
        Steepest=zeros(length(x),length(r));
        branchpoint=zeros(length(x),length(r));
        return
    end
end

Steepest=zeros(length(x),length(r));
branchpoint=zeros(length(x),length(r));

%%Integrating around the Branchpoint when nessersary.
disp('    SteepestDescent: Integrating around branchpoint.');
R=0.001;
if type==0
    Branchk0=(r0<1-h)+-1*(r0>1-h);
    Branchkr=zeros(1,length(r));
    Branchkr(r>1-h)=1;
    Branchkr(r<1-h)=-1;
    Integrand1 = @(theta) FourierGreens(w,M,m,h,Z,bk+R*exp(1i*theta),r,r0,-1,Branchkr,Branchk0,flow).*exp(-1i*(R*exp(1i*theta))*x.')*exp(1i*theta);
    Steepest=(R*exp(-1i*bk*(x.'))/(2*pi)).*integral(Integrand1,3*pi/2,pi , 'ArrayValued',true );
    Integrand2 = @(theta) FourierGreens(w,M,m,h,Z,bk+R*exp(1i*theta),r,r0,1,Branchkr,Branchk0,flow).*exp(-1i*(R*exp(1i*theta))*x.')*exp(1i*theta);
    Steepest=Steepest+(R*exp(-1i*bk*(x.'))/(2*pi)).*integral(Integrand2,pi,-pi/2 , 'ArrayValued',true );
    if r0>1-h && abs(bk-w/(M*(1-(1-(1-r0)/h)^2)))<R
        disp('Solution may be inaccurate for Ibk, r0 is too close to 1-h')
    end
elseif type==1
    Branchkr=zeros(1,length(r))+1;
    Branchkr(r>r0)=-1;
    Integrand = @(theta) FourierGreens(w,M,m,h,Z,bk+R*exp(1i*theta),r,r0,1,Branchkr,1,flow).*exp(-1i*(R*exp(1i*theta))*x.').*exp(1i*theta);
    branchpoint=(R*exp(-1i*bk*(x.'))/(2*pi)).*integral(Integrand,3*pi/2,-pi/2 , 'ArrayValued',true );
    Integrand2 = @(theta) FourierGreens(w,M,m,h,Z,bk+R*exp(1i*theta),r,r0,1,Branchkr,-1,flow).*exp(-1i*(R*exp(1i*theta))*x.')*exp(1i*theta);
    Below=(R*exp(-1i*bk*(x.'))/(2*pi)).*integral(Integrand2,3*pi/2,pi , 'ArrayValued',true );
    Above=(R*exp(-1i*bk*(x.'))/(2*pi)).*integral(Integrand,pi,-pi/2 , 'ArrayValued',true );
    Steepest=Above+Below-branchpoint;
elseif type==2
    Branchk0=(r0<r)+-1*(r0>r);
    Integrand1 = @(theta) FourierGreens(w,M,m,h,Z,bk+R*exp(1i*theta),r,r0,1,-1,Branchk0,flow).*exp(-1i*(R*exp(1i*theta))*x.')*exp(1i*theta);
    Steepest=(R*exp(-1i*bk*(x.'))/(2*pi)).*integral(Integrand1,3*pi/2,pi , 'ArrayValued',true );
    Integrand2 = @(theta) FourierGreens(w,M,m,h,Z,bk+R*exp(1i*theta),r,r0,1,1,Branchk0,flow).*exp(-1i*(R*exp(1i*theta))*x.')*exp(1i*theta);
    Steepest=Steepest+(R*exp(-1i*bk*(x.'))/(2*pi)).*integral(Integrand2,pi,-pi/2 , 'ArrayValued',true );
    if r0>1-h && abs(bk-w/(M*(1-(1-(1-r0)/h)^2)))<R
        disp(['Solution may be inaccurate for Ikr at r=', num2str(r)])
    end
end

%%Integrating down from the branchpoint
ENDVALUE=bk-25i;
STARTVALUE=bk-R*1i;

%%Choosing an x value for checking for convergence (expect smallest positive x to converge last)
steperr=zeros(1,length(r))+1;
J1x=1;
for j1=1:length(x)
    if x(j1)>0 && abs(x(J1x))>=abs(x(j1))
        J1x=j1;
    end
end

while imag(ENDVALUE)>-400 && max(steperr)>1e-6
    fprintf('    SteepestDescent: Integrating from %g to %g.\n',imag(STARTVALUE),imag(ENDVALUE));
    Section=TrapeziumSection(w,M,m,h,Z,r,r0,x,type,flow,STARTVALUE,ENDVALUE,tol);
    Section=Section.*exp(-1i*bk*(x.'))/(2i*pi);
    steperr=min(abs(Section(J1x,:)./Steepest(J1x,:)),abs(Section(J1x,:)));
    Steepest=Steepest+Section;
    STARTVALUE=ENDVALUE;
    ENDVALUE=ENDVALUE-25i;
end
if max(steperr)>1e-4 && type~=2
    if type==0
        disp('Steepest Decent Ibk may be innacurate')
    else
        disp('Steepest Decent Ik0 may be innacurate')
    end
end

Steepest(x<0,:)=0;
branchpoint(x<0,:)=0;
end


function Section=TrapeziumSection(w,M,m,h,Z,r,r0,x,type,flow,STARTVALUE,ENDVALUE,TOL)
% Vectorized version using matrix-matrix multiplication instead of for
% loops.  Also, this version doesn't use AbsErr, as these integrals are
% going to be pretty much non-oscillatory, so we shouldn't need to worry
% about this too much.

N=100;
kval=linspace(STARTVALUE,ENDVALUE,N);
dist=kval(N)-kval(N-1);
Jump=GreensJump(w,M,m,h,Z,kval,r,r0,flow,type);
Jump(1,:) = 0.5*Jump(1,:);
Jump(N,:) = 0.5*Jump(N,:);
Section=dist*exp(x.'*imag(kval))*Jump;
Section(x<0,:)=0;
    
J1x=1;
for j1=1:length(x)
  if x(j1)>0 && abs(x(J1x))>=abs(x(j1))
    J1x=j1;
  end
end
    
Err = 1;
while Err>=TOL && abs(dist)>1e-10 
    OldSection = Section;
    Num=N+(N-1);
    dist=dist/2;
    Section = Section/2;
    kval = STARTVALUE + ((2:2:Num)-1)*(ENDVALUE-STARTVALUE)/(Num-1);
    Jump=GreensJump(w,M,m,h,Z,kval,r,r0,flow,type);
    Section = Section + dist*exp(x.'*imag(kval))*Jump;
    Section(x<0,:)=0;
    Err=max(max(abs(1 - Section(J1x,:)./OldSection(J1x,:))));
    N=Num;   
end
end

