function [p,dp]=SolutionsFD(w,M,m,h,Z,k,rend,flow,rMeshSize,solnnumber)

if nargin<7
   disp('Function for evaluating p and dp using a finite difference approach.')
 disp('inputs(w,M,m,h,Z,k,rend,flow,rMeshSize,solnnumber).')
 Value=input('Would you like input information? 0 N,1 Y :');
 if Value==1
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('h boundary layer thickness Scalar')
 disp('Z impedence')
 disp('k wave number Vector/Scalar')
 disp('rend Value of r for final evaluation')
 disp('Optional:')
 disp('flow 1 for linear, 2 for Quadratic shear flows. Defaults to 2')
 disp('rMeshSize number of r points used for finite difference, defaults to 2001')
 disp('solnnumber takes values 1 or 2, 1 evaluates solution from 1-h to rend. 2 evalautes solution from 1 to rend, unsing appropriate boundary conditions. Defaults to 1')
 end
 Value=input('Would you like output information? 0 N,1 Y :');
 if Value==1
     disp('p Matrix (length(k),1), values of p at r=rend. Finite difference on;ly used within r=[1-h,1] if r<1-h, Bessel functions are used. If solnnumber=2 Finite difference used for matching to boundary condition at r=1.')
     disp('dp Matrix (length(k),1), values of dp at r=rend.')
 end
 clear('Value')
 p=[];
 dp=[];
 return 
end

if nargin<8
    flow=2;
elseif flow~=1
    flow=2;    
end
if nargin<9
    rMeshSize=2001;
end
if nargin<10
    solnnumber=1;
end
%%k is a vector
if solnnumber==1
    N=rMeshSize;
    alpha=sqrt((w-M*k).^2 -k.^2).';
    k=k.';
    Soln=besselj(m,alpha.*(1-h));
    delta=(rend-(1-h))/(N-1);
    dSoln=(alpha/2).*(besselj(m-1,alpha.*[1-h-delta,1-h])-besselj(m+1,alpha.*[1-h-delta,1-h]));
    if rend<=1-h
        p=besselj(m,alpha.*rend);
        dp=(alpha/2).*(besselj(m-1,alpha.*rend)-besselj(m+1,alpha.*rend));
        return
    end
    for n=1:N
        r=1-h+(n-1)*delta;
        if flow==1
            U=M*(1-r)/h;
            dU=-M/h;
        else
            U=M*(1-(1-(1-r)/h).^2);
            dU=(-2*M/h)*(1-(1-r)/h);
        end
        A=((2*k.*dU)./((w.')-k.*U)) + (1./r);
        B=((w.')-U.*k).^2 - k.^2 - (m./r).^2;

        dNew=dSoln(:,1)-(2*delta)*A.*dSoln(:,2)-(2*delta)*B(:).*Soln;
        dSoln(:,1)=dSoln(:,2);
        dSoln(:,2)=dNew;
        Soln=Soln+delta*(dSoln(:,1)+dSoln(:,2))/2;
    end
    p=Soln;
    dp=dSoln(:,2);
else
    N=rMeshSize;
    k=k.';
    Soln=zeros(length(k),1)+1;
    rendtemp=rend;
    if rend<=1-h
        rend=1-h;
    end
    delta=-(rend-1)/(N-1);
    dSoln=zeros(length(k),2)+[-1i*w/Z,0];
    r=1;
    if flow==1
        U=M*(1-r)/h;
        dU=-M/h;
    else
        U=M*(1-(1-(1-r)/h).^2);
        dU=(-2*M/h)*(1-(1-r)/h);
    end
    A=((2*k.*dU)./(w-k.*U)) + (1./r);
    B=(w-U.*k).^2 - k.^2 - (m./r).^2;
    dNew=dSoln(:,1)+(delta)*A.*dSoln(:,1)+(delta)*B(:).*Soln;
    dSoln(:,2)=dSoln(:,1);
    dSoln(:,1)=dNew;
    Soln=Soln-delta*(dSoln(:,1)+dSoln(:,2))/2;
    
for n=2:N
    r=1-(n-1)*delta;
    if flow==1
        U=M*(1-r)/h;
        dU=-M/h;
    else
        U=M*(1-(1-(1-r)/h).^2);
        dU=(-2*M/h)*(1-(1-r)/h);
    end
    A=((2*k.*dU)./(w-k.*U)) + (1./r);
    B=(w-U.*k).^2 - k.^2 - (m./r).^2;
    dNew=dSoln(:,2)+(2*delta)*A.*dSoln(:,1)+(2*delta)*B(:).*Soln;
    dSoln(:,2)=dSoln(:,1);
    dSoln(:,1)=dNew;
    Soln=Soln-delta*(dSoln(:,1)+dSoln(:,2))/2;
end
if rend==rendtemp
p=Soln;
dp=dSoln(:,2);
else
    p=Soln;
    dp=dSoln(:,2);
    alpha=sqrt((w-M*k).^2 -k.^2);
    H1=besselh(m,1,alpha.*(1-h));
    dH1=(alpha/2).*(besselh(m-1,1,alpha.*(1-h))-besselh(m+1,1,alpha.*(1-h)));
    H2=besselh(m,2,alpha.*(1-h));
    dH2=(alpha/2).*(besselh(m-1,2,alpha.*(1-h))-besselh(m+1,2,alpha.*(1-h)));
    C2=(1i*pi*(1-h)/4).*(dH2.*p-H2.*dp); 
    D2=-(1i*pi*(1-h)/4).*(dH1.*p-H1.*dp);
    H1=besselh(m,1,alpha.*rendtemp);
    dH1=(alpha/2).*(besselh(m-1,1,alpha.*rendtemp)-besselh(m+1,1,alpha.*rendtemp));
    H2=besselh(m,2,alpha.*rendtemp);
    dH2=(alpha/2).*(besselh(m-1,2,alpha.*rendtemp)-besselh(m+1,2,alpha.*rendtemp));
    p=C2.*H1+D2.*H2;
    dp=C2.*dH1+D2.*dH2;
end
end
    
end