function[psi1,psi2,dpsi1,dpsi2,Disp,Coeffs,p1,p2,dp1,dp2]=Solutions(w,M,m,h,Z,k,r,Branchbk,Branchkr,flow,Scale)
%% Function for evaluating psi1 and psi2 for a given parameter set.
if nargin<7
 disp('Function for evaluating psi1 and psi2 for a given parameter set.')
 disp('inputs(w,M,m,h,Z,k,r,Branchbk,Branchkr,flow).')
 Value=input('Would you like input information? 0 N,1 Y :');
 if Value==1
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('h boundary layer thickness Scalar')
 disp('Z impedence Scalar')
 disp('k wave number Vector/Scalar')
 disp('r radial location vector/Scalar')
 disp('Optional:')
 disp('Branchbk For considering solutions as if above or below wrt bk=omega/M. takes values -1,1,0. Defaults to 0. -1 views as if below the branch cut. 1 views as if above the branch cut. 0 views however is natural for specific value of k.')
 disp('Branchkr As Branchbk but for the kr branch point. Vector valued as above, same length as r. If scalar will apply to all values of r.')
 disp('flow either 1 or 2, 1 for linear sheared flow, 2 for quadratic sheared flow, defaults to 2')
 disp('Scale either 0, 1 or 2, will scale outputs of psi1, C1 and D1 by exp(-abs(imag(alpha*(1-h)))) if 1. 2 further Scales C1,D1 and psi1 by W(1-h) and C2g,D2g,C2l,D2l and psi2 by W(1). Defaults to 0')
 end
 Value=input('Would you like output information? 0 N,1 Y :');
 if Value==1
     disp('returns [psi1,psi2,dpsi1,dpsi2,Disp,Coeffs,p1,p2,dp1,dp2]')
     disp('psi1 Matrix (length(k),length(r)), values of psi_1')
     disp('psi2 Matrix (length(k),length(r)), values of psi_2')
     disp('dpsi1 Matrix (length(k),length(r)), values of (d psi_1 / d r) ')
     disp('dpsi2 Matrix (length(k),length(r)), values of (d psi_2 / d r) ')
     disp('Disp vector (length(k),1) evaluation of C_1*D_2-C_2*D_1 for different k values')
     disp('Coeffs Matrix (length(k),6) evaluations of C_1 D_1 C_2g D_2g C_2l and D_2l for different k values in columns')
     disp('p1 Matrix (length(k),length(r)), values of p_1, if r<1-h, evaluates at 1-h instead')
     disp('p2 Matrix (length(k),length(r)), values of p_2, if r<1-h, evaluates at 1-h instead')
     disp('dp1 Matrix (length(k),length(r)), values of (d p_1 / d r), if r<1-h, evaluates at 1-h instead')
     disp('dp2 Matrix (length(k),length(r)), values of (d p_2 / d r), if r<1-h, evaluates at 1-h instead')
 end
 clear('Value')
 psi1=[];
 psi2=[];
 dpsi1=[];
 dpsi2=[];
 Disp=[];
 Coeffs=[];
 p1=[];
 p2=[];
 dp1=[];
 dp2=[];
 return
end
if nargin<8
    Branchbk=0;
end
if nargin<9
    Branchkr=zeros(length(r));
end
if length(Branchkr)~=length(r)
    Branchkr=zeros(size(r))+Branchkr(1);
end
if nargin<10
    flow=2;
end
if nargin<11 || Scale~=1 || Scale~=2
    Scale=0;
end
[A,B]=size(k);
if A~=1 && B~=1
    disp('k must be a vector or scalar')
    psi1=[];
    psi2=[];
    dpsi1=[];
    dpsi2=[];
    Disp=[];
    Coeffs=[];
    p1=[];
    p2=[];
    dp1=[];
    dp2=[];
    return
end
if B<A
    k=k.';
end
[A,B]=size(r);
if A~=1 && B~=1
    disp('r must be a vector or scalar')
    psi1=[];
    psi2=[];
    dpsi1=[];
    dpsi2=[];
    Disp=[];
    Coeffs=[];
    p1=[];
    p2=[];
    dp1=[];
    dp2=[];
    return
end
if B<A
    r=r.';
end
A=max(max(length(w),length(M)),max(max(length(m),length(h)),length(Z)));
B=min(min(length(w),length(M)),min(min(length(m),length(h)),length(Z)));
if A~=1 || B~=1
 disp('inputs(w,M,m,h,Z,k,r,Branchbk,Branchkr).')
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('h boundary layer thickness Scalar')
 disp('Z impedence Scalar')
 psi1=[];
 psi2=[];
 dpsi1=[];
 dpsi2=[];
 Disp=[];
 Coeffs=[];
 p1=[];
 p2=[];
 dp1=[];
 dp2=[];
 return
end
clear('A','B')
if Branchbk~=0 && Branchbk~=1 && Branchbk~=-1
    Branchbk=0;
end
Branchkr(floor(Branchkr)~=Branchkr)=0;
Branchkr(sign(Branchkr).*mod(Branchkr,2)~=Branchkr)=0;
if length(flow)~=1 || flow~=1
    flow=2;
end

 %% Evaluates interior of domain
rint=[r,1-h];
alpha=sqrt( (w-M.*(k.')).^2 - (k.').^2 );
if Scale>=1
   J=besselj(m,alpha.*rint,1).*exp(abs(imag(alpha.*rint))-abs(imag(alpha*(1-h))));
   dJ=alpha.*(1/2).*(besselj(m-1,alpha.*rint,1)-besselj(m+1,alpha.*rint,1)).*exp(abs(imag(alpha.*rint))-abs(imag(alpha*(1-h))));
else
   J=besselj(m,alpha.*rint);
   dJ=alpha.*(1/2).*(besselj(m-1,alpha.*rint)-besselj(m+1,alpha.*rint));
end
H1=besselh(m,1,alpha.*rint,1).*exp(+1i*alpha.*rint-1i*alpha*(1-h));
H2=besselh(m,2,alpha.*rint,1).*exp(-1i*alpha.*rint+1i*alpha*(1-h)); 
% dH1=alpha.*(1/2).*(besselh(m-1,1,alpha.*rint,1)-besselh(m+1,1,alpha.*rint,1)).*exp(+1i*alpha.*rint-1i*alpha*(1-h));
% dH2=alpha.*(1/2).*(besselh(m-1,2,alpha.*rint,1)-besselh(m+1,2,alpha.*rint,1)).*exp(-1i*alpha.*rint+1i*alpha*(1-h));
dH1=alpha.*((m./(alpha.*rint)).*besselh(m,1,alpha.*rint,1)-besselh(m+1,1,alpha.*rint,1)).*exp(+1i*alpha.*rint-1i*alpha*(1-h));
dH2=alpha.*((m./(alpha.*rint)).*besselh(m,2,alpha.*rint,1)-besselh(m+1,2,alpha.*rint,1)).*exp(-1i*alpha.*rint+1i*alpha*(1-h));

%% Evaluates Sheared region
rbnd=[r,1-h,1];
rbnd(rbnd<1-h)=1-h;
Branch=Branchkr;
Branch(r<1-h)=0;
Branch=[Branch,Branchbk,0];

if flow==1
    [p1,p2,dp1,dp2,~]=LinearShear(w,M,m,h,k,rbnd,Branch);
else
    [p1,p2,dp1,dp2,~]=QuadraticShear(w,M,m,h,k,rbnd,Branch);
end

%% Constructs Coefficients for psi1 and psi2
    C1=J(:,end).*dp2(:,end-1)-dJ(:,end).*p2(:,end-1);
    D1=-J(:,end).*dp1(:,end-1)+dJ(:,end).*p1(:,end-1);
    C2g=dp2(:,end)+(1i*w/Z).*p2(:,end);
    D2g=-(dp1(:,end)+(1i*w/Z).*p1(:,end));
    ps=C2g.*p1(:,end-1)+D2g.*p2(:,end-1);
    dps=C2g.*dp1(:,end-1)+D2g.*dp2(:,end-1);
    C2l=(dH2(:,end).*ps-H2(:,end).*dps)*(-pi*(1-h)/4i);
    D2l=-(dH1(:,end).*ps-H1(:,end).*dps)*(-pi*(1-h)/4i);
%     clear('ps','dps')
if Scale~=2
    if flow==1
       rc=1-w*h./(M*(k.'));
       Wh=-3*(rc/(1-h)).*(1-h-rc).^2;
       W1=-3*rc.*(1-rc).^2;
       clear('rc')
    else
       Q=h*sqrt(1-w./(M.*(k.')));
       rcp=1-h+Q;
       Wh=(-3/4)*(rcp/(1-h)).*(Q).^2;
       W1=(-3/4)*rcp.*((h-Q).^2).*((h+Q).^2)./(Q.^2);
       clear('rcp','Q')
    end
    C1=C1./Wh;
    D1=D1./Wh;
    C2g=C2g./W1;
    D2g=D2g./W1;
    C2l=C2l./W1;
    D2l=D2l./W1;
    clear('W1','Wh')
end
Coeffs=[C1,D1,C2g,D2g,C2l,D2l];
Disp=C1.*D2g-D1.*C2g;

%% Constructs homogenous solutions
p1=p1(:,1:end-2);
dp1=dp1(:,1:end-2);
p2=p2(:,1:end-2);
dp2=dp2(:,1:end-2);
J=J(:,1:end-1);
H1=H1(:,1:end-1);
H2=H2(:,1:end-1);
dJ=dJ(:,1:end-1);
dH1=dH1(:,1:end-1);
dH2=dH2(:,1:end-1);

psi1=J.*(r<=1-h) + (C1.*p1+D1.*p2).*(r>1-h);
dpsi1=dJ.*(r<=1-h) + (C1.*dp1+D1.*dp2).*(r>1-h);
psi2=(C2l.*H1+D2l.*H2).*(r<1-h) + (C2g.*p1+D2g.*p2).*(r>=1-h);
dpsi2=(C2l.*dH1+D2l.*dH2).*(r<1-h) + (C2g.*dp1+D2g.*dp2).*(r>=1-h);

end

