function[p1,p2,dp1,dp2,Err]=QuadraticShear(w,M,m,h,k,r,Branch)
toll=eps;
if nargin<6
 disp('Function for evaluating p1 and p2 for a given parameter set in Quadratic Sheared flow.')
 disp('inputs(w,M,m,h,k,r,Branch).')
 Value=input('Would you like input information? 0 N,1 Y :');
 if Value==1
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('h boundary layer thickness Scalar')
 disp('k wave number Vector/Scalar')
 disp('r radial location vector/Scalar')
 disp('Optional:')
 disp('Branch RowVector of -1,0 and 1 of length(r) defaults to 0, reffers to if branch cut from rcp should be taken above or below. Can be given as scalar for single value applied to all')
 end
 Value=input('Would you like output information? 0 N,1 Y :');
 if Value==1
     disp('p1 Matrix (length(k),length(r)), values of p_1, if r<1-h, evaluates at 1-h instead')
     disp('p2 Matrix (length(k),length(r)), values of p_2, if r<1-h, evaluates at 1-h instead')
     disp('dp1 Matrix (length(k),length(r)), values of (d p_1 / d r), if r<1-h, evaluates at 1-h instead')
     disp('dp2 Matrix (length(k),length(r)), values of (d p_2 / d r), if r<1-h, evaluates at 1-h instead')
     disp('Err Tensor (length(k),length(r),4), Sum Square Errors for the sum terms in p1 p2 dp1 and dp2 and (k,r)')
 end
 clear('Value')
 p1=[];
 p2=[];
 dp1=[];
 dp2=[];
 Err=[];
 return
end
[A,B]=size(k);
if A~=1 && B~=1
    disp('k must be a vector or scalar')
    p1=[];
    p2=[];
    dp1=[];
    dp2=[];
    Err=[];
    return
end
if B<A
    k=k.';
end
[A,B]=size(r);
if A~=1 && B~=1
    disp('k must be a vector or scalar')
    p1=[];
    p2=[];
    dp1=[];
    dp2=[];
    Err=[];
    return
end
if B<A
    r=r.';
end
if nargin<7
    Branch=zeros(1,length(r));
end
if size(Branch)~=size(r)
    Branch=zeros(1,length(r))+Branch(1);
end
Branch(floor(Branch)~=Branch)=0;
Branch(sign(Branch).*mod(Branch,2)~=Branch)=0;
A=max(max(length(w),length(M)),max(length(m),length(h)));
B=min(min(length(w),length(M)),min(length(m),length(h)));
if A~=1 || B~=1
 disp('inputs(w,M,m,h,k,r,Branch).')
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('h boundary layer thickness Scalar')
 p1=[];
 p2=[];
 dp1=[];
 dp2=[];
 Err=[];
 return
end
clear('A','B')

k=k.';
Q=h*sqrt(1-w./(M*k));
rmin=max(zeros(size(k))+1-h, 1-abs(h-Q) );
rmax=min( 1-h+real(Q)+sqrt( real(Q).^2 + 3*abs(Q).^2 ) , zeros(size(k))+1);
rm=(rmin+rmax)/2;
rcp=1-h+Q;
Rc=r-1+h-Q;
R1=zeros(length(k),length(r))+r-1;
Rc(r>rm)=0;
R1(r<rm)=0;
Rc=[Rc,rm-1+h-Q];
R1=[R1,rm-1];

an=zeros(length(k),length(r)+1,6);
bn=zeros(length(k),length(r)+1,6);
Sa=zeros(length(k),length(r)+1,4);
Sb=zeros(length(k),length(r)+1,6);
an(:,:,1)=1;
bn(:,:,1)=1;
pc1=Rc.^3;
dpc1=3*Rc.^2;
pc2=zeros(size(Rc))+1;
dpc2=zeros(size(Rc));
AbsSumSq=zeros(length(k),length(r)+1,4);
Scale=rmax-rcp;
n=0;
tn=zeros(length(k),4);
A=((1./rcp - 1./Q).*( k.^2 + (m./rcp).^2 )/3) -(2*m^2)./(3*rcp.^3);
QUESTION=1;
term=zeros(length(k),length(r)+1,4);
Errtoll=10^(-3); 
while QUESTION>toll
    n=n+1;
    Sa(:,:,1)=(-Scale./rcp).*(Sa(:,:,1)+(n+2)*an(:,:,1));
    Sa(:,:,2)=(-Scale./(2*Q)).*(Sa(:,:,2)+(n+2)*an(:,:,1));
    Sa(:,:,3)=(-Scale./rcp).*(Sa(:,:,3)+(-Scale./rcp).*an(:,:,2));
    Sa(:,:,4)=(-Scale./rcp).*(Sa(:,:,4)+(-Scale./rcp).*(n-2).*an(:,:,2));
    T1=(k.^2).*(Scale.^2).*an(:,:,2);
    T2=((k*M/(h^2)).^2).*((Scale.^6).*an(:,:,6)+4*(Scale.^5).*Q.*an(:,:,5)+4*(Scale.^4).*(Q.^2).*an(:,:,4));
    an(:,:,6)=an(:,:,5);
    an(:,:,5)=an(:,:,4);
    an(:,:,4)=an(:,:,3);
    an(:,:,3)=an(:,:,2);
    an(:,:,2)=an(:,:,1);
    an(:,:,1)=(T1-T2+Sa(:,:,1)-2*Sa(:,:,2)+(m^2)*(n-1)*Sa(:,:,3)-(m^2)*Sa(:,:,4))/(n*(n+3));
    
    Sb(:,:,1)=(-Scale./rcp).*(Sb(:,:,1)+(n-1)*bn(:,:,1));
    Sb(:,:,2)=(-Scale./(2*Q)).*(Sb(:,:,2)+(n-1)*bn(:,:,1));
    Sb(:,:,3)=(-Scale./rcp).*(Sb(:,:,3)+(-Scale./rcp).*bn(:,:,2));
    Sb(:,:,4)=(-Scale./rcp).*(Sb(:,:,4)+(-Scale./rcp).*(n-2).*bn(:,:,2));
    Sb(:,:,5)=(-Scale./rcp).*(Sb(:,:,5)-an(:,:,5));
    Sb(:,:,6)=(-Scale./(2*Q)).*(Sb(:,:,6)-an(:,:,5));
    T1=(k.^2).*(Scale.^2).*bn(:,:,2);
    T2=((k*M/(h^2)).^2).*((Scale.^6).*bn(:,:,6)+4*(Scale.^5).*Q.*bn(:,:,5)+4*(Scale.^4).*(Q.^2).*bn(:,:,4));
    T3=(2*n-3)*an(:,:,4);
    bn(:,:,6)=bn(:,:,5);
    bn(:,:,5)=bn(:,:,4);
    bn(:,:,4)=bn(:,:,3);
    bn(:,:,3)=bn(:,:,2);
    bn(:,:,2)=bn(:,:,1);
    if n~=3
        bn(:,:,1)=(T1-T2-A.*(Scale.^3).*T3+Sb(:,:,1)-2*Sb(:,:,2)+(m^2)*(n-1)*Sb(:,:,3)-(m^2)*Sb(:,:,4)-A.*(Scale.^3).*(Sb(:,:,5)-2*Sb(:,:,6)))/(n*(n-3));
    else
        bn(:,:,1)=0;
    end
    term(:,:,1)=(Scale.^3).*an(:,:,1).*((Rc./Scale).^(n+3));
    term(:,:,2)=(n+3)*(Scale.^2).*an(:,:,1).*((Rc./Scale).^(n+2));
    term(:,:,3)=bn(:,:,1).*((Rc./Scale).^n);
    term(:,:,4)=n*(Scale.^-1).*bn(:,:,1).*((Rc./Scale).^(n-1));
    term(isnan(term))=0;
    term(isinf(term))=0;
    pc1=pc1+term(:,:,1);
    tn(:,1)=max(abs(term(:,:,1))./abs(pc1),[],2);
    dpc1=dpc1+term(:,:,2);
    tn(:,2)=max(abs(term(:,:,2))./abs(dpc1),[],2);
    pc2=pc2+term(:,:,3);
    tn(:,3)=max(abs(term(:,:,3))./abs(pc2),[],2);
    dpc2=dpc2+term(:,:,4);
    tn(:,4)=max(abs(term(:,:,4))./abs(dpc2),[],2);
    AbsSumSq(:,:,1)= AbsSumSq(:,:,1)+term(:,:,1).^2;
    AbsSumSq(:,:,2)= AbsSumSq(:,:,2)+term(:,:,2).^2;
    AbsSumSq(:,:,3)= AbsSumSq(:,:,3)+term(:,:,3).^2;
    AbsSumSq(:,:,4)= AbsSumSq(:,:,4)+term(:,:,4).^2;
    QUESTION=max(max(tn));
end
Err1=abs(eps*sqrt(AbsSumSq(:,:,1))./abs(pc1 ));
Err2=abs(eps*sqrt(AbsSumSq(:,:,2))./abs(dpc1));
Err3=abs(eps*sqrt(AbsSumSq(:,:,1))./abs(pc2 ));
Err4=abs(eps*sqrt(AbsSumSq(:,:,2))./abs(dpc2));
 pc1(Err1>Errtoll)=NaN;
dpc1(Err2>Errtoll)=NaN;
 pc2(Err3>Errtoll)=NaN;
dpc2(Err4>Errtoll)=NaN;
if min(isnan(pc1(:,end)+dpc1(:,end)+pc2(:,end)+dpc2(:,end)))==1
   kproblem=k(isnan(pc1(:,end)+ dpc1(:,end)+ pc2(:,end)+ dpc2(:,end)));
   fprintf('QuadraticShear: matching can not be completed at k=')
   fprintf('%g+%gi,',[real(kproblem(:).');imag(kproblem(:).')]);
   fprintf('\n');
   p1=pc1;
   p2=pc2;
   dp1=dpc1;
   dp2=dpc2;
   Err=[];
   
   return
end

aln=zeros(length(k),length(r)+1,6);
ben=zeros(length(k),length(r)+1,6);
Sal=zeros(length(k),length(r)+1,5);
Sbe=zeros(length(k),length(r)+1,5);
aln(:,:,1)=1;
ben(:,:,1)=1;
p11=R1;
dp11=zeros(size(R1))+1;
p12=zeros(size(R1))+1;
dp12=zeros(size(R1));

QUESTION=1;
n=0;
Scale=-h;
while QUESTION>toll
    n=n+1;
    Sal(:,:,1)=(-Scale)*(Sal(:,:,1)+n*aln(:,:,1));
    Sal(:,:,2)=(-Scale./(h+Q)).*(Sal(:,:,2)+n*aln(:,:,1));
    Sal(:,:,3)=(-Scale./(h-Q)).*(Sal(:,:,3)+n*aln(:,:,1));
    Sal(:,:,4)=(-Scale)*(Sal(:,:,4)-Scale*aln(:,:,2));
    Sal(:,:,5)=(-Scale)*(Sal(:,:,5)-Scale*(n-1)*aln(:,:,2));
    T1=(k.^2).*(Scale^2).*aln(:,:,2);
    T2=((k*M/(h^2)).^2).*((Scale^6).*aln(:,:,6)+4*(Scale^5)*h.*aln(:,:,5)+2*(3*h^2 -Q.^2).*(Scale^4).*aln(:,:,4)+4*h*(h^2-Q.^2).*(Scale^3).*aln(:,:,3)+(Scale^2).*aln(:,:,2).*((h^2-Q.^2).^2));
    aln(:,:,6)=aln(:,:,5);
    aln(:,:,5)=aln(:,:,4);
    aln(:,:,4)=aln(:,:,3);
    aln(:,:,3)=aln(:,:,2);
    aln(:,:,2)=aln(:,:,1);
    aln(:,:,1)=(T1-T2+Sal(:,:,1)-2*Sal(:,:,2)-2*Sal(:,:,3)+(m^2)*(n)*Sal(:,:,4)-(m^2)*Sal(:,:,5))/(n*(n+1));
    
    Sbe(:,:,1)=(-Scale)*(Sbe(:,:,1)+(n-1)*ben(:,:,1));
    Sbe(:,:,2)=(-Scale./(h+Q)).*(Sbe(:,:,2)+(n-1)*ben(:,:,1));
    Sbe(:,:,3)=(-Scale./(h-Q)).*(Sbe(:,:,3)+(n-1)*ben(:,:,1));
    Sbe(:,:,4)=(-Scale)*(Sbe(:,:,4)-Scale*ben(:,:,2));
    Sbe(:,:,5)=(-Scale)*(Sbe(:,:,5)-Scale*(n-1)*ben(:,:,2));
    T1=(k.^2).*(Scale^2).*ben(:,:,2);
    T2=((k*M/(h^2)).^2).*((Scale^6).*ben(:,:,6)+4*(Scale^5)*h.*ben(:,:,5)+2*(3*h^2 -Q.^2).*(Scale^4).*ben(:,:,4)+4*h*(h^2-Q.^2).*(Scale^3).*ben(:,:,3)+(Scale^2).*ben(:,:,2).*((h^2-Q.^2).^2));
    ben(:,:,6)=ben(:,:,5);
    ben(:,:,5)=ben(:,:,4);
    ben(:,:,4)=ben(:,:,3);
    ben(:,:,3)=ben(:,:,2);
    ben(:,:,2)=ben(:,:,1);
        
    if n~=1
        ben(:,:,1)=(T1-T2+Sbe(:,:,1)-2*Sbe(:,:,2)-2*Sbe(:,:,3)+(m^2)*(n)*Sbe(:,:,4)-(m^2)*Sbe(:,:,5))/(n*(n-1));
    else
        ben(:,:,1)=0;
    end
    
    term(:,:,1)=(Scale).*aln(:,:,1).*((R1./Scale).^(n+1));
    term(:,:,2)=(n+1)*aln(:,:,1).*((R1./Scale).^n);
    term(:,:,3)=ben(:,:,1).*((R1./Scale).^n);
    term(:,:,4)=n*(Scale.^-1).*ben(:,:,1).*((R1./Scale).^(n-1));
    term(isnan(term))=0;
    term(isinf(term))=0;
    p11=p11+term(:,:,1);
    tn(:,1)=max(abs(term(:,:,1))./abs(p11),[],2);
    dp11=dp11+term(:,:,2);
    tn(:,2)=max(abs(term(:,:,2))./abs(dp11),[],2);
    p12=p12+term(:,:,3);
    tn(:,3)=max(abs(term(:,:,3))./abs(p12),[],2);
    dp12=dp12+term(:,:,4);
    tn(:,4)=max(abs(term(:,:,4))./abs(dp12),[],2);
    
    QUESTION=max(max(tn));
end

 p1=zeros(length(k),length(r));
 p2=zeros(length(k),length(r));
dp1=zeros(length(k),length(r));
dp2=zeros(length(k),length(r));
Rc=r-1+h-Q;
Rc=[Rc,rm-1+h-Q];
Branch=[Branch,0];
logP = log( 1i.*Rc) - log( 1i);
logM = log(-1i.*Rc) - log(-1i);
log0 = logP.*(imag(Q)>=0) + logM.*(imag(Q)<0);
logR = (Branch==0).*log0 + (Branch==1).*logP + (Branch==-1).*logM;
pc2=  pc2 + A.*logR.* pc1;
dpc2= dpc2 + A.*logR.*dpc1 + A.*pc1./Rc;
pc1(r>rm)=0;
dpc1(r>rm)=0;
pc2(r>rm)=0;
dpc2(r>rm)=0;
p11(r<=rm)=0;
dp11(r<=rm)=0;
p12(r<=rm)=0;
dp12(r<=rm)=0;
for j1=1:length(k)
    coeff=[pc1(j1,end),  dpc1(j1,end) ; pc2(j1,end), dpc2(j1,end) ]/[p11(j1,end),  dp11(j1,end) ; p12(j1,end), dp12(j1,end) ];
     p1(j1,:)=coeff(1,1)*p11(j1,1:end-1)+coeff(1,2)*p12(j1,1:end-1)+pc1(j1,1:end-1);
    dp1(j1,:)=coeff(1,1)*dp11(j1,1:end-1)+coeff(1,2)*dp12(j1,1:end-1)+dpc1(j1,1:end-1);
     p2(j1,:)=coeff(2,1)* p11(j1,1:end-1)+coeff(2,2)* p12(j1,1:end-1)+ pc2(j1,1:end-1);
    dp2(j1,:)=coeff(2,1)*dp11(j1,1:end-1)+coeff(2,2)*dp12(j1,1:end-1)+dpc2(j1,1:end-1);
end

 Err=zeros(length(k),length(r),4);
 Err1m=Err1(:,end);
 Err2m=Err2(:,end);
 Err3m=Err3(:,end);
 Err4m=Err4(:,end);
 Err1=Err1(:,1:end-1);
 Err2=Err2(:,1:end-1);
 Err3=Err3(:,1:end-1);
 Err4=Err4(:,1:end-1);
 Err1(r>rm)=0;
 Err2(r>rm)=0;
 Err3(r>rm)=0;
 Err4(r>rm)=0;
 Err(:,:,1)=Err1+Err1m.*(r>rm);
 Err(:,:,2)=Err2+Err2m.*(r>rm);
 Err(:,:,3)=Err3+Err3m.*(r>rm);
 Err(:,:,4)=Err4+Err4m.*(r>rm);

end