 function kpole=Polereduct(k,w,M,m,Z,h,flow,branch)
 
 if nargin<8
 disp('Function for checking a list of poles in k for repetitions.')
 disp('inputs(k,w,M,m,Z,h,flow,branch).')
 Value=input('Would you like input information? 0 N,1 Y :');
 if Value==1
 disp('k wave number vector list of poles')
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('Z impedence Scalar')
 disp('h boundary layer thickness Scalar')
 disp('flow either 1 or 2, 1 for linear sheared flow, 2 for quadratic sheared flow, defaults to 2')
 disp('type =0,1,2 defaults to 0, jump due to bk, k0 or kr respectively')
 end
 Value=input('Would you like output information? 0 N,1 Y :');
 if Value==1
     disp('kpole vector of pole locations,  reduced from input k. Removed poles are based on proximety to other poles with dispersion relation closer to zero')
 end
 clear('Value')
 kpole=[];
 return
end
 
        [~,~,~,~,dispersion,~,~,~,~,~]=Solutions(w,M,m,h,Z,k,1-h,branch,0,flow,2);
        polecount=0;
        kpole=k;
    	while ~isempty(k)
            Newk=k;
            Newdisp=dispersion;
        	if isinf(k(1)) || isnan(k(1))
                k=k(2:length(k));
            	dispersion=dispersion(2:length(dispersion));
            elseif branch==1 && real(k(1))<w/M
                k=k(2:length(k));
                dispersion=dispersion(2:length(dispersion));
            elseif branch==-1 && real(k(1))<w/M
                k=k(2:length(k));
                dispersion=dispersion(2:length(dispersion));
            else
                polecount=polecount+1;
            	count=0;
            	K=k(1);
                    Distance=0.25;
            	dispK=dispersion(1);
                for j1=2:length(k)
                    if abs(K-k(j1))<Distance
                        if abs(dispersion(j1))<abs(dispK)
                    		K=k(j1);
                    		dispK=dispersion(j1);
                        end
                	elseif isinf(k(j1)) || isnan(k(j1))
                        
                    elseif branch==1 && real(k(j1))<w/M
                        
                    elseif branch==-1 && real(k(j1))<w/M
                    
                	else
               			count=count+1;
               			Newk(count)=k(j1);
               			Newdisp(count)=dispersion(j1);
                    end
                end
            	k=Newk(1:count);
            	dispersion=Newdisp(1:count);
            	kpole(polecount)=K;
        	end
    	end
	kpole=kpole(1:polecount);
end