function kpole=PoleLocateRK(ksearch,w,M,m,Z,h,flow,poltoll,MAXIMAG)

if nargin<6
 disp('Function for locating poles in the complex k plane for a given parameter set. Makes use of an adjusted secant method for Runge-Kutta approximated solutions.')
 disp('inputs(ksearch,w,M,m,Z,h,flow,poltoll,MAXIMAG).')
 Value=input('Would you like input information? 0 N,1 Y :');
 if Value==1
     disp('ksearch wave number, starting points Vector/Scalar')
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('Z impedence Scalar')
 disp('h boundary layer thickness Scalar')
 disp('Optional:')
 disp('flow takes values 1 or 2, for linear or quadratic shear flow, defaults to 2')
 disp('poltoll tollerence for finding zeros of the dispersion relation')
 disp('MAXIMAG value for cutting off poles located too with abs(imag(k))>MAXIMAG')
 end
 Value=input('Would you like output information? 0 N,1 Y :');
 if Value==1
     disp('kpole vector of located poles, may include some repetition if pole located more than once')
 end
 clear('Value')
 kpole=[];
 return
end

if nargin<7 || flow~=1
    flow=2;
end
if nargin<8
   poltoll=1e-8; 
end
if nargin==9
    Switch=1;
else
    Switch=0;
end

    k=[ksearch;ksearch];
    kpole=ksearch;
    [p,dp]=SolutionsRK(w,M,m,h,k(1,:),flow);
    A=dp;
    B=(1i*w/Z)*p;
    Disperse=A+B;
    Nor=max(abs(A),abs(B));
    ittcount=1;
    polecount=0;
    nextittcount=0;
    pert=0.00000000001;
    while ~isempty(k) && ittcount<=200
        [Pp,Pdp]=SolutionsRK(w,M,m,h,k(1,:)+pert,flow);
        PA=Pdp;
        PB=(1i*w/Z)*Pp;
        PNor=max(abs(PA),abs(PB));
        PDisp=PA+PB;
        v=(Disperse.*PNor.*(-pert)./(Disperse.*PNor-PDisp.*Nor)).';
        lambda=1;
        k(2,:)=k(1,:)-lambda*v;
        [p2,dp2]=SolutionsRK(w,M,m,h,k(2,:),flow);
        A2=dp2;
        B2=+(1i*w/Z)*p2;
        Nor2=max(abs(A2),abs(B2));
        Disp2=A2+B2;
        for j1=1:length(k(2,:))
            while lambda>eps && abs(Disp2(j1))>abs(Disperse(j1))
                lambda=(lambda^2)/2;
                k(2,j1)=k(1,j1)-lambda*v(j1);
                [p2(j1),dp2(j1)]=SolutionsRK(w,M,m,h,k(2,j1),flow);
                A2(j1)=dp2(j1);
                B2(j1)=(1i*w/Z)*p2(j1);
                Nor2(j1)=max(abs(A2(j1)),abs(B2(j1)));
                Disp2(j1)=A2(j1)+B2(j1);
            end
            lambda=1;
            if abs(Disp2(j1))<abs(Disperse(j1))   
                if abs(Disp2(j1)/Nor2(j1))<poltoll
                    polecount=polecount+1;
                    kpole(polecount)=k(2,j1);
                elseif Switch==1 && abs(imag(k(2,j1)))>MAXIMAG
                        
                else
                    nextittcount=nextittcount+1;
                    k(1,nextittcount)=k(2,j1);
                    Disperse(nextittcount)=Disp2(j1);
                    Nor(nextittcount)=Nor2(j1);
                end
            end
        end
        k=k(:,1:nextittcount);
        Disperse=Disperse(1:nextittcount);
        Nor=Nor(1:nextittcount);
        ittcount=ittcount+1;
        nextittcount=0;
    end
    kpole=kpole(1:polecount);
end


function [p,dp]=SolutionsRK(w,M,m,h,karray,flow)
% Solve Pridmore Brown using a Runge--Kutta shooting method


% Get sizes of p correct
p = complex(zeros(length(karray),1));
dp = complex(zeros(length(karray),1));

% Treat each value of k independently
% (attempt to do this in parallel, but needs the
% Matlab parallel toolkit to do this)
parfor j1 = 1:length(karray)
    k = karray(j1);
    alpha=sqrt((w-M*k).^2 -k.^2);
    
    % Initial conditions are y0 = [p,p'] at 1-h
    y0 = [besselj(m,alpha.*(1-h)); ...
        (alpha/2).*(besselj(m-1,alpha.*(1-h))-besselj(m+1,alpha.*(1-h)))];
    
    % Solve using Runge--Kutta with adaptive timestepping (could also try
    % ode15s or ode23s as stiff solvers, in case they perform better)
    [~,yarray] = ode45(@(r,y) OdeFun(r,y,w,M,m,h,k,flow), [1-h,1], y0);
    p(j1)=yarray(end,1);
    dp(j1)= yarray(end,2);
end
end

function dy = OdeFun(r,y,w,M,m,h,k,flow)
% y = [p;p'].  Calculate dy = [p';p'']
p = y(1);
dp = y(2);
if flow==1
    U=M*(1-r)/h;
    dU=-M/h;
else
    U=M*(1-(1-(1-r)/h).^2);
    dU=(-2*M/h)*(1-(1-r)/h);
end
A=(2*k.*dU)./(w-k.*U) + 1./r;
B=(w-U.*k).^2 - k.^2 - (m./r).^2;
ddp=-A*dp-B.*p;
dy=[dp;ddp];
end
