function kpole=PoleLocateFD(ksearch,w,M,m,Z,h,flow,poltoll,rMeshSize,MAXIMAG)

if nargin<6
 disp('Function for locating poles in the complex k plane for a given parameter set. Makes use of an adjusted secant method for finite difference approximated solutions.')
 disp('inputs(ksearch,w,M,m,Z,h,flow,poltoll,rMeshSize,MAXIMAG).')
 Value=input('Would you like input information? 0 N,1 Y :');
 if Value==1
     disp('ksearch wave number, starting points Vector/Scalar')
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('Z impedence Scalar')
 disp('h boundary layer thickness Scalar')
 disp('Optional:')
 disp('flow takes values 1 or 2, for linear or quadratic shear flow, defaults to 2')
 disp('poltoll tollerence for finding zeros of the dispersion relation')
 disp('rMeshSize number of points used for constructing p1 and p2 using finite difference')
 disp('MAXIMAG value for cutting off poles located too with abs(imag(k))>MAXIMAG')
 end
 Value=input('Would you like output information? 0 N,1 Y :');
 if Value==1
     disp('kpole vector of located poles, may include some repetition if pole located more than once')
 end
 clear('Value')
 kpole=[];
 return
end

if nargin<9
    rMeshSize=2001;
end

if nargin==10
    Switch=1;
else
    Switch=0;
end

    k=[ksearch;ksearch];
    kpole=ksearch;
    [p,dp]=SolutionsFD(w,M,m,h,Z,k(1,:),1,flow,rMeshSize,1);
    A=dp;
    B=(1i*w/Z)*p;
    Disperse=A+B;
    Nor=max(abs(A),abs(B));
    ittcount=1;
    polecount=0;
    nextittcount=0;
    pert=0.00000000001;
    while ~isempty(k) && ittcount<=200
        [Pp,Pdp]=SolutionsFD(w,M,m,h,Z,k(1,:)+pert,1,flow,rMeshSize,1);
        PA=Pdp;
        PB=(1i*w/Z)*Pp;
        PNor=max(abs(PA),abs(PB));
        PDisp=PA+PB;
        v=(Disperse.*PNor.*(-pert)./(Disperse.*PNor-PDisp.*Nor)).';
        lambda=1;
        k(2,:)=k(1,:)-lambda*v;
        [p2,dp2]=SolutionsFD(w,M,m,h,Z,k(2,:),1,flow,rMeshSize,1);
        A2=dp2;
        B2=+(1i*w/Z)*p2;
        Nor2=max(abs(A2),abs(B2));
        Disp2=A2+B2;
        for j1=1:length(k(2,:))
            while lambda>eps && abs(Disp2(j1))>abs(Disperse(j1))
                lambda=(lambda^2)/2;
                k(2,j1)=k(1,j1)-lambda*v(j1);
                [p2(j1),dp2(j1)]=SolutionsFD(w,M,m,h,Z,k(2,j1),1,flow,rMeshSize,1);
                A2(j1)=dp2(j1);
                B2(j1)=(1i*w/Z)*p2(j1);
                Nor2(j1)=max(abs(A2(j1)),abs(B2(j1)));
                Disp2(j1)=A2(j1)+B2(j1);
            end
            lambda=1;
            if abs(Disp2(j1))<abs(Disperse(j1))   
                if abs(Disp2(j1)/Nor2(j1))<poltoll
                    polecount=polecount+1;
                    kpole(polecount)=k(2,j1);
                elseif Switch==1 && abs(imag(k(2,j1)))>MAXIMAG
                    
                else
                    nextittcount=nextittcount+1;
                    k(1,nextittcount)=k(2,j1);
                    Disperse(nextittcount)=Disp2(j1);
                    Nor(nextittcount)=Nor2(j1);
                end
            end
        end
        k=k(:,1:nextittcount);
        Disperse=Disperse(1:nextittcount);
        Nor=Nor(1:nextittcount);
        ittcount=ittcount+1;
        nextittcount=0;
    end
    kpole=kpole(1:polecount);
end