function kpole=PoleLocate(ksearch,w,M,m,Z,h,flow,branch,poltoll,MAXIMAG)
    
if nargin<6
 disp('Function for locating poles in the complex k plane for a given parameter set. Makes use of an adjusted secant method.')
 disp('inputs(ksearch,w,M,m,Z,h,flow,branch,poltoll,MAXIMAG).')
 Value=input('Would you like input information? 0 N,1 Y :');
 if Value==1
     disp('ksearch wave number, starting points Vector/Scalar')
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('Z impedence Scalar')
 disp('h boundary layer thickness Scalar')
 disp('Optional:')
 disp('flow takes values 1 or 2, for linear or quadratic shear flow, defaults to 2')
 disp('branch takes values -1,0,1, for evaluations below -1 or above 1 the branch cut, 0 considers above or below based on imag(k), defaults to 0')
 disp('poltoll tollerence for finding zeros of the dispersion relation')
 disp('MAXIMAG value for cutting off poles located too with abs(imag(k))>MAXIMAG')
 end
 Value=input('Would you like output information? 0 N,1 Y :');
 if Value==1
     disp('kpole vector of located poles, may include some repetition if pole located more than once')
 end
 clear('Value')
 kpole=[];
 return
end



if nargin==10
    Switch=1;
else
    Switch=0;
end
    k=[ksearch;ksearch];
    kpole=ksearch;
    [~,~,~,~,Disperse,coeffs,~,~,~,~]=Solutions(w,M,m,h,Z,k(1,:),1-h,branch,0,flow,2);
     A=coeffs(:,1).*coeffs(:,4);
     B=coeffs(:,2).*coeffs(:,3);
    
     Nor=max(abs(A),abs(B));
    ittcount=1;
    polecount=0;
    nextittcount=0;
    pert=1e-6; % Was 1e-11
    while ~isempty(k) && ittcount<=200
        [~,~,~,~,PDisp,Pcoeffs,~,~,~,~]=Solutions(w,M,m,h,Z,k(1,:)+pert,1-h,branch,0,flow,2);
        PA=Pcoeffs(:,1).*Pcoeffs(:,4);
        PB=Pcoeffs(:,2).*Pcoeffs(:,3);
        PNor=max(abs(PA),abs(PB));

        v=(Disperse.*PNor.*(-pert)./(Disperse.*PNor-PDisp.*Nor)).';
        lambda=1;
        k(2,:)=k(1,:)-lambda*v;
        [~,~,~,~,Disp2,coeffs2,~,~,~,~]=Solutions(w,M,m,h,Z,k(2,:),1-h,branch,0,flow,2);
        A2=coeffs2(:,1).*coeffs2(:,4);
        B2=coeffs2(:,2).*coeffs2(:,3);
        Nor2=max(abs(A2),abs(B2));
        
        for j1=1:length(k(2,:))
            while lambda>eps && abs(Disp2(j1))>abs(Disperse(j1))
                lambda=(lambda^2)/2;
                k(2,j1)=k(1,j1)-lambda*v(j1);
                [~,~,~,~,Disp2(j1),coeffs2(j1,:),~,~,~,~]=Solutions(w,M,m,h,Z,k(2,j1),1-h,branch,0,flow,2);
                A2(j1)=coeffs2(j1,1).*coeffs2(j1,4);
                B2(j1)=coeffs2(j1,2).*coeffs2(j1,3);
                Nor2(j1)=max(abs(A2(j1)),abs(B2(j1)));
                
            end
            lambda=1;
            if abs(Disp2(j1))<abs(Disperse(j1))   
                if abs(Disp2(j1)/Nor2(j1))<poltoll
                    polecount=polecount+1;
                    kpole(polecount)=k(2,j1);
                elseif Switch==1 && abs(imag(k(2,j1)))>MAXIMAG
                    
                elseif isfinite(k(2,j1))
                    nextittcount=nextittcount+1;
                    k(1,nextittcount)=k(2,j1);
                    Disperse(nextittcount)=Disp2(j1);
                    Nor(nextittcount)=Nor2(j1);
                end
            end
        end
        k=k(:,1:nextittcount);
        Disperse=Disperse(1:nextittcount);
        Nor=Nor(1:nextittcount);
        ittcount=ittcount+1;
        nextittcount=0;
    end
    kpole=kpole(1:polecount);
end