function [kpole,kpoleImagwTrack,ImagwTrack]=PoleFinder(w,M,m,h,Mass,Spring,Damper,flow,Track,kpoleInput)

if nargin<7
    disp('Function for locating poles for a given parameter set, also tracks these poles under the Br-ggs-Bers criterion when requested')
    disp('inputs(w,M,m,h,Mass,Spring,Damper,flow,Track).')
    Value=input('Would you like input information? 0 N,1 Y :');
    if Value==1
        disp('w value of omega Scalar')
        disp('M mach number Scalar')
        disp('m wave mode Scalar')
        disp('h boundary layer thickness Scalar')
        disp('Mass Mass term for a MSD Impedence Z(omega)')
        disp('Spring Spring term for a MSD Impedence Z(omega)')
        disp('Damper Damper term for a MSD Impedence Z(omega)')
        disp(' Z(omega)=Damper +1i Mass omega - 1i Spring / omega ')
        disp('Optional:')
        disp('flow 1 or 2 for linear or quadratic shear flow, defaults to 2')
        disp('Track if 1 will track pole locations to decide contributing alf plane under Briggs-Bers. Defaults to 0.')
        disp('If kpoleInput is present, use kpoleInput(:,1) for pole values rather than searching for poles, with kpoleInput(:,2) indicating k+ and k- poles.')
        Value=input('Would you like output information? 0 N,1 Y :');
        if Value==1
            disp('kpole, matrix (INT1,4) location of the pole, branch cut required, half plane of origin under Briggs-Bers, value of omega used for this')
            disp('kpoleImagwTrack, matrix (INT1,INT2) tracking of pole location under imag(omega) to -inf corresponding omega values in ImagwTrack')
            disp('ImagwTrack, matrix (INT1,INT2) as above but values of omega for pole.')
        end
    end
    clear('Value')
    kpole=[];
    kpoleImagwTrack=[];
    ImagwTrack=[];
    return
end

Z=Damper+1i*w*Mass-1i*Spring/w;
poltoll=0.000001;
%% Pole Finding
if nargin<8 || flow~=1
    flow=2;
end
if nargin<9 || Track~=1
   Track=0; 
end
if nargin<10
    kpoleInput = [];
end

if isempty(kpoleInput)
 kreal=linspace(-2*w/M,2*w/M,50);
 kimag=linspace(-500,500,500);
 ksearch=zeros(1,2*length(kreal)*length(kimag));
 for j1=1:length(kreal)
     for j2=1:length(kimag)
        ksearch(length(kimag)*(j1-1)+j2)=kreal(j1)+1i*kimag(j2)-0.1i;
        ksearch(length(kreal)*length(kimag)+length(kimag)*(j1-1)+j2)=kreal(j1)+ (kreal(2)-kreal(1))/2 +1i*kimag(j2)+1i* (kimag(2)-kimag(1))/2 -0.1i;
     end
 end
 kpoleFD=PoleLocateFD(ksearch,w,M,m,Z,h,flow,0.000001,2001,500);
 kpoleFD=Polereduct(kpoleFD,w,M,m,Z,h,flow,0);
 
 kreal=linspace(-3*w/M,2*w/M,50);
 kimag=linspace(-500,500,250);
 ksearch=zeros(1,2*length(kreal)*length(kimag));
 for j1=1:length(kreal)
     for j2=1:length(kimag)
        ksearch(length(kimag)*(j1-1)+j2)=kreal(j1)+1i*kimag(j2)-0.1i;
        ksearch(length(kreal)*length(kimag)+length(kimag)*(j1-1)+j2)=kreal(j1)+ (kreal(2)-kreal(1))/2 +1i*kimag(j2)+1i* (kimag(2)-kimag(1))/2 -0.1i;
     end
 end
 
 kpoleRK=PoleLocateRK([ksearch,kpoleFD],w,M,m,Z,h,flow,0.000001,500);
 kpoleRK=Polereduct(kpoleRK,w,M,m,Z,h,flow,0);
 
 kreal=linspace(-4*w/M,2*w/M,25);
 kimag=linspace(-500,500,250);
 ksearch=zeros(1,2*length(kreal)*length(kimag));
 for j1=1:length(kreal)
     for j2=1:length(kimag)
        ksearch(length(kimag)*(j1-1)+j2)=kreal(j1)+1i*kimag(j2)-0.1i;
        ksearch(length(kreal)*length(kimag)+length(kimag)*(j1-1)+j2)=kreal(j1)+ (kreal(2)-kreal(1))/2 +1i*kimag(j2)+1i* (kimag(2)-kimag(1))/2 -0.1i;
     end
 end
 kpoleFrob=PoleLocate([ksearch,kpoleFD,kpoleRK],w,M,m,Z,h,flow,0,0.00000001);
 kpoleFrob=Polereduct(kpoleFrob,w,M,m,Z,h,flow,0);
 
 kpoleAC=PoleLocateFD([kpoleFrob,kpoleFD,kpoleRK],w,M,m,Z,h,flow,0.000001,8001,500);
 kpoleAC=Polereduct(kpoleAC,w,M,m,Z,h,flow,0);
 
 %% Locating the k+ pole
 kreal=linspace(w/M,30*w/M,100);
 kimag=linspace(-600,600,100);
 ksearch=zeros(1,length(kreal)*length(kimag));
 for j1=1:length(kreal)
     for j2=1:length(kimag)
        ksearch(length(kimag)*(j1-1)+j2)=kreal(j1)+1i*kimag(j2)-0.1i;
     end
 end
 kpole=PoleLocate(ksearch,w,M,m,Z,h,flow,1,poltoll);
 
 if isempty(kpole)
     kpolep=[];
     disp('k plus pole has failed to be found')
     disp('further investigation is required!')
     disp('consider tracking poles in omega, Z or h using kpoleTrack')
 else
    kpolep=Polereduct(kpole,w,M,m,Z,h,flow,1);
    if isempty(kpolep)
        disp('k plus pole has failed to be found')
        disp('further investigation is required!')
        disp('consider tracking poles in omega, Z or h using kpoleTrack')
    end
    for j1=1:length(kpolep)
        if imag(kpolep(j1))>=0
            %%check if appears in modal sum
            points=[];
            number=0;
            for j2=1:length(kpoleAC)
                if abs(kpoleAC(j2)-kpolep(j1))<=1
                    %% 
                    [~,~,~,~,dispersion,~,~,~,~,~]=Solutions(w,M,m,h,Z,[kpolep(j1),kpoleAC(j2)],1-h,1,0,flow,2);
                    if dispersion(1)>=dispersion(2)
                        kpolep(j1)=kpoleAC(j2);
                    end
                    number=number+1;
                    points(number)=j2;
                end
            end
            temp=0;
            for j2=1:number
                kpoleAC(points(number)-temp)=[];
                temp=temp+1;
            end
        end
    end
 end
 
 %% Locating the k- pole
 kreal=linspace(w/M,30*w/M,100);
 kimag=linspace(-600,600,100);
 ksearch=zeros(1,length(kreal)*length(kimag));
 for j1=1:length(kreal)
     for j2=1:length(kimag)
        ksearch(length(kimag)*(j1-1)+j2)=kreal(j1)+1i*kimag(j2)-0.1i;
     end
 end
 kpole=PoleLocate(ksearch,w,M,m,Z,h,flow,-1,poltoll);
 
 if isempty(kpole)
     kpolem=[];
     disp('k minus pole has failed to be found')
     disp('further investigation is required!')
     disp('consider tracking poles in omega, Z or h using kpoleTrack')
 else
    kpolem=Polereduct(kpole,w,M,m,Z,h,flow,-1);
    if isempty(kpolem)
        disp('k minus pole has failed to be found')
        disp('further investigation is required!')
        disp('consider tracking poles in omega, Z or h using kpoleTrack')
    end
    for j1=1:length(kpolem)
        if imag(kpolem(j1))<0
            %%check if appears in modal sum
            points=[];
            number=0;
            for j2=1:length(kpoleAC)
                if abs(kpoleAC(j2)-kpolep(j1))<=1
                    [~,~,~,~,dispersion,~,~,~,~,~]=Solutions(w,M,m,h,Z,[kpolem(j1),kpoleAC(j2)],1-h,-1,0,flow,2);
                    if dispersion(1)>=dispersion(2)
                        kpolem(j1)=kpoleAC(j2);
                    end
                    number=number+1;
                    points(number)=j2;
                end
            end
            temp=0;
            for j2=1:number
                kpoleAC(points(number)-temp)=[];
                temp=temp+1;
            end
        end
    end
 end
else
    % Process given kpoleInput
    kpoleAC = kpoleInput(kpoleInput(:,2) ==  0, 1).';
    kpolep  = kpoleInput(kpoleInput(:,2) == +1, 1).';
    kpolem  = kpoleInput(kpoleInput(:,2) == -1, 1).';
end
  
 %% Decide which poles contribute to what Values of x (what half planes do they end up in after increasing -Im(omega) )
 if Track==1
     
 [Loc,omegaVal]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,1,-50,0,kpoleAC,flow);
 HalfPlane=zeros(length(kpoleAC),1);
 for j1=1:length(kpoleAC)
     if imag(Loc(j1,end))<0
         HalfPlane(j1)=-1;
     elseif imag(Loc(j1,end))>0
         HalfPlane(j1)=1;
     end
 end
 kpole=[kpoleAC.',zeros(length(kpoleAC),1),HalfPlane,omegaVal(:,end)];
 ImagwTrack=omegaVal;
 kpoleImagwTrack=Loc;
 
  if ~isempty(kpolep)
    HalfPlane=zeros(length(kpolep),1);
    [Loc,omegaVal]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,1,-50,1,kpolep,flow);
    for j1=1:length(kpolep)
         if imag(Loc(j1,end))<0
             HalfPlane(j1)=-1;
        elseif imag(Loc(j1,end))>0
             HalfPlane(j1)=1;
         end
    end
    kpole=[kpole;kpolep.',zeros(length(kpolep),1)+1,HalfPlane,omegaVal(:,end)];
    if length(omegaVal(1,:))>length(ImagwTrack(1,:))
        ImagwTrack=[ImagwTrack,zeros(length(ImagwTrack(:,1)),length(omegaVal(1,:))-length(ImagwTrack(1,:)))+ImagwTrack(:,end);omegaVal];
        kpoleImagwTrack=[kpoleImagwTrack,zeros(length(kpoleImagwTrack(:,1)),length(Loc(1,:))-length(kpoleImagwTrack(1,:)))+kpoleImagwTrack(:,end);Loc];
    elseif length(omegaVal(1,:))<length(ImagwTrack(1,:))
        ImagwTrack=[ImagwTrack;omegaVal,zeros(length(omegaVal(:,1)),-length(omegaVal(1,:))+length(ImagwTrack(1,:)))+omegaVal(:,end)];
        kpoleImagwTrack=[kpoleImagwTrack;Loc,zeros(length(Loc(:,1)),-length(Loc(1,:))+length(kpoleImagwTrack(1,:)))+Loc(:,end)];
    else
        ImagwTrack=[ImagwTrack;omegaVal];
        kpoleImagwTrack=[kpoleImagwTrack,;Loc];
    end
  end
 if ~isempty(kpolem)
    HalfPlane=zeros(length(kpolem),1);
    [Loc,omegaVal]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,1,-50,-1,kpolem,flow);
    for j1=1:length(kpolep)
         if imag(Loc(j1,end))<0
             HalfPlane(j1)=-1;
        elseif imag(Loc(j1,end))>0
             HalfPlane(j1)=1;
         end
    end
    kpole=[kpole;kpolem.',zeros(length(kpolem),1)-1,HalfPlane,omegaVal(:,end)];
    if length(omegaVal(1,:))>length(ImagwTrack(1,:))
        ImagwTrack=[ImagwTrack,zeros(length(ImagwTrack(:,1)),length(omegaVal(1,:))-length(ImagwTrack(1,:)))+ImagwTrack(:,end);omegaVal];
        kpoleImagwTrack=[kpoleImagwTrack,zeros(length(kpoleImagwTrack(:,1)),length(Loc(1,:))-length(kpoleImagwTrack(1,:)))+kpoleImagwTrack(:,end);Loc];
    elseif length(omegaVal(1,:))<length(ImagwTrack(1,:))
        ImagwTrack=[ImagwTrack;omegaVal,zeros(length(omegaVal(:,1)),-length(omegaVal(1,:))+length(ImagwTrack(1,:)))+omegaVal(:,end)];
        kpoleImagwTrack=[kpoleImagwTrack;Loc,zeros(length(Loc(:,1)),-length(Loc(1,:))+length(kpoleImagwTrack(1,:)))+Loc(:,end)];
    else
        ImagwTrack=[ImagwTrack;omegaVal];
        kpoleImagwTrack=[kpoleImagwTrack,;Loc];
    end
  end


 else
     kpole=[kpoleAC.',zeros(length(kpoleAC),1),zeros(length(kpoleAC),1)-1+2*(imag(kpoleAC.')>0),zeros(length(kpoleAC),1)]; 
     if~isempty(kpolep)
         kpole=[kpole ; kpolep.',zeros(length(kpolep),1)+1,zeros(length(kpolep),1)-1,zeros(length(kpolep),1) ];
     end
     if~isempty(kpolem)
         kpole=[kpole ; kpolem.',zeros(length(kpolem),1)-1,zeros(length(kpolem),1)-1,zeros(length(kpolem),1) ];
     end
     kpoleImagwTrack=[];
     ImagwTrack=[];
 end
  
    
end

