function Contribution=PoleContribution(w,M,m,h,Z,k,r,r0,x,Branchbk,Branchkr,Branchk0,flow,type)

if nargin<9
 disp('Function for evaluating the contribution from a mode for a given parameter set.')
 disp('inputs(w,M,m,h,Z,k,r,r0,x,Branchbk,Branchkr,Branchk0,flow,type).')
 Value=input('Would you like input information? 0 N,1 Y :');
 if Value==1
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('h boundary layer thickness Scalar')
 disp('Z impedence Scalar')
 disp('k wave number Must be Scalar')
 disp('r radial location vector/Scalar')
 disp('r0 source location scalar')
 disp('x distance down duct from source')
 disp('Optional:')
 disp('Branchbk For considering solutions as if above or below wrt bk=omega/M. takes values -1,1,0. Defaults to 0. -1 views as if below the branch cut. 1 views as if above the branch cut. 0 views however is natural for specific value of k.')
 disp('Branchkr As Branchbk but for the kr branch point. Vector valued as above, same length as r. If scalar will apply to all values of r.')
 disp('Branchk0 For considering solutions as if above or below wrt k0. takes values -1,1,0. Defaults to 0. -1 views as if below the branch cut. 1 views as if above the branch cut. 0 views however is natural for specific value of k.')
 disp('flow either 1 or 2, 1 for linear sheared flow, 2 for quadratic sheared flow, defaults to 2')
 disp('Type either 1 or 2, Method used to evaluate pole residue, if Type is 1 (default) we evaluate the pole by the formula, else we integrate around the pole')
 end
 Value=input('Would you like output information? 0 N,1 Y :');
 if Value==1
     disp('Contribution Matrix (length(x),length(r)), values of the pole residue at k in x and r for a source at r0')
 end
 clear('Value')
 Contribution=[];
 return
end
if length(k)~=1
    disp('k must be a scalar')
    Contribution=[];
    return
end
[A,B]=size(r);
if A~=1 && B~=1
    disp('r must be a vector or scalar')
    Contribution=[];
    return
end
if B<A
    r=r.';
end

if nargin<10
    Branchbk=0;
end
if nargin<11
    Branchkr=0;
end
if length(Branchkr)~=length(r)
    Branchkr=zeros(size(r))+Branchkr(1);
end
if nargin<12
    Branchk0=0;
end
if nargin<13
    flow=2;
end
if nargin<14
    type=1;
end

if Branchbk~=0 && Branchbk~=1 && Branchbk~=-1
    Branchbk=0;
end
Branchkr(floor(Branchkr)~=Branchkr)=0;
Branchkr(sign(Branchkr).*mod(Branchkr,2)~=Branchkr)=0;
if length(flow)~=1 || flow~=1
    flow=2;
end

%%Defines the flow based terms
if flow==1
    rcp=1-w*h./(k*M);
    Q=rcp-1+h;
    U=M.*(r0<=1-h)+M.*(1-(1-(1-r0)/h)).*(r0>1-h);
    W=((-3).*rcp.*(Q.^2)/(1-h)).*(r0<=1-h) + ((-3).*rcp.*((r0-rcp).^2)./(r0)).*(r0>1-h);
else
    Q=h*sqrt(1-w./(M*(k.')));
    rcp=1-h+Q;
    U=M.*(r0<=1-h)+M.*(1-(1-(1-r0)/h)^2).*(r0>1-h);
    W=((-3/4).*rcp.*(Q.^2)/(1-h)).*(r0<=1-h) + ((-3/4).*rcp.*((r0-rcp).^2).*((r0-(1-h-Q)).^2)./(r0.*Q.^2)).*(r0>1-h);
end
%%Defines the contribution, sign of x is included for if pole is
%%contributing above or below the branch cut for the modal sum, this may be
%%incorrect if k is unstable. and will require another multiple by -1.
if type==1
    %disp(sprintf('    PoleContribution: Calculating k=%g+%gi (type 1)',real(k),imag(k)));
    pert=1e-6; % Was 1e-9, when no DispM used
    [psi1,~,~,~,Disp,Coeffs,~,~,~,~]=Solutions(w,M,m,h,Z,k,[r,r0],Branchbk,[Branchkr,Branchk0],flow,2);
    [~,~,~,~,DispP,~,~,~,~,~]=Solutions(w,M,m,h,Z,k+pert,[r,r0],Branchbk,[Branchkr,Branchk0],flow,2);
    [~,~,~,~,DispM,~,~,~,~,~]=Solutions(w,M,m,h,Z,k-pert,[r,r0],Branchbk,[Branchkr,Branchk0],flow,2);
    DDisp=(DispP-DispM)./(2*pert); % Was (DispP-Disp)./pert
    Common=-sign(x.').*(w-U.*k).*exp(-1i.*k.*(x.'))./(2*pi*max(r0,1-h)*W.*DDisp);
    Varied=(Coeffs(:,4)./Coeffs(:,2)).*psi1(:,1:end-1).*psi1(end);
    Contribution=Common*Varied;
elseif type==1.5
    %disp(sprintf('    PoleContribution: Calculating k=%g+%gi (type 1.5)',real(k),imag(k)));
    pert=1e-9;
    rMeshSize=16000;
    [psi1P,dpsi1P]=SolutionsFD(w,M,m,h,Z,k+pert,1-h,flow,rMeshSize,1);
    [psi2P,dpsi2P]=SolutionsFD(w,M,m,h,Z,k+pert,1-h,flow,rMeshSize,2);
    if flow==1
        rcpP=1-w*h./((k+pert)*M);
        QP=rcpP-1+h;
        WP=((-3).*rcp.*(QP.^2)/(1-h));
    else
        QP=h*sqrt(1-w./(M*((k+pert).')));
        rcpP=1-h+Q;
        WP=((-3/4).*rcpP.*(QP.^2)/(1-h));
    end
    DispP=(psi1P.*dpsi2P-dpsi1P.*psi2P)./WP;
    [psi1,dpsi1]=SolutionsFD(w,M,m,h,Z,k,1-h,flow,rMeshSize,1);
    [psi2,dpsi2]=SolutionsFD(w,M,m,h,Z,k,1-h,flow,rMeshSize,2);
    if flow==1
        rcp=1-w*h./((k)*M);
        Q=rcp-1+h;
        W=((-3).*rcp.*(Q.^2)/(1-h));
    else
        Q=h*sqrt(1-w./(M*((k).')));
        rcp=1-h+Q;
        W=((-3/4).*rcp.*(Q.^2)/(1-h));
    end
    Disp=(psi1.*dpsi2-dpsi1.*psi2)./W;
    psi1=zeros(length(k),length(r));
    psi2=zeros(length(k),length(r));
    for j1=1:length(r)
        rj=r(j1);
        rMeshSize=16000;
        [psi1(:,j1),~]=SolutionsFD(w,M,m,h,Z,k,min(rj,r0),flow,rMeshSize,1);
        [psi2(:,j1),~]=SolutionsFD(w,M,m,h,Z,k,max(rj,r0),flow,rMeshSize,2);
    end
    DDisp=(DispP-Disp)./(pert);
    Common=-sign(x.').*(w-U.*k).*exp(-1i.*k.*(x.'))./(2*pi*max(r0,1-h)*W.*DDisp);
    Varied=psi1.*psi2;
    Contribution=Common*Varied;
elseif type==2
    %disp(sprintf('    PoleContribution: Calculating k=%g+%gi (type 2)',real(k),imag(k)));
    %clockwise
    R=min(0.01,abs(imag(k))/2);
    integrand = @(theta) FourierGreens(w,M,m,h,Z,k+R.*exp(1i.*theta),r,r0,Branchbk,Branchkr,Branchk0,flow).*exp(-R.*1i.*exp(1i.*theta).*(x.')+1i.*theta);
    Contribution=sign(x.').*(-1i*R*exp(-1i*k*(x.'))).*integral(integrand,3*pi/2,-pi/2 , 'ArrayValued',true )/(2*pi);
end