%%%%%%%%
%% Setup
set(0,'DefaultAxesFontName','Times')
set(0,'DefaultAxesFontSize',10)
widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
ContourFontSize=6; % Size of labels on contours

%%%%%%%%%%%
%% Figure 5
figure('units','centimeters','position',[5 -5 widthCM widthCM])
    load('SetA1_Q')
    tiledlayout(2,2,'TileSpacing','compact','Padding','compact');
    
    set(gca,'TickDir','out')
    nexttile
    set(gca,'TickDir','out')
    hold on
    xSta=-w/M;
    xFin=2*w/M;
    ySta=-100;
    yFin=100;
    for j1=1:length(kpole(:,1))-2
        plot(kpole(j1,1),'*r')
        if abs(imag(kpole(j1,1)))<yFin
            xSta=min(xSta,real(kpole(j1,1))-10);
        end
    end
    if imag(kpole(end-1,1))>0
        plot(kpole(end-1,1),'+r')
        xFin=max(xFin,real(kpole(end-1,1))+10);
        ySta=min(ySta,imag(kpole(end-1,1))-10);
        yFin=max(yFin,imag(kpole(end-1,1))+10);
    else
        plot(kpole(end-1,1),'+b')
        xFin=max(xFin,real(kpole(end-1,1))+10);
        ySta=min(ySta,imag(kpole(end-1,1))-10);
        yFin=max(yFin,imag(kpole(end-1,1))+10);
    end
    if imag(kpole(end,1))>0
        plot(kpole(end,1),'xb')
        xFin=max(xFin,real(kpole(end,1))+10);
        ySta=min(ySta,imag(kpole(end,1))-10);
        yFin=max(yFin,imag(kpole(end,1))+10);
    else
        plot(kpole(end,1),'xr')
        xFin=max(xFin,real(kpole(end,1))+10);
        ySta=min(ySta,imag(kpole(end,1))-10);
        yFin=max(yFin,imag(kpole(end,1))+10);
    end
    plot(w/(M*(1-(1-(1-(1-4*h/10))/h)^2)),0,'ko')
    xFin=max(xFin,w/(M*(1-(1-(1-(1-4*h/10))/h)^2))+10);
    plot(linspace(xSta,xFin,2),[0,0],'k--')
    plot([0,0],linspace(ySta,yFin,2),'k--')
    plot(linspace(w/M,xFin,2),[0,0],'k')
    plot(w/M,0,'ko')
    ylabel('Im$(k)$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle')
    xlim([xSta,xFin])
    ylim([ySta,yFin])
    
    nexttile
    set(gca,'TickDir','out')
    hold on
    xSta=-w/M;
    xFin=2*w/M;
    ySta=-100;
    yFin=100;
    for j1=1:length(kpoleImagwTrack(:,1))-2
        plot(kpoleImagwTrack(j1,:),'r')
        if abs(imag(kpole(j1,1)))<yFin
            xSta=min(xSta,real(kpole(j1,1))-10);
        end
    end
    xFin=max(xFin,max(real(kpoleImagwTrack(end-1,:))+10));
    ySta=min(ySta,min(imag(kpoleImagwTrack(end-1,:))-10));
    yFin=max(yFin,max(imag(kpoleImagwTrack(end-1,:))+10));
    xFin=max(xFin,max (real(kpoleImagwTrack(end,:))+10));
    ySta=min(ySta,min(imag(kpoleImagwTrack(end,:))-10));
    yFin=max(yFin,max(imag(kpoleImagwTrack(end,:))+10));
    T1=1;
    T2=1;
    for j1=1:length(kpoleImagwTrack(end,:))-1
        if imag(sqrt(1-ImagwTrack(end-1,j1)/(M*kpoleImagwTrack(end-1,j1))))<0 && real(sqrt(1-ImagwTrack(end-1,j1)/(M*kpoleImagwTrack(end-1,j1))))<1
            T1=j1;
        end
        if imag(sqrt(1-ImagwTrack(end,j1)/(M*kpoleImagwTrack(end,j1))))>0 && real(sqrt(1-ImagwTrack(end,j1)/(M*kpoleImagwTrack(end,j1))))<1
            T2=j1;
        end
    end
    plot(kpoleImagwTrack(end-1,1:T1),'b-.')
    plot(kpoleImagwTrack(end-1,T1:end),'r')
    plot(kpoleImagwTrack(end,1:T2),'b-.')
    plot(kpoleImagwTrack(end,T2:end),'r')
    plot(linspace(xSta,xFin,2),[0,0],'k--')
    plot([0,0],linspace(ySta,yFin,2),'k--')
    xlim([xSta,xFin])
    ylim([ySta,yFin])
    
    nexttile
    set(gca,'TickDir','out')
    load('SetA2_Q')
    hold on
    xSta=-w/M;
    xFin=2*w/M;
    ySta=-100;
    yFin=100;
    for j1=1:length(kpole(:,1))-2
        plot(kpole(j1,1),'*r')
        if abs(imag(kpole(j1,1)))<yFin
            xSta=min(xSta,real(kpole(j1,1))-10);
        end
    end
    if imag(kpole(end-1,1))>0
        plot(kpole(end-1,1),'+r')
        xFin=max(xFin,real(kpole(end-1,1))+10);
        ySta=min(ySta,imag(kpole(end-1,1))-10);
        yFin=max(yFin,imag(kpole(end-1,1))+10);
    else
        plot(kpole(end-1,1),'+b')
        xFin=max(xFin,real(kpole(end-1,1))+10);
        ySta=min(ySta,imag(kpole(end-1,1))-10);
        yFin=max(yFin,imag(kpole(end-1,1))+10);
    end
    if imag(kpole(end,1))>0
        plot(kpole(end,1),'xb')
        xFin=max(xFin,real(kpole(end,1))+10);
        ySta=min(ySta,imag(kpole(end,1))-10);
        yFin=max(yFin,imag(kpole(end,1))+10);
    else
        plot(kpole(end,1),'xr')
        xFin=max(xFin,real(kpole(end,1))+10);
        ySta=min(ySta,imag(kpole(end,1))-10);
        yFin=max(yFin,imag(kpole(end,1))+10);
    end
    plot(w/(M*(1-(1-(1-(1-4*h/10))/h)^2)),0,'ko')
    xFin=max(xFin,w/(M*(1-(1-(1-(1-4*h/10))/h)^2))+10);
    plot(linspace(xSta,xFin,2),[0,0],'k--')
    plot([0,0],linspace(ySta,yFin,2),'k--')
    plot(linspace(w/M,xFin,2),[0,0],'k')
    plot(w/M,0,'ko')
    xlabel('Re$(k)$','fontname','Latex','Interpreter','Latex')
    ylabel('Im$(k)$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle')
    xlim([xSta,xFin])
    ylim([ySta,yFin])
    
    nexttile
    set(gca,'TickDir','out')
    hold on
    xSta=-w/M;
    xFin=2*w/M;
    ySta=-100;
    yFin=100;
    for j1=1:length(kpole(:,1))-2
        plot(kpoleImagwTrack(j1,:),'r')
        if abs(imag(kpole(j1,1)))<yFin
            xSta=min(xSta,real(kpole(j1,1))-10);
        end
    end
        xFin=max(xFin,max(real(kpoleImagwTrack(end-1,:))+10));
        ySta=min(ySta,min(imag(kpoleImagwTrack(end-1,:))-10));
        yFin=max(yFin,max(imag(kpoleImagwTrack(end-1,:))+10));
        xFin=max(xFin,max(real(kpoleImagwTrack(end,:))+10));
        ySta=min(ySta,min(imag(kpoleImagwTrack(end,:))-10));
        yFin=max(yFin,max(imag(kpoleImagwTrack(end,:))+10));
T1=1;
T2=1;
    for j1=1:length(kpoleImagwTrack(end,:))-1
        if imag(sqrt(1-ImagwTrack(end-1,j1)/(M*kpoleImagwTrack(end-1,j1))))<0 && real(sqrt(1-ImagwTrack(end-1,j1)/(M*kpoleImagwTrack(end-1,j1))))<1
            T1=j1;
        end
        if imag(sqrt(1-ImagwTrack(end,j1)/(M*kpoleImagwTrack(end,j1))))>0 && real(sqrt(1-ImagwTrack(end,j1)/(M*kpoleImagwTrack(end,j1))))<1
            T2=j1;
        end
    end
    plot(kpoleImagwTrack(end-1,1:T1),'b-.')
    plot(kpoleImagwTrack(end-1,T1:end),'r')
    plot(kpoleImagwTrack(end,1:T2),'b-.')
    plot(kpoleImagwTrack(end,T2:end),'r')
    xlabel('Re$(k)$','fontname','Latex','Interpreter','Latex')
    plot(linspace(xSta,xFin,2),[0,0],'k--')
    plot([0,0],linspace(ySta,yFin,2),'k--')
    xlim([xSta,xFin])
    ylim([ySta,yFin])
    exportgraphics(gcf,'fig5.pdf','ContentType','vector')
close;


%%%%%%%%%%%
%% Figure 6
figure('units','centimeters','position',[5 -5 widthCM 4*widthCM/3])

    modal_sum=0; % Should we also plot a fifth line with the total field?

    if modal_sum
        tiledlayout(5,3,'TileSpacing','compact','Padding','compact')
    else
        tiledlayout(4,3,'TileSpacing','compact','Padding','compact')
    end
    contours=[-16,-14,-12,-10,-8,-6,-4,-2,0]; % Contour levels to plot
    contour_label=[-16,-12,-8,-4,-2,0]; % Contours to label
    min_contour = min(contours)-0.5; % Fudge to get colour below bottom contour
    contours=[min_contour-0.5, contours];
    
    % i)
    nexttile
    load('SetA1_Q_2')
    Toplot=abs(Ikr+Ibk+Ik0);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    ylabel('$r$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    yticks([0,0.5,1-h,1])
    yticklabels({'0','0.5',' ','i) 1'})
    ylim([0,1])
    xticks([0,0.5,1])
    xticklabels({' ',' ',' '})
    xlim([0,1])   
    caxis([min(contours) max(contours)])
    
    nexttile
    load('SetB_Q')
    Toplot=abs(Ikr+Ibk+Ik0);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    xticks([0.02,0.5,1])
    xticklabels({' ',' ',' '})
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    ylim([0,1])
    xlim([0.02,1]) 
    caxis([min(contours) max(contours)])
    
    nexttile
    load('SetC_Q_2')
    Toplot=abs(Ikr+Ibk+Ik0);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    ylim([0,1])
    xticks([0,0.5,1])
    xticklabels({' ',' ',' '})
    xlim([0,1])
    caxis([min(contours) max(contours)])
    
    % ii)
    nexttile
    load('SetA1_Q_2')
    Toplot=abs(k0poleCont);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    ylabel('$r$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    yticks([0,0.5,1-h,1])
    ylim([0,1])
    yticklabels({'0','0.5',' ','ii) 1'})
    xticks([0,0.5,1])
    xticklabels({' ',' ',' '})
    xlim([0,1])   
    caxis([min(contours) max(contours)])
    
    nexttile
    load('SetB_Q')
    Toplot=abs(k0poleCont);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    xticks([0.02,0.5,1])
    xticklabels({' ',' ',' '})
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    ylim([0,1])
    xlim([0.02,1])  
    caxis([min(contours) max(contours)])
    
    nexttile
    load('SetC_Q_2')
    Toplot=abs(k0poleCont);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    ylim([0,1])
    xticks([0,0.5,1])
    xticklabels({' ',' ',' '})
    xlim([0,1])  
    caxis([min(contours) max(contours)])
    
    % iii)
    nexttile
    load('SetA1_Q_2')
    Toplot=abs(kpolepBelow);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    ylabel('$r$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    yticks([0,0.5,1-h,1])
    yticklabels({'0','0.5',' ','iii) 1'})
    ylim([0,1])
    xticks([0.02,0.5,1])
    xticklabels({' ',' ',' '})
    xlim([0.02,1])   
    caxis([min(contours(2:end)) max(contours)])
    
    nexttile
    load('SetB_Q')
    Toplot=abs(kpolepBelow);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    xticks([0.02,0.5,1])
    xticklabels({' ',' ',' '})
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    ylim([0,1])
    xlim([0.02,1])  
    caxis([min(contours) max(contours)])
    
    nexttile
    load('SetC_Q_2')
    Toplot=abs(kpolepBelow);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    ylim([0,1])
    xticks([0,0.5,1])
    xticklabels({' ',' ',' '})
    xlim([0,1])  
    caxis([min(contours) max(contours)])
    
    % iv)
    nexttile
    load('SetA1_Q_2')
    Toplot=abs(Ibk+Ikr+Ik0+k0poleCont+kpolepBelow);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    ylabel('$r$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    yticks([0,0.5,1-h,1])
    yticklabels({'0','0.5',' ','iv) 1'})
    ylim([0,1])
    xticks([0,0.5,1])
    xticklabels({'0','0.5','1'})
    xlim([0,1])   
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    caxis([min(contours) max(contours)])
    
    nexttile
    load('SetB_Q')
    Toplot=abs(Ibk+Ikr+Ik0+k0poleCont+kpolepBelow);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    xticks([0.02,0.5,1])
    xticklabels({' ',' ',' '})
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    ylim([0,1])
    xlim([0.02,1])  
    xticklabels({'0','0.5','1'})
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    caxis([min(contours) max(contours)])
    
    nexttile
    load('SetC_Q_2')
    Toplot=abs(Ibk+Ikr+Ik0+k0poleCont+kpolepBelow);
    hold on
    [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
    clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
    set(gca,'TickDir','out')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
    yticks([0,0.5,1-h,1])
    yticklabels({' ',' ',' ',' '})
    ylim([0,1])
    xticks([0,0.5,1])
    xticklabels({' ',' ',' '})
    xlim([0,1])  
    xticklabels({'0','0.5','1'})
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    caxis([min(contours) max(contours)])
    
    if modal_sum
      nexttile
      load('SetA1_Q_2')
      Toplot=abs(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
      hold on
      [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
      clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
      set(gca,'TickDir','out')
      ylabel('$r$','fontname','Latex','Interpreter','Latex')
      hYLabel = get(gca,'ylabel');
      set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
      yticks([0,0.5,1-h,1])
      yticklabels({' ',' ',' ',' '})
      yticks([0,0.5,1-h,1])
      yticklabels({'0','0.5',' ','v) 1'})
      ylim([0,1])
      xticks([0,0.5,1])
      xticklabels({'0','0.5','1'})
      xlim([0,1])
      xlabel('$x$','fontname','Latex','Interpreter','Latex')
      caxis([min(contours) max(contours)])
      
      nexttile
      load('SetB_Q')
      Toplot=abs(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
      hold on
      [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
      clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
      set(gca,'TickDir','out')
      hYLabel = get(gca,'ylabel');
      set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
      xticks([0.02,0.5,1])
      xticklabels({' ',' ',' '})
      yticks([0,0.5,1-h,1])
      yticklabels({' ',' ',' ',' '})
      ylim([0,1])
      xlim([0.02,1])
      xticklabels({'0','0.5','1'})
      xlabel('$x$','fontname','Latex','Interpreter','Latex')
      caxis([min(contours) max(contours)])
      
      nexttile
      load('SetC_Q_2')
      Toplot=abs(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
      hold on
      [C,H] = contour(x(101:200),r,max(log10(Toplot(101:200,:).'),min_contour),contours);
      clabel(C,H,contour_label,'FontSize',ContourFontSize,'FontName','Times')
      set(gca,'TickDir','out')
      hYLabel = get(gca,'ylabel');
      set(hYLabel,'rotation',0,'Position',[-0.1,0.75],'VerticalAlignment','middle')
      yticks([0,0.5,1-h,1])
      yticklabels({' ',' ',' ',' '})
      ylim([0,1])
      xticks([0,0.5,1])
      xticklabels({' ',' ',' '})
      xlim([0,1])
      xticklabels({'0','0.5','1'})
      xlabel('$x$','fontname','Latex','Interpreter','Latex')
      caxis([min(contours) max(contours)])  
    end
    
    exportgraphics(gcf,'fig6.pdf','ContentType','vector')
    close;    
    
    
%%%%%%%%%%%
%% Figure 7
figure('units','centimeters','position',[5 -5 widthCM widthCM/3]) % Reduce height
    tiledlayout(1,2,'TileSpacing','compact','Padding','compact');
    
    contours=(0.05*(1:20)/20);
    
    load('SetC_Q_1')
    Toplot=real(Ibk+Ikr+Ik0+k0poleCont);
    MAX=max(max(abs(real(Toplot))));
    
    nexttile
    contour(x,r,(max(zeros(length(x),length(r)),Toplot)).',contours)
    hold on
    contour(x,r,(-min(zeros(length(x),length(r)),Toplot)).',contours,'--')
    set(gca,'TickDir','out')
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    ylabel('$r$','fontname','Latex','Interpreter','Latex')
    ylim([0.9,1])
    ylabel('$r$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle')
    yticks([0.9,1-h,1])
    yticklabels({'0.9',' ','1'})
    xlim([0,1])
    caxis([min(contours) max(contours)])
    
    load('SetC_Q_3')
    Toplot=real(Ibk+Ikr+Ik0+k0poleCont);
    MAX=max(max(abs(real(Toplot))));
    nexttile
    contour(x,r,(max(zeros(length(x),length(r)),Toplot)).',contours)
    hold on
    contour(x,r,(-min(zeros(length(x),length(r)),Toplot)).',contours,'--')
    set(gca,'TickDir','out')
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    ylim([0.9,1])
    yticks([0.9,1-h,1])
    yticklabels({' ',' ',' '})
    colorbar('eastoutside')
    xlim([0,1])
    caxis([min(contours) max(contours)])
    exportgraphics(gcf,'fig7.pdf','ContentType','vector')
    close;
    
    
%%%%%%%%%%%
%% Figure 8
figure('units','centimeters','position',[5 -5 widthCM widthCM]) % Deliberately reduce height
    tiledlayout(3,2,'TileSpacing','compact','Padding','compact');
    
    load('SetA1_Q_log_2')
    nexttile
    loglog(x,(((abs(Ibk(1,1))*abs(Ibk(1,2))*abs(Ibk(1,3))*abs(Ibk(1,4))))^(1/4))*x.^(-7/2),'k--',x,abs(Ibk))
    set(gca,'TickDir','out')
    title('a','fontname','Latex','Interpreter','Latex')
    ylabel({'$I_{\frac{\omega}{M}}$',[]},'fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','top')
    ylim([1e-18,1e-3])
    legend('$O\big{(}x^{-\frac{7}{2}}\big{)}$','fontname','Latex','Interpreter','Latex','Location','northeast')
    
    load('SetA1_Q_log_1')
    nexttile
    loglog(x,(((abs(Ibk(1,1))*abs(Ibk(1,2))*abs(Ibk(1,3))*abs(Ibk(1,4))))^(1/4))*x.^(-5/2),'k--',x,abs(Ibk))
    set(gca,'TickDir','out')
    ylim([1e-21,1e-8])
    title('b','fontname','Latex','Interpreter','Latex')
    legend('$O\big{(}x^{-\frac{5}{2}}\big{)}$','fontname','Latex','Interpreter','Latex','Location','northeast')

    nexttile
    load('SetA1_Q_log_2')
    loglog(x,(((abs(Ikr(1,3))*abs(Ikr(1,4))))^(1/2))*x.^(-4),'k--',x,abs(Ikr))
    set(gca,'TickDir','out')
    ylabel('$I_r$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle')
    ylim([1e-14,1e-3])
    legend('$O\big{(}x^{-4}\big{)}$','fontname','Latex','Interpreter','Latex','Location','northeast')

    load('SetA1_Q_log_1')
    nexttile
    loglog(x,(((abs(Ikr(1,3))*abs(Ikr(1,4))))^(1/2))*x.^(-4),'k--',x,abs(Ikr))
    set(gca,'TickDir','out')
    ylim([1e-20,1e-8])
    legend('$O\big{(}x^{-4}\big{)}$','fontname','Latex','Interpreter','Latex','Location','northeast')

    nexttile
    load('SetA1_Q_log_2')
    loglog(x,(((abs(Ik0(1,1))*abs(Ik0(1,2))*abs(Ik0(1,3))*abs(Ik0(1,4))))^(1/4))*x.^(-3),'k--',x,abs(Ik0))
    set(gca,'TickDir','out')
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    ylabel('$I_0$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle')
    ylim([1e-20,1e-4])
    legend('$O\big{(}x^{-3}\big{)}$','fontname','Latex','Interpreter','Latex','Location','northeast')
    
     % Key
    nexttile
    load('SetA1_Q_log_2')
    loglog(x,(((abs(Ibk(1,1))*abs(Ibk(1,2))*abs(Ibk(1,3))*abs(Ibk(1,4))))^(1/4))*x.^(-7/2),'k--',x,abs(Ibk))
    yticks([])
    xticks([])
    ylim([1,10])
    axis off
    legend('Predicted decay rate','$r=0.2$','$r=0.6$','$r=1-9h/10$','$r=1-3h/5$','fontname','Latex','Interpreter','Latex','Location','northwest')

    exportgraphics(gcf,'fig8.pdf','ContentType','vector')
close;


%%%%%%%%%%%
%% Figure 9
figure('units','centimeters','position',[5 -5 widthCM 3*widthCM/4])
    tiledlayout(4,2,'TileSpacing','compact','Padding','compact');
    
    contours=(1:20)/20;
    omit_x = 0.01; % Omit points for -omit_x <= x <= omit_x

    % (i)
    nexttile
    load('SetA1_Q_2')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum);
    Toplot = Toplot(xind,:);
    contour(x,r,(max(zeros(length(x),length(r)),Toplot)).',contours)
    hold on
    contour(x,r,(-min(zeros(length(x),length(r)),Toplot)).',contours,'--')
    ylabel('$i)$ \,\,$r$\quad','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle') 
    set(gca,'TickDir','out')
    title('(a)','fontname','Latex','Interpreter','Latex')
    xticks([-1,0,1])
    xticklabels({' ',' ',' '})
    yticks([0,1-h,1])
    yticklabels({'0',' ','1'})
    ylim([0,1])
    caxis([0 max(contours)])
    
    nexttile
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    set(gca,'TickDir','out')
    title('(b)','fontname','Latex','Interpreter','Latex')
    xticks([-1,0,1])
    xticklabels({' ',' ',' '})
    yticks([0,1-h,1])
    yticklabels({' ',' ',' '})
    ylim([0,1])
    colorbar('eastoutside')
    caxis([0 max(contours)])
    
    % (ii)
    nexttile    
    load('SetA2_Q_2')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum);
    Toplot = Toplot(xind,:);
    contour(x,r,(max(zeros(length(x),length(r)),Toplot)).',contours)
    hold on
    contour(x,r,(-min(zeros(length(x),length(r)),Toplot)).',contours,'--')
    xticks([-1,0,1])
    xticklabels({' ',' ',' '})
    ylabel('$ii)$\,$r$\quad','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle')     
    yticks([0,1-h,1])
    yticklabels({'0',' ','1'})
    ylim([0,1])
    set(gca,'TickDir','out')
    caxis([0 max(contours)]) 

    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    nexttile
    contour(x,r,(max(zeros(length(x),length(r)),Toplot)).',contours)
    hold on
    contour(x,r,(-min(zeros(length(x),length(r)),Toplot)).',contours,'--')
    xticks([-1,0,1])
    xticklabels({' ',' ',' '})
    yticks([0,1-h,1])
    yticklabels({' ',' ',' '})
    ylim([0,1])
    set(gca,'TickDir','out')
    colorbar('eastoutside')
    caxis([0 max(contours)])

    % (iii)
    nexttile    
    load('SetB_Q')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum);
    Toplot = Toplot(xind,:);
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    xticks([-1,0,1])
    xticklabels({' ',' ',' '})
    ylabel('$iii)r$\quad','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle') 
    yticks([0,1-h,1])
    yticklabels({'0',' ','1'})
    ylim([0,1])
    set(gca,'TickDir','out')
    caxis([0 max(contours)])
    
    nexttile
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    xticks([-1,0,1])
    xticklabels({' ',' ',' '})
    yticks([0,1-h,1])
    yticklabels({' ',' ',' '})
    ylim([0,1])
    set(gca,'TickDir','out')
    colorbar('eastoutside')
    caxis([0 max(contours)])

    % (iv)
    nexttile
    load('SetC_Q_2')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum);
    Toplot = Toplot(xind,:);
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    xticks([-1,0,1])
    xticklabels({'-1','0','1'})
    ylabel('$iv)\,r$\quad','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle') 
    yticks([0,1-h,1])
    yticklabels({'0',' ','1'})
    ylim([0,1])
    set(gca,'TickDir','out')
    caxis([0 max(contours)])
    
    nexttile
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    xticks([-1,0,1])
    xticklabels({'-1','0','1'})
    yticks([0,1-h,1])
    yticklabels({' ',' ',' '})
    ylim([0,1])
    set(gca,'TickDir','out')
    colorbar('eastoutside')
    caxis([0 max(contours)])

    exportgraphics(gcf,'fig9.pdf','ContentType','vector')
    close;
    
    
%%%%%%%%%%%%
%% Figure 10
figure('units','centimeters','position',[5 -5 widthCM 9*widthCM/16])
    tiledlayout(3,3,'TileSpacing','compact','Padding','compact');
    
    % Contours for dB (log) scale:
    contours=linspace(-32,-10,23);
    cmax = max(contours);
    cmin = min(contours);

    % (i)
    nexttile
    load('SetA1_Q_long_2')
    modalsum(~isfinite(modalsum)) = 0;
    Toplot=10.*log10(abs(modalsum));
    contour(x,r,Toplot.',contours)
    ylabel('$i)$ \,\,$r$\quad','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle') 
    set(gca,'TickDir','out')
    title('(a)','fontname','Latex','Interpreter','Latex')
    yticks([1-3*h,1-h,1])
    caxis([cmin cmax])
    xticks([1,5,10,15,20])
    xticklabels({'','','','',''})
    
    Toplot=10.*log10(abs(k0poleCont));
    nexttile
    contour(x,r,Toplot.',contours)
    set(gca,'TickDir','out')
    title('(b)','fontname','Latex','Interpreter','Latex')
    yticks([1-3*h,1-h,1])
    yticklabels({' ',' ',' '})
    caxis([cmin cmax])
    xticks([1,5,10,15,20])
    xticklabels({'','','','',''})

    nexttile
    Toplot=10.*log10(abs(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont));
    contour(x,r,Toplot.',contours)
    set(gca,'TickDir','out')
    title('(c)','fontname','Latex','Interpreter','Latex')
    yticks([1-3*h,1-h,1])
    yticklabels({' ',' ',' '})
    colorbar('eastoutside')
    caxis([cmin cmax])
    xticks([1,5,10,15,20])
    xticklabels({'','','','',''})
    
    % (ii)
    nexttile    
    load('SetB_Q_long_2')
    modalsum(~isfinite(modalsum)) = 0;
    Toplot=10.*log10(abs(modalsum));
    contour(x,r,Toplot.',contours)
    ylabel('$ii)r$\quad','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle') 
    yticks([1-3*h,1-h,1])
    set(gca,'TickDir','out')
    caxis([cmin cmax])
    xticks([1,5,10,15,20])
    xticklabels({'','','','',''})
    
    Toplot=10.*log10(abs(modalsum+Ibk+Ikr+Ik0+k0poleCont));
    nexttile
    contour(x,r,Toplot.',contours)
    yticks([1-3*h,1-h,1])
    yticklabels({' ',' ',' '})
    set(gca,'TickDir','out')
    caxis([cmin cmax])
    xticks([1,5,10,15,20])
    xticklabels({'','','','',''})

    nexttile
    Toplot=10.*log10(abs(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont));
    contour(x,r,Toplot.',contours)
    yticks([1-3*h,1-h,1])
    yticklabels({' ',' ',' '})
    set(gca,'TickDir','out')
    colorbar('eastoutside')
    caxis([cmin cmax])
    xticks([1,5,10,15,20])
    xticklabels({'','','','',''})

    % (iii)
    nexttile
    load('SetC_Q_long_2')
    contours = [contours,1.7e-3,1.9e-3,2.1e-3,2.339e-3];
    Toplot=10.*log10(abs(modalsum));
    contour(x,r,Toplot.',contours)
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    ylabel('$iii)\,r$\quad','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle') 
    yticks([1-3*h,1-h,1])
    set(gca,'TickDir','out')
    caxis([cmin cmax])
    xticks([1,5,10,15,20])
    
    nexttile
    Toplot=10.*log10(abs(modalsum+Ibk+Ikr+Ik0+k0poleCont));
    contour(x,r,Toplot.',contours)
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    yticks([1-3*h,1-h,1])
    yticklabels({' ',' ',' ',' '})
    set(gca,'TickDir','out')    
    caxis([cmin cmax])
    xticks([1,5,10,15,20])
    
    nexttile
    Toplot=10.*log10(abs(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont));
    contour(x,r,Toplot.',contours)
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    yticks([1-3*h,1-h,1])
    yticklabels({' ',' ',' '})
    set(gca,'TickDir','out')
    colorbar('eastoutside')
    caxis([cmin cmax])
    xticks([1,5,10,15,20])

    exportgraphics(gcf,'fig10.pdf','ContentType','vector')
    close;


%%%%%%%%%%%%
%% Figure 11
    figure('units','centimeters','position',[5 -5 widthCM widthCM/2])
    tiledlayout(2,4,'TileSpacing','compact','Padding','compact');
    
    contours=[1,2,4,6,8,10,12,16,20,25,30,35,40]/40;
    omit_x = 0.01; % Omit points for -omit_x <= x <= omit_x

    load('SetA1_Q_1')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    MAX=max(max(abs(real(modalsum))));
    nexttile
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    set(gca,'TickDir','out')
    ylabel('$r$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle')
    yticks([0,1-h,1])
    yticklabels({'0',' ','1'})
    ylim([0,1])
    xticks([-1,0,1])
    xticklabels({' ',' ',' '})
    caxis([0 max(contours)])
    
    load('SetA1_Q_2')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    MAX=max(max(abs(real(modalsum))));
    nexttile
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    set(gca,'TickDir','out')
    yticks([0,1-h,1])
    yticklabels({' ',' ',' '})
    ylim([0,1])
    xticks([-1,0,1])
    xticklabels({' ',' ',' '})
    caxis([0 max(contours)])

    load('SetA2_Q_1')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    MAX=max(max(abs(real(modalsum))));
    nexttile
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    set(gca,'TickDir','out')
    yticks([0,1-h,1])
    yticklabels({' ',' ',' '})
    ylim([0,1])
    xticks([-1,0,1])
    xticklabels({' ',' ',' '})
    caxis([0 max(contours)])
    
    load('SetA2_Q_2')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    MAX=max(max(abs(real(modalsum))));
    nexttile
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    set(gca,'TickDir','out')
    yticks([0,1-h,1])
    yticklabels({' ',' ',' '})
    ylim([0,1])
    xticks([-1,0,1])
    xticklabels({' ',' ',' '})
    caxis([0 max(contours)])
    colorbar('eastoutside')
    
    load('SetA1_L_1')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    MAX=max(max(abs(real(modalsum))));
    nexttile
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    set(gca,'TickDir','out')
    yticks([0,1-h,1])
    yticklabels({'0',' ','1'})
    ylim([0,1])
    xticks([-1,0,1])
    xticklabels({'-1','0','1'})
    ylabel('$r$','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle')
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    caxis([0 max(contours)])
    
    load('SetA1_L_2')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    MAX=max(max(abs(real(modalsum))));
    nexttile
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    set(gca,'TickDir','out')
    yticks([0,1-h,1])
    yticklabels({' ',' ',' '})
    ylim([0,1])
    xticks([-1,0,1])
    xticklabels({'-1','0','1'})
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    caxis([0 max(contours)])
    
    load('SetA2_L_1')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    MAX=max(max(abs(real(modalsum))));
    nexttile
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    set(gca,'TickDir','out')
    yticks([0,1-h,1])
    yticklabels({' ',' ',' '})
    ylim([0,1])
    xticks([-1,0,1])
    xticklabels({'-1','0','1'})
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    caxis([0 max(contours)])
    
    load('SetA2_L_2')
    xind = find(abs(x) > omit_x);
    x = x(xind);
    Toplot=real(modalsum+kpolepAbove+kpolepBelow+Ibk+Ikr+Ik0+k0poleCont);
    Toplot = Toplot(xind,:);
    MAX=max(max(abs(real(modalsum))));
    nexttile
    contour(x,r,((max(zeros(length(x),length(r)),Toplot))).',contours)
    hold on
    contour(x,r,((-min(zeros(length(x),length(r)),Toplot))).',contours,'--')
    set(gca,'TickDir','out')
    yticks([0,1-h,1])
    yticklabels({' ',' ',' '})
    ylim([0,1])
    xticks([-1,0,1])
    xticklabels({'-1','0','1'})
    xlabel('$x$','fontname','Latex','Interpreter','Latex')
    colorbar('eastoutside')
    caxis([0 max(contours)])

    exportgraphics(gcf,'fig11.pdf','ContentType','vector')
    close;

%%%%%%%%%%%%
%% Figure 12
figure('units','centimeters','position',[5 -5 widthCM 2*widthCM/3])
    tiledlayout(2,2,'TileSpacing','compact','Padding','compact');
    load('SetC_Q_track')
    load('SetC_Q')
    
    % Vary h
    nexttile
    hold on
    set(gca,'TickDir','out')
    j1=1;
    while imag(kpoleh(1,j1))<=0
        j1=j1+1;
    end
    plot(kpoleh(1,1:j1),'b-.')
    plot(kpoleh(1,j1:end),'r')
    plot(kpoleh(2,:),'b-.')
    plot(kpole(end-1,1),'r+')
    plot(kpole(end,1),'bx')
    plot([-300,300],[0,0],'k--')
    plot([w/M,300],[0,0],'k')
    xlim([min([min(min(real(kpoleh))),0]),max(max(real(kpoleh)))+10])
    ylim([min([min(min(imag(kpoleh))),0])-10,max([max(max(imag(kpoleh))),0])+10])
    xlabel('Re$\left(k\right)$','fontname','Latex','Interpreter','Latex')
    ylabel('Im$\left(k\right)$\qquad\,\,','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle')  
    title('(a)','fontname','Latex','Interpreter','Latex')
        
    % Vary Z
    nexttile
    hold on
    set(gca,'TickDir','out')
    plot(kpoleZ(1:end-2,:).','r')
    j1=1;
    while imag(kpoleZ(end-1,j1))<=0
        j1=j1+1;
    end
    Temp1=j1-1;
    while imag(kpoleZ(end-1,j1))>=0
        j1=j1+1;
    end
    Temp2=j1-1;
    plot(kpoleZ(end-1,1:Temp1).','b-.')
    plot(kpoleZ(end-1,Temp1:Temp2).','r')
    plot(kpoleZ(end-1,Temp2:end).','b-.')
    plot(kpoleZ(end,:).','b-.')
    plot(kpole(end-1,1),'r+')
    plot(kpole(end,1),'bx')
    plot(kpoleZ(end-1,1),'k.','MarkerSize',12)
    plot(kpoleZ(end,1),'k.','MarkerSize',12)
    ySta=min(-100, min(min(imag(kpoleZ(end-1:end,:))))-10);
    yEnd=max(100, max(max(imag(kpoleZ(end-1:end,:))))+10);
    xSta=min(-w/M, min(min(real(kpoleZ)))-10);
    xEnd=max(2*w/M, max(max(real(kpoleZ)))+10);
    plot([xSta,xEnd],[0,0],'k--')
    plot([0,0],[ySta,yEnd],'k--')
    plot([w/M,xEnd],[0,0],'k')
    ylim([ySta,yEnd])
    xlim([xSta,xEnd])
    xlabel('Re$\left(k\right)$','fontname','Latex','Interpreter','Latex')
    ylabel('Im$\left(k\right)$\,\,','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle')
    title('(b)','fontname','Latex','Interpreter','Latex')
    
    % Vary omega
    nexttile
    hold on
    set(gca,'TickDir','out')
    j1=1;
    [rownum,colnum]=size(kpolew);
    while j1 <= colnum && imag(kpolew(1,j1))<=0
        j1=j1+1;
    end
    plot(M*kpolew(1,1:j1-1)./wValues(1,1:j1-1),'b-.')
    plot(M*kpolew(1,j1-1:end)./wValues(1,j1-1:end),'r')
    plot(M*kpolew(2,:)./wValues(2,:),'b-.')
    plot(M*kpole(end-1,1)./w,'r+')
    plot(M*kpole(end,1)./w,'bx')
    plot([-100,100],[0,0],'k--')
    plot([1,100],[0,0],'k')
    xlim([0,max(max(real(M*kpolew./wValues)))+1])
    xlabel('Re$\left(\frac{Mk}{\omega}\right)$','fontname','Latex','Interpreter','Latex')
    ylabel('Im$\left(\frac{Mk}{\omega}\right)$\qquad\,\,','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle') 
    title('(c)','fontname','Latex','Interpreter','Latex')   

    
    % Vary M
    nexttile
    hold on
    set(gca,'TickDir','out')
    kpoleM(MValues < 0.06) = NaN;
    kpoleMp=kpoleM(1,:);
    kpoleMm=kpoleM(1,:);
    kpoleMp(imag(kpoleMp)<0) = NaN;
    kpoleMm(imag(kpoleMm)>0) = NaN;
    plot(MValues(1,:).*kpoleMm./w,'b-.')
    plot(MValues(1,:).*kpoleMp./w,'r')
    plot(MValues(2,:).*kpoleM(2,:)./w,'b-.')
    plot(M.*kpole(end-1,1)./w,'r+')
    plot(M.*kpole(end,1)./w,'bx')
    plot([-100,100],[0,0],'k--')
    plot([1,100],[0,0],'k')
    xlim([0,max(max(real(MValues.*kpoleM./w)))+0.5])
    ylim([min([min(min(imag(MValues.*kpoleM./w))),0])-0.1,max([max(max(imag(MValues.*kpoleM./w))),0])+0.1])
    xlabel('Re$\left(\frac{Mk}{\omega}\right)$','fontname','Latex','Interpreter','Latex')
    ylabel('Im$\left(\frac{Mk}{\omega}\right)$\qquad\,\,','fontname','Latex','Interpreter','Latex')
    hYLabel = get(gca,'ylabel');
    set(hYLabel,'rotation',0,'VerticalAlignment','middle') 
    title('(d)','fontname','Latex','Interpreter','Latex')   
    
    exportgraphics(gcf,'fig12.pdf','ContentType','vector')
close;
