function[p1,p2,dp1,dp2,Err]=LinearShear(w,M,m,h,k,r,Branch)
toll=eps;
if nargin<6
 disp('Function for evaluating p1 and p2 for a given parameter set in Linear Sheared flow.')
 disp('inputs(w,M,m,h,k,r,Branch).')
 Value=input('Would you like input information? 0 N,1 Y :');
 if Value==1
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('h boundary layer thickness Scalar')
 disp('k wave number Vector/Scalar')
 disp('r radial location vector/Scalar')
 disp('Optional:')
 disp('Branch RowVector of -1,0 and 1 of length(r) defaults to 0, reffers to if branch cut from rcp should be taken above or below. Can be given as scalar for single value applied to all')
 end
 Value=input('Would you like output information? 0 N,1 Y :');
 if Value==1
     disp('p1 Matrix (length(k),length(r)), values of p_1, if r<1-h, evaluates at 1-h instead')
     disp('p2 Matrix (length(k),length(r)), values of p_2, if r<1-h, evaluates at 1-h instead')
     disp('dp1 Matrix (length(k),length(r)), values of (d p_1 / d r), if r<1-h, evaluates at 1-h instead')
     disp('dp2 Matrix (length(k),length(r)), values of (d p_2 / d r), if r<1-h, evaluates at 1-h instead')
     disp('Err Tensor (length(k),length(r),4), Sum Square Errors for the sum terms in p1 p2 dp1 and dp2 and (k,r)')
 end
 clear('Value')
 p1=[];
 p2=[];
 dp1=[];
 dp2=[];
 Err=[];
 return
end
[A,B]=size(k);
if A~=1 && B~=1
    disp('k must be a vector or scalar')
    p1=[];
    p2=[];
    dp1=[];
    dp2=[];
    Err=[];
    return
end
if B<A
    k=k.';
end
[A,B]=size(r);
if A~=1 && B~=1
    disp('k must be a vector or scalar')
    p1=[];
    p2=[];
    dp1=[];
    dp2=[];
    Err=[];
    return
end
if B<A
    r=r.';
end
if nargin<7
    Branch=zeros(1,length(r));
end
if size(Branch)~=size(r)
    Branch=zeros(1,length(r))+Branch(1);
end
Branch(floor(Branch)~=Branch)=0;
Branch(sign(Branch).*mod(Branch,2)~=Branch)=0;
A=max(max(length(w),length(M)),max(length(m),length(h)));
B=min(min(length(w),length(M)),min(length(m),length(h)));
if A~=1 || B~=1
 disp('inputs(w,M,m,h,k,r,Branch).')
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('h boundary layer thickness Scalar')
 p1=[];
 p2=[];
 dp1=[];
 dp2=[];
 Err=[];
 return
end
clear('A','B')

k=k.';
rcp=1-w*h./(k*M);
Q=rcp-1+h;
eta=M*k/h;
Rc=r-rcp;

an=zeros(length(k),length(r),4);
bn=zeros(length(k),length(r),4);
sa=zeros(length(k),length(r),3);
sb=zeros(length(k),length(r),4);
an(:,:,1)=1;
bn(:,:,1)=1;
p1=Rc.^3;
dp1=3*Rc.^2;
p2=zeros(size(Rc))+1;
dp2=zeros(size(Rc));
AbsSumSq=zeros(length(k),length(r),4);
Scale=1-h-rcp;
n=0;
tn=zeros(length(k),4);
A=(1./(3*rcp)).*(k.^2 -(m^2)*(rcp.^(-2)));
QUESTION=1;
term=zeros(length(k),length(r),4);
Errtoll=10^(-3); 
while QUESTION>toll
    n=n+1;
    
    sa(:,:,1)=(-Scale./rcp).*(sa(:,:,1)+an(:,:,1));
    sa(:,:,2)=(-Scale./rcp).*(sa(:,:,2)+an(:,:,1));
    sa(:,:,3)=(-Scale./rcp).*(sa(:,:,3)+(n-1)*an(:,:,1));
    T1a=(k.^2).*an(:,:,2).*(Scale.^2);
    T2a=(eta.^2).*an(:,:,4).*(Scale.^4);

    sb(:,:,1)=(-Scale./rcp).*(sb(:,:,1)+bn(:,:,1));
    sb(:,:,2)=(-Scale./rcp).*(sb(:,:,2)+bn(:,:,1));
    sb(:,:,3)=(-Scale./rcp).*(sb(:,:,3)+(n-1)*bn(:,:,1));
    T1b=(k.^2).*bn(:,:,2).*(Scale.^2);
    AT=(2*n-3)*an(:,:,3).*(Scale.^3);
    T2b=(eta.^2).*bn(:,:,4).*(Scale.^4);
    sb(:,:,4)=(-Scale./rcp).*(sb(:,:,4)+((-Scale).^3).*an(:,:,4));
    an(:,:,4)=an(:,:,3);
    an(:,:,3)=an(:,:,2);
    an(:,:,2)=an(:,:,1);
    an(:,:,1)=(T1a-T2a+(n+2)*sa(:,:,1)+(m^2-1)*(n-1)*sa(:,:,2)-(m^2-1)*sa(:,:,3))/(n*(n+3));
    bn(:,:,4)=bn(:,:,3);
    bn(:,:,3)=bn(:,:,2);
    bn(:,:,2)=bn(:,:,1);
    if n~=3
        bn(:,:,1)=(-A.*(AT+sb(:,:,4)) + T1b-T2b+(n-1)*sb(:,:,1)+(m^2-1)*(n-1)*sb(:,:,2) -(m^2-1)*sb(:,:,3))/(n*(n-3));
    else
        bn(:,:,1)=0;
    end
    term(:,:,1)=(Scale.^3).*an(:,:,1).*((Rc./Scale).^(n+3));
    term(:,:,2)=(n+3)*(Scale.^2).*an(:,:,1).*((Rc./Scale).^(n+2));
    term(:,:,3)=bn(:,:,1).*((Rc./Scale).^n);
    term(:,:,4)=n*(Scale.^-1).*bn(:,:,1).*((Rc./Scale).^(n-1));
    term(isnan(term))=0;
    term(isinf(term))=0;
    p1=p1+term(:,:,1);
    tn(:,1)=max(abs(term(:,:,1))./abs(p1),[],2);
    dp1=dp1+term(:,:,2);
    tn(:,2)=max(abs(term(:,:,2))./abs(dp1),[],2);
    p2=p2+term(:,:,3);
    tn(:,3)=max(abs(term(:,:,3))./abs(p2),[],2);
    dp2=dp2+term(:,:,4);
    tn(:,4)=max(abs(term(:,:,4))./abs(dp2),[],2);
    AbsSumSq(:,:,1)= AbsSumSq(:,:,1)+term(:,:,1).^2;
    AbsSumSq(:,:,2)= AbsSumSq(:,:,2)+term(:,:,2).^2;
    AbsSumSq(:,:,3)= AbsSumSq(:,:,3)+term(:,:,3).^2;
    AbsSumSq(:,:,4)= AbsSumSq(:,:,4)+term(:,:,4).^2;
    QUESTION=max(max(tn));
end
Err1=eps*sqrt(AbsSumSq(:,:,1))./abs(p1 );
Err2=eps*sqrt(AbsSumSq(:,:,2))./abs(dp1);
Err3=eps*sqrt(AbsSumSq(:,:,1))./abs(p2 );
Err4=eps*sqrt(AbsSumSq(:,:,2))./abs(dp2);
 p1(Err1>Errtoll)=NaN;
dp1(Err2>Errtoll)=NaN;
 p2(Err3>Errtoll)=NaN;
dp2(Err4>Errtoll)=NaN;

logP = log( 1i.*Rc) - log( 1i);
logM = log(-1i.*Rc) - log(-1i);
log0 = logP.*(imag(Q)>=0) + logM.*(imag(Q)<0);
logR = (Branch==0).*log0 + (Branch==1).*logP + (Branch==-1).*logM;
 p2=  p2 + A.*logR.* p1;
 dp2= dp2 + A.*logR.*dp1 + A.*p1./Rc;
 Err=zeros(length(k),length(r),4);
 Err(:,:,1)=Err1(:,:);
 Err(:,:,2)=Err2(:,:);
 Err(:,:,3)=Err3(:,:);
 Err(:,:,4)=Err4(:,:);

end