function Jump=GreensJump(w,M,m,h,Z,k,r,r0,flow,type)

if nargin<10
 disp('Function for evaluating the analyitic continutation of the Jump in Greens function.')
 disp('inputs(w,M,m,h,Z,k,r,r0,flow,type).')
 Value=input('Would you like input information? 0 N,1 Y :');
 if Value==1
 disp('w value of omega Scalar')
 disp('M mach number Scalar')
 disp('m wave mode Scalar')
 disp('h boundary layer thickness Scalar')
 disp('Z impedence Scalar')
 disp('k wave number vector or Scalar')
 disp('r radial location vector/Scalar')
 disp('r0 source location scalar')
 disp('flow either 1 or 2, 1 for linear sheared flow, 2 for quadratic sheared flow, defaults to 2')
 disp('type =0,1,2 defaults to 0, jump due to bk, k0 or kr respectively')
 end
 Value=input('Would you like output information? 0 N,1 Y :');
 if Value==1
     disp('Jump Matrix (length(k),length(r)), values of the jump function of type given in k and r for a source at r0')
 end
 clear('Value')
 Jump=[];
 return
end

if length(flow)~=1 || flow~=1
    flow=2;
end

if length(type)~=1 ||  ( type~=2 && type~=1)
    type=0;
end


rs=max(r0,1-h);
if flow==1
rcp=1-w*h./((k.')*M);
Q=rcp-1+h;
U=M.*(r0<=1-h)+M.*(1-(1-(1-r0)/h)).*(r0>1-h);
W=((-3).*rcp.*(Q.^2)/(1-h)).*(r0<=1-h) + ((-3).*rcp.*((r0-rcp).^2)./(r0)).*(r0>1-h);
A=(1./(3*rcp)).*((k.').^2 - (m./rcp).^2);
else
 Q=h*sqrt(1-w./(M*(k.')));
 rcp=1-h+Q;
 U=M.*(r0<=1-h)+M.*(1-(1-(1-r0)/h)^2).*(r0>1-h);
 W=((-3/4).*rcp.*(Q.^2)/(1-h)).*(r0<=1-h) + ((-3/4).*rcp.*((r0-rcp).^2).*((r0-(1-h-Q)).^2)./(r0.*Q.^2)).*(r0>1-h);
 A=((1./rcp - 1./Q).*( (k.').^2 + (m./rcp).^2 )/3) -(2*m^2)./(3*rcp.^3);
end
if type==0
    Branchk0=1;
    if r0>1-h
        Branchk0=-1;
    end
    Branchkr=zeros(1,length(r))+1;
    Branchkr(r>1-h)=-1;
    Branchbk=-1;
elseif type==1
    Branchk0=1;
    Branchkr=zeros(1,length(r))+1;
    Branchkr(r>r0)=-1;
    Branchbk=1;
    if r0<1-h
        Jump=zeros(length(k),length(r));
        return
    end
elseif type==2
    Branchkr=1;
    Branchbk=1;
    Branchk0=-1; 
    [psi1r0,~,~,~,~,~,~,~,~,~]=Solutions(w,M,m,h,Z,k,r0,Branchbk,1,flow,2);
end
[psi1,psi2,~,~,Disp,Coeffs,p1,~,~,~]=Solutions(w,M,m,h,Z,k,[r,r0],Branchbk,[Branchkr,Branchk0],flow,2);
%%We use Scaled versions of psi1,psi2 and the Coefficients since these will
%%all cancel out.
Common=-(w-U.*(k.')).*A./(W.*rs.*Disp);
if type==0
    Varied1=(Coeffs(:,4).^2).*psi1(:,end).*psi1(:,1:end-1)./(Disp+2*pi*1i*A.*Coeffs(:,2).*Coeffs(:,4));
    Varied2=Coeffs(:,4).*Coeffs(:,2).*psi2(:,end).*psi1(:,1:end-1)./(Disp+2*pi*1i*A.*Coeffs(:,2).*Coeffs(:,4));
    Varied3=Coeffs(:,4).*Coeffs(:,2).*psi1(:,end).*psi2(:,1:end-1)./(Disp+2*pi*1i*A.*Coeffs(:,2).*Coeffs(:,4));
    Varied4=(Coeffs(:,2).^2).*psi2(:,end).*psi2(:,1:end-1)./(Disp+2*pi*1i*A.*Coeffs(:,2).*Coeffs(:,4));
    Varied=Varied1.*(r<=1-h).*(r0<=1-h)+Varied2.*(r<=1-h).*(r0>1-h)+Varied3.*(r>1-h).*(r0<=1-h)+Varied4.*(r>1-h).*(r0>1-h);
elseif type==2
    Varied1=Coeffs(:,4).*psi1r0(:,end).*p1(:,1:end-1);
    Varied2=Coeffs(:,2).*psi2(:,end).*p1(:,1:end-1);
    Varied=(Varied1.*(r>r0)+Varied2.*(r<=r0)).*(r>1-h);
elseif type==1
    Varied1=Coeffs(:,4).*psi1(:,1:end-1).*p1(:,end);
    Varied2=Coeffs(:,2).*psi2(:,1:end-1).*p1(:,end);
    Varied=(Varied1.*(r<=r0)+Varied2.*(r>r0)).*(r0>1-h);
end
Jump=Common.*Varied;

end