function FullTracking(w,M,m,h,Mass,Spring,Damper,kpole,filename,flow)

if nargin<6
    disp('Function for tracking poles as a single parameter is varied, varies omega, h, and imag(Z).')
    disp('inputs(w,M,m,h,Mass,Spring,Damper,kpole,filename,flow).')
    Value=input('Would you like input information? 0 N,1 Y :');
    if Value==1
        disp('w value of omega Scalar')
        disp('M mach number Scalar')
        disp('m wave mode Scalar')
        disp('h boundary layer thickness Scalar')
        disp('Mass Mass term for a MSD Impedence Z(omega)')
        disp('Spring Spring term for a MSD Impedence Z(omega)')
        disp('Damper Damper term for a MSD Impedence Z(omega)')
        disp(' Z(omega)=Damper +1i Mass omega - 1i Spring / omega ')
        disp('kpole matrix of modal pole as given by full run')
        disp('Optional:')
        disp('filename filename for saving results String')
        disp('flow 1 or 2 for linear or quadratic shear flow, defaults to 2')
        Value=input('Would you like output information? 0 N,1 Y :');
        if Value==1
            disp('outputs files filename_Q_track.mat and filename_L_track.mat (if lin=1). Files contain parameters and all evaluated fields')
        end
    end
    clear('Value')
    return
end
if nargin<10 || flow~=1
    flow=2;
end

if nargin<9
    if flow==2
        j1=1;
        filename=['TempFile_FullTrack_' num2str(j1)];
        while isfile(['TempFile_FullTrack_' num2str(j1) '_Q_track.mat'])
            j1=j1+1;
            filename=['TempFile_FullTrack_' num2str(j1)];
        end
        disp('filename is:')
        disp(filename)
    else
        j1=1;
        filename=['TempFile_FullTrack_' num2str(j1)];
        while isfile(['TempFile_FullTrack_' num2str(j1) '_L_track.mat'])
            j1=j1+1;
            filename=['TempFile_FullTrack_' num2str(j1)];
        end
        disp('filename is:')
        disp(filename)
    end
end

orig_filename = filename;
if flow~=1
    filename=[filename, '_Q_track'];
    flow=2;
else
    filename=[filename, '_L_track'];
end
save(filename,'w','M','m','h','Mass','Spring','Damper','kpole','flow')
    
%% Track in h
fprintf('  Full Tracking: Tracking in h for %s\n', orig_filename);
[kpolephI,hpValuesI]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,3,0.5,1,kpole(end-1,1),flow);
[kpolephD,hpValuesD]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,3,0.001,1,kpole(end-1,1),flow);
[kpolemhI,hmValuesI]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,3,0.5,-1,kpole(end,1),flow);
[kpolemhD,hmValuesD]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,3,0.001,-1,kpole(end,1),flow);

if length(kpolemhI(1,:))>length(kpolephI(1,:))
    kpolephI=[kpolephI,zeros(1,length(kpolemhI(1,:))-length(kpolephI(1,:)))+kpolephI(end)];
    hpValuesI=[hpValuesI,zeros(1,length(hmValuesI)-length(hpValuesI))+hpValuesI(end)];
elseif length(kpolemhI(1,:))<length(kpolephI(1,:))
    kpolemhI=[kpolemhI,zeros(1,length(kpolephI(1,:))-length(kpolemhI(1,:)))+kpolemhI(end)];
    hmValuesI=[hmValuesI,zeros(1,length(hpValuesI)-length(hmValuesI))+hmValuesI(end)];
end

if length(kpolemhD(1,:))>length(kpolephD(1,:))
    kpolephD=[kpolephD,zeros(1,length(kpolemhD(1,:))-length(kpolephD(1,:)))+kpolephD(end)];
    hpValuesD=[hpValuesD,zeros(1,length(hmValuesD)-length(hpValuesD))+hpValuesD(end)];
elseif length(kpolemhD(1,:))<length(kpolephD(1,:))
    kpolemhD=[kpolemhD,zeros(1,length(kpolephD(1,:))-length(kpolemhD(1,:)))+kpolemhD(end)];
    hmValuesD=[hmValuesD,zeros(1,length(hpValuesD)-length(hmValuesD))+hmValuesD(end)];
end

kpoleh=zeros(2,length(kpolephI(1,:))+length(kpolephD(1,:)));
hValues=zeros(2,length(kpolephI(1,:))+length(kpolephD(1,:)));

for j1=1:length(kpolephI(1,:))
    kpoleh(1,j1)=kpolephI(end+1-j1);
    kpoleh(2,j1)=kpolemhI(end+1-j1);
    hValues(1,j1)=hpValuesI(end+1-j1);
    hValues(2,j1)=hmValuesI(end+1-j1);
end
for j1=1:length(kpolephD(1,:))
    kpoleh(1,length(kpolephI(1,:))+j1)=kpolephD(j1);
    kpoleh(2,length(kpolephI(1,:))+j1)=kpolemhD(j1);
    hValues(1,length(kpolephI(1,:))+j1)=hpValuesD(j1);
    hValues(2,length(kpolephI(1,:))+j1)=hmValuesD(j1);
end

save(filename,'w','M','m','h','Mass','Spring','Damper','kpole','flow','kpoleh','hValues')
clear('kpoleh','hValues','kpolephD','kpolephI','kpolemhD','kpolemhI','hmValuesD','hmValuesI','hpValuesD','hpValuesI')

%% Tracking in omega
fprintf('  Full Tracking: Tracking in omega for %s\n', orig_filename);
load(filename,'w','M','m','h','Mass','Spring','Damper','kpole','flow')
[kpolepwI,wpValuesI]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,4,50,1,kpole(end-1,1),flow);
[kpolepwD,wpValuesD]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,4,1,1,kpole(end-1,1),flow); % Target was 10
[kpolemwI,wmValuesI]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,4,50,-1,kpole(end,1),flow);
[kpolemwD,wmValuesD]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,4,1,-1,kpole(end,1),flow); % Target was 10

if length(kpolemwI)>length(kpolepwI)
    kpolepwI=[kpolepwI,zeros(1,length(kpolemwI)-length(kpolepwI))+kpolepwI(end)];
    wpValuesI=[wpValuesI,zeros(1,length(wmValuesI)-length(wpValuesI))+wpValuesI(end)];
elseif length(kpolemwI)<length(kpolepwI)
    kpolemwI=[kpolemwI,zeros(1,length(kpolepwI)-length(kpolemwI))+kpolemwI(end)];
    wmValuesI=[wmValuesI,zeros(1,length(wpValuesI)-length(wmValuesI))+wmValuesI(end)];
end

if length(kpolemwD(1,:))>length(kpolepwD(1,:))
    kpolepwD=[kpolepwD,zeros(1,length(kpolemwD(1,:))-length(kpolepwD(1,:)))+kpolepwD(end)];
    wpValuesD=[wpValuesD,zeros(1,length(wmValuesD)-length(wpValuesD))+wpValuesD(end)];
elseif length(kpolemwD(1,:))<length(kpolepwD(1,:))
    kpolemwD=[kpolemwD,zeros(1,length(kpolepwD(1,:))-length(kpolemwD(1,:)))+kpolemwD(end)];
    wmValuesD=[wmValuesD,zeros(1,length(wpValuesD)-length(wmValuesD))+wmValuesD(end)];
end

kpolew=zeros(2,length(kpolepwI)+length(kpolepwD(1,:)));
wValues=zeros(2,length(kpolepwI)+length(kpolepwD(1,:)));

for j1=1:length(kpolepwI)
    kpolew(1,j1)=kpolepwI(end+1-j1);
    kpolew(2,j1)=kpolemwI(end+1-j1);
    wValues(1,j1)=wpValuesI(end+1-j1);
    wValues(2,j1)=wmValuesI(end+1-j1);
end
for j1=1:length(kpolepwD(1,:))
    kpolew(1,length(kpolepwI)+j1)=kpolepwD(j1);
    kpolew(2,length(kpolepwI)+j1)=kpolemwD(j1);
    wValues(1,length(kpolepwI)+j1)=wpValuesD(j1);
    wValues(2,length(kpolepwI)+j1)=wmValuesD(j1);
end

load(filename,'kpoleh','hValues')
save(filename,'w','M','m','h','Mass','Spring','Damper','kpole','flow','kpoleh','hValues','kpolew','wValues')
clear('kpoleh','hValues','kpolepwD','kpolepwI','kpolemwD','polemwI','wmValuesD','wmValuesI','wpValuesD','wpValuesI')

%% Tracking Im(Z)
fprintf('  Full Tracking: Tracking in Z for %s\n', orig_filename);
[kpoleACZD,ZACValuesD]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,2,-inf, 0,kpole(1:end-2,1),flow);
[kpoleACZI,ZACValuesI]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,2, inf, 0,kpole(1:end-2,1),flow);
[kpolepZI ,ZpValuesI ]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,2, inf, 1,kpole(end-1,1),flow);
[kpolepZD ,ZpValuesD ]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,2,-inf, 1,kpole(end-1,1),flow);
[kpolemZI ,ZmValuesI ]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,2, inf,-1,kpole(end  ,1),flow);
[kpolemZD ,ZmValuesD ]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,2,-inf,-1,kpole(end  ,1),flow);
  
  % We next need to put all of these 12 groups together to get one changing
  % line from -infinity from the second set, to zero to infinity
  
if length(kpolemZI(1,:))>length(kpolepZI(1,:))
    kpolepZI =[kpolepZI ,zeros(1,length(kpolemZI( 1,:))-length(kpolepZI( 1,:)))+kpolepZI( end)];
    ZpValuesI=[ZpValuesI,zeros(1,length(ZmValuesI(1,:))-length(ZpValuesI(1,:)))+ZpValuesI(end)];
elseif length(kpolemZI(1,:))<length(kpolepZI(1,:))
    kpolemZI =[kpolemZI ,zeros(1,length(kpolepZI( 1,:))-length(kpolemZI( 1,:)))+kpolemZI( end)];
    ZmValuesI=[ZmValuesI,zeros(1,length(ZpValuesI(1,:))-length(ZmValuesI(1,:)))+ZmValuesI(end)];
end
if length(kpoleACZI(1,:))>length(kpolepZI(1,:))
    kpolepZI =[kpolepZI ,zeros(1,length(kpoleACZI( 1,:))-length(kpolepZI( 1,:)))+kpolepZI( end)];
    ZpValuesI=[ZpValuesI,zeros(1,length(ZACValuesI(1,:))-length(ZpValuesI(1,:)))+ZpValuesI(end)];
elseif length(kpoleACZI(1,:))<length(kpolepZI(1,:))
    kpoleACZI =[kpoleACZI ,zeros(1,length(kpolepZI( 1,:))-length(kpoleACZI( 1,:)))+kpoleACZI( :,end)];
    ZACValuesI=[ZACValuesI,zeros(1,length(ZpValuesI(1,:))-length(ZACValuesI(1,:)))+ZACValuesI(:,end)];
end
if length(kpoleACZI(1,:))>length(kpolemZI(1,:))
    kpolemZI =[kpolemZI ,zeros(1,length(kpoleACZI( 1,:))-length(kpolemZI( 1,:)))+kpolemZI( end)];
    ZmValuesI=[ZmValuesI,zeros(1,length(ZACValuesI(1,:))-length(ZmValuesI(1,:)))+ZmValuesI(end)];
elseif length(kpoleACZI(1,:))<length(kpolemZI(1,:))
    kpoleACZI =[kpoleACZI ,zeros(1,length(kpolemZI( 1,:))-length(kpoleACZI( 1,:)))+kpoleACZI( :,end)];
    ZACValuesI=[ZACValuesI,zeros(1,length(ZmValuesI(1,:))-length(ZACValuesI(1,:)))+ZACValuesI(:,end)];
end

if length(kpolemZD(1,:))>length(kpolepZD(1,:))
    kpolepZD =[kpolepZD ,zeros(1,length(kpolemZD( 1,:))-length(kpolepZD( 1,:)))+kpolepZD( end)];
    ZpValuesD=[ZpValuesD,zeros(1,length(ZmValuesD(1,:))-length(ZpValuesD(1,:)))+ZpValuesD(end)];
elseif length(kpolemZD(1,:))<length(kpolepZD(1,:))
    kpolemZD =[kpolemZD ,zeros(1,length(kpolepZD( 1,:))-length(kpolemZD( 1,:)))+kpolemZD( :,end)];
    ZmValuesD=[ZmValuesD,zeros(1,length(ZpValuesD(1,:))-length(ZmValuesD(1,:)))+ZmValuesD(:,end)];
end
if length(kpoleACZD(1,:))>length(kpolepZD(1,:))
    kpolepZD =[kpolepZD ,zeros(1,length(kpoleACZD( 1,:))-length(kpolepZD( 1,:)))+kpolepZD( end)];
    ZpValuesD=[ZpValuesD,zeros(1,length(ZACValuesD(1,:))-length(ZpValuesD(1,:)))+ZpValuesD(end)];
elseif length(kpoleACZD(1,:))<length(kpolepZD(1,:))
    kpoleACZD =[kpoleACZD ,zeros(1,length(kpolepZD( 1,:))-length(kpoleACZD( 1,:)))+kpoleACZD( :,end)];
    ZACValuesD=[ZACValuesD,zeros(1,length(ZpValuesD(1,:))-length(ZACValuesD(1,:)))+ZACValuesD(:,end)];
end
if length(kpoleACZD(1,:))>length(kpolemZD(1,:))
    kpolemZD =[kpolemZD ,zeros(1,length(kpoleACZD( 1,:))-length(kpolemZD( 1,:)))+kpolemZD( end)];
    ZmValuesD=[ZmValuesD,zeros(1,length(ZACValuesD(1,:))-length(ZmValuesD(1,:)))+ZmValuesD(end)];
elseif length(kpoleACZD(1,:))<length(kpolemZD(1,:))
    kpoleACZD =[kpoleACZD ,zeros(1,length(kpolemZD( 1,:))-length(kpoleACZD( 1,:)))+kpoleACZD( :,end)];
    ZACValuesD=[ZACValuesD,zeros(1,length(ZmValuesD(1,:))-length(ZACValuesD(1,:)))+ZACValuesD(:,end)];
end

%All the groups are now the same length

% Now I string them all together

kpoleACZ=[flip(kpoleACZD,2),kpoleACZI];
kpolepZ=[flip(kpolepZD,2),kpolepZI];
kpolemZ=[flip(kpolemZD,2),kpolemZI];
kpoleZ=[kpoleACZ;kpolepZ;kpolemZ];

ZACValues=[flip(ZACValuesD,2),ZACValuesI];
ZpValues=[flip(ZpValuesD,2),ZpValuesI];
ZmValues=[flip(ZmValuesD,2),ZmValuesI];
ZValues=[ZACValues;ZpValues;ZmValues];

load(filename,'kpoleh','hValues','kpolew','wValues')
save(filename,'w','M','m','h','Mass','Spring','Damper','kpole','flow','kpoleh','hValues','kpolew','wValues','kpoleZ','ZValues')

%% Tracking in M
fprintf('  Full Tracking: Tracking in M for %s\n', orig_filename);
load(filename,'w','M','m','h','Mass','Spring','Damper','kpole','flow')
[kpolepMI,MpValuesI]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,5,0.9,+1,kpole(end-1,1),flow);
[kpolepMD,MpValuesD]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,5,0.01,+1,kpole(end-1,1),flow);
[kpolemMI,MmValuesI]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,5,0.9,-1,kpole(end,1),flow);
[kpolemMD,MmValuesD]=kPoleTrack(w,M,m,h,Mass,Spring,Damper,5,0.01,-1,kpole(end,1),flow);

if length(kpolemMI)>length(kpolepMI)
    kpolepMI=[kpolepMI,zeros(1,length(kpolemMI)-length(kpolepMI))+kpolepMI(end)];
    MpValuesI=[MpValuesI,zeros(1,length(MmValuesI)-length(MpValuesI))+MpValuesI(end)];
elseif length(kpolemMI)<length(kpolepMI)
    kpolemMI=[kpolemMI,zeros(1,length(kpolepMI)-length(kpolemMI))+kpolemMI(end)]; % length(kpoleMwI) changed to length(kpolemMI)
    MmValuesI=[MmValuesI,zeros(1,length(MpValuesI)-length(MmValuesI))+MmValuesI(end)];
end

if length(kpolemMD(1,:))>length(kpolepMD(1,:))
    kpolepMD=[kpolepMD,zeros(1,length(kpolemMD(1,:))-length(kpolepMD(1,:)))+kpolepMD(end)];
    MpValuesD=[MpValuesD,zeros(1,length(MmValuesD)-length(MpValuesD))+MpValuesD(end)];
elseif length(kpolemMD(1,:))<length(kpolepMD(1,:))
    kpolemMD=[kpolemMD,zeros(1,length(kpolepMD(1,:))-length(kpolemMD(1,:)))+kpolemMD(end)];
    MmValuesD=[MmValuesD,zeros(1,length(MpValuesD)-length(MmValuesD))+MmValuesD(end)];
end

kpoleM=zeros(2,length(kpolepMI)+length(kpolepMD(1,:)));
MValues=zeros(2,length(kpolepMI)+length(kpolepMD(1,:)));

for j1=1:length(kpolepMI)
    kpoleM(1,j1)=kpolepMI(end+1-j1);
    kpoleM(2,j1)=kpolemMI(end+1-j1);
    MValues(1,j1)=MpValuesI(end+1-j1);
    MValues(2,j1)=MmValuesI(end+1-j1);
end
for j1=1:length(kpolepMD(1,:))
    kpoleM(1,length(kpolepMI)+j1)=kpolepMD(j1);
    kpoleM(2,length(kpolepMI)+j1)=kpolemMD(j1);
    MValues(1,length(kpolepMI)+j1)=MpValuesD(j1);
    MValues(2,length(kpolepMI)+j1)=MmValuesD(j1);
end

load(filename,'kpoleh','hValues','kpolew','wValues','kpoleZ','ZValues')
save(filename,'w','M','m','h','Mass','Spring','Damper','kpole','flow','kpoleh','hValues','kpolew','wValues','kpoleZ','ZValues','kpoleM','MValues')

clear

