function FullRunLong(r0,filename,lin)

if nargin<2
    disp('For finding the contributions of the Fourier inversion for x values over a long linear scale')
    disp('inputs(r0,filename,lin,rtype).')
    Value=input('Would you like input information? 0 N,1 Y :');
    if Value==1
        disp('designed to be run following the function FullRun.')
        disp('r0 source location. Scalar/Vector')
        disp('filename filename as used for running FullRun, file should contain parameters. Do not inculde _Q.mat. String')
        disp('Optional:')
        disp('lin Takes values 0,1. Use 1 to run evalauations for a Quadratic and Linear Shear flow, 0 just evaluates Quadratic Shear. Defaults to 0.')
    end
    Value=input('Would you like output information? 0 N,1 Y :');
    if Value==1
        disp('outputs files filename_Q_long.mat and filename_L_long.mat (if lin=1). Files contain parameters and all evaluated fields')
        disp('If vector r0 given, filenames filename_Q_INT.mat contain evaluation for that particular value of r0' )
        disp('contributions are evuated in (x,r) x=linspace(1,20,400);, r=linspace(1-3*h,1,100)')
    end
end

if nargin<4
    rtype=1;
end
if rtype~=2
    rtype=1;
end
filenameQ=[filename,'_Q'];
filenameL=[filename,'_L'];
if rtype==1
    if length(r0)==1
        load(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
        filenameQ=[filenameQ,'_long'];
        r=linspace(1-3*h,1,100);
        % x=logspace(0,4,200); 
        % x=logspace(0,2,200);
        x=linspace(1,20,400);
        [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,2);
        save(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
        if lin==1
            load(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
            filenameL=[filenameL,'_long'];
            r=linspace(1-3*h,1,100);
            % x=logspace(0,4,200); 
            % x=logspace(0,2,200);
            x=linspace(1,20,400);
            [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,1);
            save(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
        end
    else
        R0=r0;
        for j1=1:length(R0)
            load(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
            filenameQ2=[filenameQ,'_long_',num2str(j1)];
            r=linspace(1-3*h,1,100);
            % x=logspace(0,4,200); 
            % x=logspace(0,2,200);
            x=linspace(1,20,400);
            r0=R0(j1);
            [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,2);
            save(filenameQ2,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
            if lin==1
                load(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
                filenameL2=[filenameL,'_long_',num2str(j1)];
                r=linspace(1-3*h,1,100);
                % x=logspace(0,4,200); 
                % x=logspace(0,2,200);
                x=linspace(1,20,400);
                r0=R0(j1);
                [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,1);
                save(filenameL2,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
            end
        end
    end
else
    if length(r0)==1
        load(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
        filenameQ=[filenameQ,'_long'];
        r=linspace(1-3*h,1,100);
        % x=logspace(0,4,200); 
        % x=logspace(0,2,200);
        x=linspace(1,20,400);
        [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,2);
        save(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
        if lin==1
            load(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
            filenameL=[filenameL,'_long'];
            r=linspace(1-3*h,1,100);
            % x=logspace(0,4,200); 
            % x=logspace(0,2,200);
            x=linspace(1,20,400);
            [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,1);
            save(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
        end
    else
        R0=r0;
        for j1=1:length(R0)
            load(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
            filenameQ2=[filenameQ,'_long_',num2str(j1)];
            r=[linspace(h^2,1-h-h^2),linspace(1-h,1)];
            % x=logspace(0,4,200); 
            % x=logspace(0,2,200);
            x=linspace(1,20,400);
            r0=R0(j1);
            [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,2);
            save(filenameQ2,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
            if lin==1
                load(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
                filenameL2=[filenameL,'_long_',num2str(j1)];
                r=[linspace(h^2,1-h-h^2),linspace(1-h,1)];
                % x=logspace(0,4,200); 
                % x=logspace(0,2,200);
                x=linspace(1,20,400);
                r0=R0(j1);
                [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,1);
                save(filenameL2,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
            end
        end
    end
end
