function FullRunLog(r0,filename,lin,rtype)

if nargin<2
    disp('For finding the contributions of the Fourier inversion for x values on a log scale')
    disp('inputs(r0,filename,lin,rtype).')
    Value=input('Would you like input information? 0 N,1 Y :');
    if Value==1
        disp('designed to be run following the function FullRun.')
        disp('r0 source location. Scalar/Vector')
        disp('filename filename as used for running FullRun, file should contain parameters. Do not inculde _Q.mat. String')
        disp('Optional:')
        disp('lin Takes values 0,1. Use 1 to run evalauations for a Quadratic and Linear Shear flow, 0 just evaluates Quadratic Shear. Defaults to 0.')
        disp('type Two different sets of r values can be considered Defaults to 1.') 
        disp('rtype=1 r=[0.2,0.6,1-9*h/10,1-3*h/5]')   
        disp('rtype=2 r=[linspace(h^2,1-h-h^2),linspace(1-h,1)];')   
    end
    Value=input('Would you like output information? 0 N,1 Y :');
    if Value==1
        disp('outputs files filename_Q_log.mat and filename_L_log.mat (if lin=1). Files contain parameters and all evaluated fields')
        disp('If vector r0 given, filenames filename_Q_INT.mat contain evaluation for that particular value of r0' )
        disp('contributions are evuated in (x,r) logspace(0,2,100);')
    end
end

if nargin<4
    rtype=1;
end
if rtype~=2
    rtype=1;
end
filenameQ=[filename,'_Q'];
filenameL=[filename,'_L'];
TOL=1e-8;
if rtype==1
    if length(r0)==1
        load(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
        filenameQ=[filenameQ,'_log'];
        r=[0.2,0.6,1-9*h/10,1-3*h/5];
        % x=logspace(0,4,200); 
        % x=logspace(0,2,200);
        x=logspace(0,2,100);
        [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,2,TOL);
        save(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
        if lin==1
            load(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
            filenameL=[filenameL,'_log'];
            r=[0.2,0.6,1-9*h/10,1-3*h/5];
            % x=logspace(0,4,200); 
            % x=logspace(0,2,200);
            x=logspace(0,2,100);
            [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,1,TOL);
            save(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
        end
    else
        R0=r0;
        for j1=1:length(R0)
            load(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
            filenameQ2=[filenameQ,'_log_',num2str(j1)];
            r=[0.2,0.6,1-9*h/10,1-3*h/5];
            % x=logspace(0,4,200); 
            % x=logspace(0,2,200);
            x=logspace(0,2,100);
            r0=R0(j1);
            [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,2,TOL);
            save(filenameQ2,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
            if lin==1
                load(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
                filenameL2=[filenameL,'_log_',num2str(j1)];
                r=[0.2,0.6,1-9*h/10,1-3*h/5];
                % x=logspace(0,4,200); 
                % x=logspace(0,2,200);
                x=logspace(0,2,100);
                r0=R0(j1);
                [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,1,TOL);
                save(filenameL2,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
            end
        end
    end
else
    if length(r0)==1
        load(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
        filenameQ=[filenameQ,'_log'];
        r=[0.2,0.6,1-9*h/10,1-3*h/5];
        % x=logspace(0,4,200); 
        % x=logspace(0,2,200);
        x=logspace(0,2,100);
        [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,2,TOL);
        save(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
        if lin==1
            load(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
            filenameL=[filenameL,'_log'];
            r=[0.2,0.6,1-9*h/10,1-3*h/5];
            % x=logspace(0,4,200); 
            % x=logspace(0,2,200);
            x=logspace(0,2,100);
            [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,1,TOL);
            save(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
        end
    else
        R0=r0;
        for j1=1:length(R0)
            load(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
            filenameQ2=[filenameQ,'_log_',num2str(j1)];
            r=[linspace(h^2,1-h-h^2),linspace(1-h,1)];
            % x=logspace(0,4,200); 
            % x=logspace(0,2,200);
            x=logspace(0,2,100);
            r0=R0(j1);
            [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,2,TOL);
            save(filenameQ2,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
            if lin==1
                load(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
                filenameL2=[filenameL,'_log_',num2str(j1)];
                r=[linspace(h^2,1-h-h^2),linspace(1-h,1)];
                % x=logspace(0,4,200); 
                % x=logspace(0,2,200);
                x=logspace(0,2,100);
                r0=R0(j1);
                [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,1,TOL);
                save(filenameL2,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
            end
        end
    end
end