function FullRun(w,m,M,h,Mass,Spring,Damper,r0,filename,wtrack,lin,contrib)

if nargin<8
    disp('Function for running code in full, finding; pole locations, corresponding half planes and Fourier inversion contributions for a point mass source, saves outputs to a file')
    disp('inputs(w,m,M,h,Mass,Spring,Damper,r0,filename,wtrack,lin,contrib).')
    Value=input('Would you like input information? 0 N,1 Y :');
    if Value==1
        disp('w value of omega Scalar')
        disp('m wave mode Scalar')
        disp('M mach number Scalar')
        disp('h boundary layer thickness Scalar')
        disp('Mass Mass term for a MSD Impedence Z(omega)')
        disp('Spring Spring term for a MSD Impedence Z(omega)')
        disp('Damper Damper term for a MSD Impedence Z(omega)')
        disp(' Z(omega)=Damper +1i Mass omega - 1i Spring / omega ')
        disp('r0 source location scalar or vector')
        disp('Optional:')
        disp('filename filename for saving results String')
        disp('wtrack Takes value 0,1. Use 1 for if you want to track the poles in Imag(omega) under the Briggs-Bers criterion. Defaults to 0.')
        disp('lin Takes values 0,1. Use 1 to run evalauations for a Quadratic and Linear Shear flow, 0 just evaluates Quadratic Shear. Defaults to 0.')
        disp('contrib Takes values 0,1,2. Use 1 to evaluate the contributions to the Fourier Inversion. Use 2 if you have already located the poles under a full run. Defaults to 1.')
    end
    Value=input('Would you like output information? 0 N,1 Y :');
    if Value==1
        disp('outputs files filename_Q.mat and filename_L.mat (if lin=1). Files contain parameters and all evaluated fields')
        disp('If vector r0 given, filenames filename_Q_INT.mat contain evaluation for that particular value of r0' )
        disp('contributions are evuated in (x,r) x=[linspace(-1,-0.005),linspace(0.005,1)]; r=[linspace(h^2,1-h-h^2),linspace(1-h,1)];')
    end
end

if nargin<9
    j1=1;
    filename=['TempFile_FullRun_' num2str(j1)];
    while isfile(['TempFile_FullRun_' num2str(j1) '_Q.mat'])
        j1=j1+1;
        filename=['TempFile_FullRun_' num2str(j1)];
    end
    disp('filename is:')
    disp(filename)
end
if nargin<10
    wtrack=0;
end
if nargin<11
    lin=0;
end
if nargin<12
    contrib=1;
end

Z=Damper +1i*Mass*w -1i*Spring./w;

if contrib~=2
    if wtrack~=1
        filenameQ=[filename,'_Q'];
        disp(['Finding poles for ', filenameQ]);
        [kpole,kpoleImagwTrack,ImagwTrack]=PoleFinder(w,M,m,h,Mass,Spring,Damper,2,0);
        save(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
        if lin==1
            filenameL=[filename,'_L'];
            disp(['Finding poles for ', filenameL]);
            [kpole,kpoleImagwTrack,ImagwTrack]=PoleFinder(w,M,m,h,Mass,Spring,Damper,1,0);
            save(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
        end
    else
        filenameQ=[filename,'_Q'];
        disp(['Finding and tracking poles for ', filenameQ]);
        [kpole,kpoleImagwTrack,ImagwTrack]=PoleFinder(w,M,m,h,Mass,Spring,Damper,2,1);
        save(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
        
        if lin==1
            filenameL=[filename,'_L'];
            disp(['Finding and tracking poles for ', filenameL]);
            [kpole,kpoleImagwTrack,ImagwTrack]=PoleFinder(w,M,m,h,Mass,Spring,Damper,1,1);
            save(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
        end
    end
else
    filenameQ=[filename,'_Q'];
    if lin==1
        filenameL=[filename,'_L'];
    end
    contrib=1;
end

if contrib==1
    if length(r0)==1
        load(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
        r=[linspace(h^2,1-h-h^2),linspace(1-h,1)];
        x=[linspace(-1,-0.005),linspace(0.005,1)];
        disp(['Finding Fourier contributions for  ', filenameQ]);
        [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,2);
        save(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
        if lin==1
            load(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
            r=[linspace(h^2,1-h-h^2),linspace(1-h,1)];
            x=[linspace(-1,-0.005),linspace(0.005,1)];
            disp(['Finding Fourier contributions for  ', filenameL]);
            [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,1);
            save(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
        end
    else
        R0=r0;
        for j1=1:length(R0)
            load(filenameQ,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
            filenameQ2=[filenameQ,'_',num2str(j1)];
            r=[linspace(h^2,1-h-h^2),linspace(1-h,1)];
            x=[linspace(-1,-0.005),linspace(0.005,1)];
            r0=R0(j1);
            disp(['Finding Fourier contributions for  ', filenameQ2]);
            [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,2);
            save(filenameQ2,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
            if lin==1
                load(filenameL,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack')
                filenameL2=[filenameL,'_',num2str(j1)];
                r=[linspace(h^2,1-h-h^2),linspace(1-h,1)];
                x=[linspace(-1,-0.005),linspace(0.005,1)];
                r0=R0(j1);
                disp(['Finding Fourier contributions for  ', filenameL2]);
                [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,1);
                save(filenameL2,'w','M','m','h','Z','Mass','Spring','Damper','kpole','kpoleImagwTrack','ImagwTrack','r','r0','x','modalsum','kpolepAbove','kpolepBelow','Ibk','Ikr','Ik0','k0poleCont')
            end
        end
    end
end