function [G,dG]=FourierGreens(w,M,m,h,Z,k,r,r0,Branchbk,Branchkr,Branchk0,flow)

if nargin<8
    disp('Function for evaluating the Greens function and its r derrivative')
    disp('inputs(w,M,m,h,Z,k,r,r0,Branchbk,Branchkr,Branchk0,flow).')
    Value=input('Would you like input information? 0 N,1 Y :');
    if Value==1
        disp('w value of omega Scalar')
        disp('M mach number Scalar')
        disp('m wave mode Scalar')
        disp('h boundary layer thickness Scalar')
        disp('Z impedence Scalar')
        disp('k wave number can be vector or Scalar')
        disp('r radial location vector/Scalar')
        disp('r0 source location scalar')
        disp('Optional:')
        disp('Branchbk For considering solutions as if above or below wrt bk=omega/M. takes values -1,1,0. Defaults to 0. -1 views as if below the branch cut. 1 views as if above the branch cut. 0 views however is natural for specific value of k.')
        disp('Branchkr As Branchbk but for the kr branch point. Vector valued as above, same length as r. If scalar will apply to all values of r.')
        disp('Branchk0 For considering solutions as if above or below wrt k0. takes values -1,1,0. Defaults to 0. -1 views as if below the branch cut. 1 views as if above the branch cut. 0 views however is natural for specific value of k.')
        disp('flow either 1 or 2, 1 for linear sheared flow, 2 for quadratic sheared flow, defaults to 2')
    end
    Value=input('Would you like output information? 0 N,1 Y :');
    if Value==1
        disp('G Matrix (length(k),length(r)), values of the Fourier inverted Green function at k and r for a source at r0')
        disp('dG derivative of G wrt r')
    end
    clear('Value')
    G=[];
    dG=[];
    return
end
[A,B]=size(k);
if A~=1 && B~=1
    disp('k must be a vector or scalar')
    G=[];
    dG=[];
    return
end
if B<A
    k=k.';
end
[A,B]=size(r);
if A~=1 && B~=1
    disp('r must be a vector or scalar')
    G=[];
    dG=[];
    return
end
if B<A
    r=r.';
end

if nargin<9
    Branchbk=0;
end
if nargin<10
    Branchkr=zeros(length(r));
end
if length(Branchkr)~=length(r)
    Branchkr=zeros(size(r))+Branchkr(1);
end
if nargin<11
    Branchk0=0;
end
if nargin<12
    flow=2;
end
if Branchbk~=0 && Branchbk~=1 && Branchbk~=-1
    Branchbk=0;
end
Branchkr(floor(Branchkr)~=Branchkr)=0;
Branchkr(sign(Branchkr).*mod(Branchkr,2)~=Branchkr)=0;
if length(flow)~=1 || flow~=1
    flow=2;
end

rs=max(r0,1-h);
if flow==1
    rcp=1-w*h./((k.')*M);
    Q=rcp-1+h;
    U=M.*(r0<=1-h)+M.*(1-(1-(1-r0)/h)).*(r0>1-h);
    W=((-3).*rcp.*(Q.^2)/(1-h)).*(r0<=1-h) + ((-3).*rcp.*((r0-rcp).^2)./(r0)).*(r0>1-h);
else
    Q=h*sqrt(1-w./(M*(k.')));
    rcp=1-h+Q;
    U=M.*(r0<=1-h)+M.*(1-(1-(1-r0)/h)^2).*(r0>1-h);
    W=((-3/4).*rcp.*(Q.^2)/(1-h)).*(r0<=1-h) + ((-3/4).*rcp.*((r0-rcp).^2).*((r0-(1-h-Q)).^2)./(r0.*Q.^2)).*(r0>1-h);
end
[psi1,psi2,dpsi1,dpsi2,Disp,~,~,~,~,~]=Solutions(w,M,m,h,Z,k,[r,r0],Branchbk,[Branchkr,Branchk0],flow,2);
Common=-1i*(w-U.*(k.'))./(2*pi*W.*rs.*Disp);
Varied=psi1(:,1:end-1).*psi2(:,end).*(r<=r0) + psi2(:,1:end-1).*psi1(:,end).*(r>r0);
dVaried=dpsi1(:,1:end-1).*dpsi2(:,end).*(r<=r0) + dpsi2(:,1:end-1).*dpsi1(:,end).*(r>r0);
G=Common.*Varied;
dG=Common.*dVaried;
end