 function [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]=FourierContributions(w,M,m,h,Z,r,r0,x,kpole,flow,tol)

if nargin<9
    disp('Function for evaluating psi1 and psi2 for a given parameter set.')
    disp('Not enough inputs')
    disp('inputs(w,M,m,h,Z,r,r0,x,kpole,flow).')
    Value=input('Would you like input information? 0 N,1 Y :');
    if Value==1
        disp('w value of omega Scalar')
        disp('M mach number Scalar')
        disp('m wave mode Scalar')
        disp('h boundary layer thickness Scalar')
        disp('Z impedence Scalar')
        disp('r radial location vector/Scalar')
        disp('r0 source location scalar')
        disp('x distance down duct from source')
        disp('kpole is a matrix, size (K,4), it should detail all of the poles of your system, [k value, pole type, contributing khalfplane, distance of tracking in omega], can be given by function INSERT FUNCTION NAME')
        disp('Optional:')
        disp('flow either 1 or 2, 1 for linear sheared flow, 2 for quadratic sheared flow, defaults to 2')
        disp('tol is the tolerance; defaults to 1e-5, but 1e-8 might be better for convergence plots.')
    end
    Value=input('Would you like output information? 0 N,1 Y :');
    if Value==1
        disp('returns [modalsum,kpolepAbove,kpolepBelow,Ibk,Ikr,Ik0,k0poleCont]')
        disp('each term is a matrix of size (length(x),length(r)) detailing the evaluations detailed below')
        disp('modal sum includes all poles that contribute to the modal sum excluding the kplus poles even if above.')
        disp('kpolepAbove is just the contribution for the k+ pole is above the branch cut.')
        disp('kpolepBelow is the contribution form the k plus pole, if it is below the branch cut. Is subtracted from Sum')
        disp('Ibk is the steepest desent integral down from w/M')
        disp('Ikr is the sttepest decent integral down from kr, when it is on the branch cut, else will be zero.')
        disp('Ik0 is as Ikr but for the k0 pole')
        disp('k0poleCont is the evaluation of the k0 pole when it is on the branch cut as if we are above, by integrating around it.')
    end
    clear('Value')
    modalsum=[];
    kpolepAbove=[];
    kpolepBelow=[];
    Ibk=[];
    Ikr=[];
    Ik0=[];
    k0poleCont=[];
    return
end
[~,B]=size(kpole);
if B~=4
    disp('check kpole set up')
    return
end
[A,B]=size(r);
if A~=1 && B~=1
    disp('r must be a vector or scalar')
    modalsum=[];
    kpolepAbove=[];
    kpolepBelow=[];
    Ibk=[];
    Ikr=[];
    Ik0=[];
    k0poleCont=[];
    return
end
if B<A
    r=r.';
end

clear('A','B')
if nargin<10
    flow=2;
end
if length(flow)~=1 || flow~=1
    flow=2;
end
if nargin<11
    tol=1e-5;
end

disp('  FourierContributions: Calculating modalsum');
modalsum=zeros(length(x),length(r));
kpolepAbove=zeros(length(x),length(r));
kpolepBelow=zeros(length(x),length(r));
for j1=1:length(kpole(:,1))
    if kpole(j1,2)~=-1
        Branchk0=0;
        Branchkr=zeros(1,length(r));
        if kpole(j1,2)==1 && imag(kpole(j1,1))<0
            R=1-h+h*sqrt(1-w./(M*real(kpole(j1,1))));
            Branchkr(r<R)=1;
            Branchkr(r>=R)=-1;
            Branchk0=-1*(r0>=R)+1*(r0<=R);
        end
        Contribution=PoleContribution(w,M,m,h,Z,kpole(j1,1),r,r0,x,kpole(j1,2),Branchkr,Branchk0,flow,1);
        Contribution=Contribution.*(sign(x.')~=kpole(j1,3));
        if kpole(j1,2)==0 && abs(imag(kpole(j1,1)))<400
            if min(min(isnan(Contribution)))~=0
                Contribution=PoleContribution(w,M,m,h,Z,kpole(j1,1),r,r0,x,kpole(j1,2),Branchkr,Branchk0,flow,1.5);
                Contribution=Contribution.*(sign(x.')~=kpole(j1,3));
            end
            Contribution(isnan(Contribution)) = 0;
            modalsum=modalsum+Contribution;
        elseif kpole(j1,2)==1 && imag(kpole(j1,1))<0
             Contribution(isnan(Contribution)) = 0;
             kpolepBelow=kpolepBelow+Contribution;
        elseif kpole(j1,2)==1 && imag(kpole(j1,1))>=0
            Contribution(isnan(Contribution)) = 0;
            kpolepAbove=kpolepAbove-Contribution;
        end
    end 
end

disp('  FourierContributions: Calculating Ikr');
[Ikr,~]=SteepestDecent(w,M,m,h,Z,r,r0,x,2,flow,tol);
disp('  FourierContributions: Calculating Ik0');
[Ik0,k0poleCont]=SteepestDecent(w,M,m,h,Z,r,r0,x,1,flow,tol);
disp('  FourierContributions: Calculating Ibk');
[Ibk,~]=SteepestDecent(w,M,m,h,Z,r,r0,x,0,flow,tol);

end