0;

filename = "straightduct2D_alpha000_a100_omega8.3333_M0." + ...
    "10_s_d10.0000_ptot_visc1.mat";
load(filename,'numparams','geomname','geomparams','Pint')

geom        = eval(strcat(geomname,'(','geomparams',')'));
geom.inner  = false;
X_func      = geom().X;
Xmn_func    = geom().Xmn;

alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
s_d         = numparams.s_d;
omega       = real(numparams.omega);
modes       = numparams.modes;
mach        = numparams.mach;
beta0       = numparams.beta0;

set(0,'DefaultAxesFontName','Times')
set(0,'DefaultAxesFontSize',10)
widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
figure('units','centimeters','position',[5 -5 widthCM widthCM]);
tiledlayout(2,1)

nexttile
disp('calculating Blackstock solution...')
n_s     = 200;
s       = (0:s_d/n_s:s_d)';
S_P     = {s, 1:(2*a_mx+1)*(alpha_mx+1)};
P       = reshape(Pint(S_P),[],alpha_mx+1,2*a_mx+1);
disp('summing over modes...')
Xdenom  = zeros(size(s));
for I_s = 1:length(s)
    Xdenom(I_s) = 1/sqrt(X_func(s(I_s)));
end
Xdenom  = repmat(Xdenom,1,alpha_mx+1,2*a_mx+1);
C_alpha     = zeros(size(modes(:,1)))';
cos_alphaX  = zeros(length(s),length(modes(:,1)));
for alpha = 0:alpha_mx
    C_alpha(alpha+1) = modes(alpha+1,3);
    for I_s = 1:length(s)
        cos_alphaX(I_s,alpha+1) = cos(alpha*pi*Xmn_func(s(I_s))...
            /X_func(s));
    end
end
C_alpha = repmat(C_alpha,length(s),1,2*a_mx+1);
cos_alphaX = repmat(cos_alphaX,1,1,2*a_mx+1);
alphadot = ones(alpha_mx+1,1);
P_a   = tensorprod(P.*Xdenom.*C_alpha.*cos_alphaX,alphadot,2,1);
PBlackstock = zeros(length(s(:,1)),a_mx);
for I_s = 1:n_s+1
    fprintf(1,'s = %6.3f\r',s(I_s));
    for a = 1:1:min(7,a_mx)
        PBlackstock(I_s,a) = BlackstockAmps(s(I_s),a,numparams);
    end
end

% plots = cell(7,1);
for a = 1:1:7
    colormat = get(gca,'ColorOrder');
    plot(beta0*mach*omega*s,abs(P_a(:,a_mx+1+a)/mach),'--',...
        'LineWidth',2,'Color',...
        colormat(a/1,:),'DisplayName',append('$$a =$$ ',string(a)));
    hold on
    plot(beta0*mach*omega*s,PBlackstock(:,a)/mach,'Color',...
        colormat(a/1,:),'DisplayName',append('$$a =$$ ',string(a)));
end
% legend([plots(1) plots(2) plots(3) plots(4) plots(5) plots(6) plots(7)])
xlabel('$$\sigma$$')
ylabel('$$|P^a|$$')
subtitle("(a)")

nexttile

for I_s = 1:n_s+1
    fprintf(1,'s = %6.3f\r',s(I_s));
    for a = 10:10:min(70,a_mx)
        PBlackstock(I_s,a) = BlackstockAmps(s(I_s),a,numparams);
    end
end
for a = 10:10:70
    colormat = get(gca,'ColorOrder');
    plot(beta0*mach*omega*s,abs(P_a(:,a_mx+1+a)/mach),'--',...
        'LineWidth',2,'Color',...
        colormat(a/10,:),'DisplayName',append('$$a =$$ ',string(a)));
    hold on
    plot(beta0*mach*omega*s,PBlackstock(:,a)/mach,'Color',...
        colormat(a/10,:),'DisplayName',append('$$a =$$ ',string(a)));
end
xlabel('$$\sigma$$')
ylabel('$$|P^a|$$')
subtitle("(b)")



t1              = annotation("textbox");
t1.String       = '$$a = 1$$';
t1.Interpreter  = 'latex';
t1.EdgeColor    = 'none';
t1.Position     = [0.3 0.73 0.1 0.1];

t2              = annotation("textbox");
t2.String       = '$$a = 2$$';
t2.Interpreter  = 'latex';
t2.EdgeColor    = 'none';
t2.Position     = [0.3 0.625 0.1 0.1];

t10             = annotation("textbox");
t10.String      = '$$a = 10$$';
t10.Interpreter = 'latex';
t10.EdgeColor   = 'none';
t10.Position    = [0.3 0.29 0.1 0.1];

t20             = annotation("textbox");
t20.String      = '$$a = 20$$';
t20.Interpreter = 'latex';
t20.EdgeColor   = 'none';
t20.Position    = [0.3 0.17 0.1 0.1];


exportgraphics(gcf,'stillplaceholderp5.pdf','ContentType','vector')