function grids = xsframe(geom,numparams,plotparams,Pchoice)

% returns plotting grids and spatially evaluated pressure amplitudes in 
% the x-s plane

%% DUCT GEOMETRY
X_func      = geom().X;
Xmn_func    = geom().Xmn;
Xpl_func    = geom().Xpl;

if geom.inner == true
    qx  = geom().innerqx;
    qy  = geom().innerqy;
    nx  = geom().innernx;
    ny  = geom().innerny;
else
    qx  = geom().qx;
    qy  = geom().qy;
    nx  = geom().nx;
    ny  = geom().ny;
end

xminus  = @(s) qx(s) + Xmn_func(s)*nx(s);
yminus  = @(s) qy(s) + Xmn_func(s)*ny(s);
xplus   = @(s) qx(s) + Xpl_func(s)*nx(s);
yplus   = @(s) qy(s) + Xpl_func(s)*ny(s);


%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
modes       = numparams.modes;
C_alpha     = modes(:,3)';


%% PLOTTING
s1 = plotparams.s1;
s2 = plotparams.s2;

n_s     = plotparams.n_s;
n_x     = plotparams.n_x;


%% PLOTTING GRID
s   = (s1:(s2 - s1)/n_s:s2);
xi  = abs(linspace(0,1,n_x+1));
xx  = zeros(n_x+1,n_s);
yy  = zeros(n_x+1,n_s);

for I_s = 1:length(s)
    xx(:,I_s) ...
        = linspace(xminus(s(I_s)),xplus(s(I_s)),n_x+1);
    yy(:,I_s) ...
        = linspace(yminus(s(I_s)),yplus(s(I_s)),n_x+1);
end


%% INTERPOLANT EVALUATION
P_a         = zeros((n_x+1)*(n_s+1),2*a_mx+1);
S_P         = {s, 1:(2*a_mx+1)*(alpha_mx+1)};
P_alpha_a   = permute(reshape(Pchoice(S_P),...
    size(Pchoice(S_P),1),alpha_mx+1,2*a_mx+1),[2 3 1]);


%% MODE MULTIPLICATION
disp('summing over modes...')
cos_alpha   = zeros(n_x+1,alpha_mx+1);
psi_alpha   = zeros((n_x+1)*(n_s+1),alpha_mx+1);
for alpha = 0:alpha_mx
    for I_x = 1:n_x+1
        cos_alpha(I_x,alpha+1) = cos(modes(alpha+1,2)*xi(I_x));
    end
end
for I_s = 1:n_s+1
    for I_x = 1:n_x+1
        psi_alpha((I_s-1)*(n_x+1)+I_x,:)...
            = (1/sqrt(X_func(s(I_s))))*C_alpha.*cos_alpha(I_x,:);
        P_a((I_s-1)*(n_x+1)+I_x,:)...
            = psi_alpha((I_s-1)*(n_x+1)+I_x,:)*P_alpha_a(:,:,I_s);
        % disp([I_s I_x])
    end
end

grids.xx = xx;
grids.yy = yy;
grids.zz = 0;
grids.P_a = P_a;

end