function grids = rsframe(geom,numparams,plotparams,Pchoice)

% returns plotting grids and spatially evaluated pressure amplitudes in 
% the r-s plane

%% DUCT GEOMETRY
R_func = geom().R;
if geom.qzvar == true
    disp('cannot plot this geometry in r-s plane due to torsion');
end

if geom.inner == false
    qx  = geom().qx;
    qy  = geom().qy;
    nx  = geom().nx;
    ny  = geom().ny;
else
    qx  = geom().innerqx;
    qy  = geom().innerqy;
    nx  = geom().innernx;
    ny  = geom().innerny;
end

r_0 = plotparams.r_0;

xminus  = @(s) qx(s) - r_0*R_func(s)*nx(s);
yminus  = @(s) qy(s) - r_0*R_func(s)*ny(s);
xplus   = @(s) qx(s) + r_0*R_func(s)*nx(s);
yplus   = @(s) qy(s) + r_0*R_func(s)*ny(s);


%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
modes       = numparams.modes;
C_alpha     = modes(:,6)';


%% PLOTTING
s1              = plotparams.s1;
s2              = plotparams.s2;
n_s             = plotparams.n_s;
n_r             = plotparams.n_r;


%% PLOTTING GRID
s   = (s1:(s2 - s1)/n_s:s2);
rhat    = abs(linspace(-r_0*1,r_0*1,2*n_r + 1));
xx  = zeros(2*n_r + 1,n_s);
yy  = zeros(2*n_r + 1,n_s);

for I_s = 1:length(s)
    xx(:,I_s) ...
        = linspace(xminus(s(I_s)),xplus(s(I_s)),2*n_r+1);
    yy(:,I_s) ...
        = linspace(yminus(s(I_s)),yplus(s(I_s)),2*n_r+1);
end

%% INTERPOLANT EVALUATION
P_a         = zeros((2*n_r+1)*(n_s+1),2*a_mx+1);
S_P         = {s, 1:(2*a_mx+1)*(alpha_mx+1)};
P_alpha_a   = permute(reshape(Pchoice(S_P),...
    size(Pchoice(S_P),1),alpha_mx+1,2*a_mx+1),[2 3 1]);


%% MODE MULTIPLICATION
disp('summing over modes...')
J_alpha     = zeros(2*n_r+1,alpha_mx+1);
cos_alpha   = (cos(modes(:,3)*0 - 0.5*modes(:,5)*pi))';
psi_alpha   = zeros((2*n_r+1)*(n_s+1),alpha_mx+1);
for I_r = 1:2*n_r+1
    for alpha = 0:alpha_mx
        J_alpha(I_r,alpha+1) ...
            = besselj(modes(alpha+1,3),modes(alpha+1,2)*rhat(I_r));
    end
end
for I_s = 1:n_s+1
    for I_r = 1:2*n_r+1
        %start in minus zone, so apply (-1)^p to each mode
        if I_r <= n_r
            psi_alpha((I_s-1)*(2*n_r+1) + I_r,:)...
                = (1/(sqrt(pi)*R_func(s(I_s))))*C_alpha...
                .*J_alpha(I_r,:).*cos_alpha...
                .*((-ones(length(modes(:,1)),1)).^modes(:,3))';
        elseif I_r > n_r
            psi_alpha((I_s-1)*(2*n_r+1) + I_r,:)...
                = (1/(sqrt(pi)*R_func(s(I_s))))*C_alpha...
                .*J_alpha(I_r,:).*cos_alpha;
        end
        P_a((I_s-1)*(2*n_r+1) + I_r,:)...
            = psi_alpha((I_s-1)*(2*n_r+1) + I_r,:)...
            *P_alpha_a(:,:,I_s);
        % disp([I_s I_r])
    end
end


grids.xx = xx;
grids.yy = yy;
grids.zz = 0;
grids.P_a = P_a;

end





