function error = convergenceintegrator(geom,compname,numparamsref,Pintref)
% load('ductsolve_pqxi3_3_0_a10_omega4.8_M0.1_s_dfalse.mat','numparams',...
%     'Pint')
load(compname,'numparams','Pint')
numparamscomp   = numparams;
Pintcomp        = Pint;

geom        = geom();


%% DUCT GEOMETRY
R_func      = geom().R;
kappa_func  = geom().kappa;
theta_0     = geom().theta0;
s_o         = geom().L;


%% NUMERICAL DATA
alpha_mxcomp    = numparamscomp.alpha_mx;
a_mxcomp        = numparamscomp.a_mx;
modescomp       = numparamscomp.modes;
s_dcomp         = numparamscomp.s_d;
omegacomp       = numparamscomp.omega;
C_alphacomp     = modescomp(:,6)';


%% NUMERICAL DATA (REFERENCE)
alpha_mxref = numparamsref.alpha_mx;
a_mxref     = numparamsref.a_mx;
modesref    = numparamsref.modes;
C_alpharef  = modesref(:,6);


%% PLOTTING PARAMETERS
nr     = 30;
ns     = 30;
ntheta = 30; %must be even for error1
nt     = 30;

t_grd = 0:2*pi/(omegacomp*nt):2*pi/omegacomp';
exp_a_grdcomp  = zeros(nt+1,2*a_mxcomp+1);
exp_a_grdref   = zeros(nt+1,2*a_mxref+1);
for I_t = 1:nt+1
    exp_a_grdcomp(I_t,:) = exp(-1i*linspace(-a_mxcomp,a_mxcomp,...
        2*a_mxcomp+1)*omegacomp*t_grd(I_t));
    exp_a_grdref(I_t,:) = exp(-1i*linspace(-a_mxref,a_mxref,...
        2*a_mxref+1)*omegacomp*t_grd(I_t));
end


%% PLOTTING GRID
x_grd       = 0:1/nr:1;
theta_grd   = 0:2*pi/ntheta:2*pi;
s_grd       = 0:s_dcomp/ns:s_dcomp;
theta0_grd = zeros(ns+1,1);
r_grd       = zeros(nr+1,ns+1);
r_o         = 0:R_func(s_o)/nr:R_func(s_o);
R_grd       = zeros(ns+1,1);
psialpha_grdcomp = zeros(alpha_mxcomp+1,nr+1,ns+1,ntheta+1);
psialpha_grdref  = zeros(alpha_mxref+1,nr+1,ns+1,ntheta+1);
psialpha_ocomp = zeros(alpha_mxcomp+1,nr+1,ntheta+1);
psialpha_oref  = zeros(alpha_mxcomp+1,nr+1,ntheta+1);

for I_s = 1:ns+1
    R_grd(I_s)  = R_func(s_grd(I_s));
    theta0_grd(I_s)    = theta_0(s_grd(I_s));
    r_grd(:,I_s) = 0:R_grd(I_s)/nr:R_grd(I_s);
end
for I_r = 1:nr+1
    for alpha = 0:alpha_mxcomp
        psialpha_grdcomp(alpha+1,I_r,:,:) ...
            = (C_alphacomp(alpha+1)./(sqrt(pi)*R_grd))...
            *besselj(modescomp(alpha+1,3),modescomp(alpha+1,2)...
            *x_grd(I_r))...
            .*(cos(modescomp(alpha+1,3)*theta0_grd)...
            .*cos(modescomp(alpha+1,3)*theta_grd ...
            - modescomp(alpha+1,5)*pi/2) ...
            + sin(modescomp(alpha+1,3)*theta0_grd)...
            .*sin(modescomp(alpha+1,3)*theta_grd ...
            - modescomp(alpha+1,5)*pi/2));
        psialpha_ocomp(alpha+1,I_r,:) ...
            = (C_alphacomp(alpha+1)./(sqrt(pi)*R_func(s_o)))...
            *besselj(modescomp(alpha+1,3),modescomp(alpha+1,2)...
            *x_grd(I_r))...
            .*cos(modescomp(alpha+1,3)*(theta_grd - theta_0(s_o))...
            - modescomp(alpha+1,5)*pi/2)';
    end
    for alpha = 0:alpha_mxref
        psialpha_grdref(alpha+1,I_r,:,:) ...
            = (C_alpharef(alpha+1)./(sqrt(pi)*R_grd))...
            *besselj(modesref(alpha+1,3),modesref(alpha+1,2)*x_grd(I_r))...
            .*(cos(modesref(alpha+1,3)*theta0_grd)...
            .*cos(modesref(alpha+1,3)*theta_grd ...
            - modesref(alpha+1,5)*pi/2) ...
            + sin(modesref(alpha+1,3)*theta0_grd)...
            .*sin(modesref(alpha+1,3)*theta_grd ...
            - modesref(alpha+1,5)*pi/2));
        psialpha_oref(alpha+1,I_r,:) ...
            = (C_alpharef(alpha+1)./(sqrt(pi)*R_func(s_o)))...
            *besselj(modesref(alpha+1,3),modesref(alpha+1,2)*x_grd(I_r))...
            .*cos(modesref(alpha+1,3)*(theta_grd - theta_0(s_o))...
            - modesref(alpha+1,5)*pi/2)';
    end
end

S_P_pl6comp = {s_grd,1:(2*a_mxcomp+1)*(alpha_mxcomp+1)};
S_P_pl6ref  = {s_grd,1:(2*a_mxref+1)*(alpha_mxref+1)};

S_P_ocomp   = {s_o,1:(2*a_mxcomp+1)*(alpha_mxcomp+1)};
S_P_oref    = {s_o,1:(2*a_mxref+1)*(alpha_mxref+1)};

P_alpha_a_grdcomp   = reshape(Pintcomp(S_P_pl6comp),...
    size(Pintcomp(S_P_pl6comp),1),alpha_mxcomp+1,2*a_mxcomp+1);
P_alpha_a_grdref    = reshape(Pintref(S_P_pl6ref),...
    size(Pintref(S_P_pl6ref),1),alpha_mxref+1,2*a_mxref+1);

P_alpha_a_ocomp = reshape(Pintcomp(S_P_ocomp),alpha_mxcomp+1,2*a_mxcomp+1);
P_alpha_a_oref  = reshape(Pintref(S_P_oref),alpha_mxref+1,2*a_mxref+1);


pp_grdcomp      = zeros(nt+1,nr+1,ns+1,ntheta+1);
pp_grddiff_tr1  = zeros(ns+1,ntheta+1);
pp_grddiff_tr3  = zeros(ns+1,ntheta+1);
pp_grdref       = zeros(nt+1,nr+1,ns+1,ntheta+1);
pp_grdref_tr1   = zeros(ns+1,ntheta+1);
pp_grdref_tr3   = zeros(ns+1,ntheta+1);

rr_grd          = zeros(nr+1,ns+1,ntheta+1);
for I_theta = 1:ntheta+1
    rr_grd(:,:,I_theta) = r_grd;
end
h_s_grd         = zeros(nr+1,ns+1,ntheta+1);

for I_s = 1:ns+1
    pp_grdcomp(:,:,I_s,:) ...
        = tensorprod(exp_a_grdcomp,tensorprod(...
        P_alpha_a_grdcomp(I_s,:,:),psialpha_grdcomp(:,:,I_s,:),2,1),2,2);
    pp_grdref(:,:,I_s,:)  ...
        = tensorprod(exp_a_grdref,tensorprod(P_alpha_a_grdref(I_s,:,:),...
        psialpha_grdref(:,:,I_s,:),2,1),2,2);
    h_s_grd(:,I_s,:) ...
        = 1 - kappa_func(s_grd(I_s))*r_grd(:,I_s)...
        .*cos(theta_grd - theta0_grd(I_s));
end

pp_ocomp    = tensorprod(exp_a_grdcomp,tensorprod(P_alpha_a_ocomp,...
    psialpha_ocomp,1,1),2,1);
pp_oref     = tensorprod(exp_a_grdref,tensorprod(P_alpha_a_oref,...
    psialpha_oref,1,1),2,1);

pp_grddiff_t    = reshape(trapz(t_grd,...
    (abs(pp_grdcomp - pp_grdref).^2)),nr+1,ns+1,ntheta+1);
pp_grdref_t     = reshape(trapz(t_grd,(abs(pp_grdref).^2)),nr+1,...
    ns+1,ntheta+1);

numerator2 = trapz(theta_grd,trapz(r_o,trapz(t_grd,...
    (abs(pp_ocomp - pp_oref).^2))));
denominator2 = trapz(theta_grd,trapz(r_o,trapz(t_grd,...
    (abs(pp_oref).^2))));

for I_s = 1:ns+1
    pp_grddiff_tr1(I_s,:) ...
        = trapz(r_grd(:,I_s),pp_grddiff_t(:,I_s,:).*h_s_grd(:,I_s,:));
    pp_grddiff_tr3(I_s,:) ...
        = trapz(r_grd(:,I_s),pp_grddiff_t(:,I_s,:).*h_s_grd(:,I_s,:)...
        .*rr_grd(:,I_s,:));
    pp_grdref_tr1(I_s,:) ...
        = trapz(r_grd(:,I_s),pp_grdref_t(:,I_s,:).*h_s_grd(:,I_s,:));
    pp_grdref_tr3(I_s,:) ...
        = trapz(r_grd(:,I_s),pp_grdref_t(:,I_s,:).*h_s_grd(:,I_s,:)...
        .*rr_grd(:,I_s,:));
end

numerator1 = trapz(s_grd,pp_grddiff_tr1);
denominator1 = trapz(s_grd,pp_grdref_tr1);

error       = zeros(3,1);

%midplane
error(1)    = sqrt(abs((numerator1(1) - numerator1(ceil(ntheta/2)))...
    /(denominator1(1) - denominator1(ceil(ntheta/2)))));
%downstream cross-section
error(2)    = sqrt(numerator2/denominator2);
%volumetric error
error(3)    = sqrt(trapz(theta_grd,trapz(s_grd,pp_grddiff_tr3))...
    /trapz(theta_grd,trapz(s_grd,pp_grdref_tr3)));


end