function modes = zerogen3D(alpha_mx)

%generates 3D mode array truncated at alpha_mx

%% BESSEL DERIVATIVE ZEROES
p_max = alpha_mx + 1;
q_max = alpha_mx + 1;
p = linspace(0,p_max,p_max+1);
q = linspace(1,q_max,q_max);
Jdash0s_raw = transpose(BessDerivZerosBisect2(p,q));
%find smallest edge value (bottom or right)
min_bottom = min(Jdash0s_raw(q_max,:));
min_right = min(Jdash0s_raw(:,p_max+1));
min_edge = min(min_bottom,min_right);
[Jdash0s,n] = sort(reshape(Jdash0s_raw,[],1));


%cut off at minimum edge value
cutoff = 1;
while Jdash0s(cutoff) < min_edge
    cutoff = cutoff + 1;
end
Jdash0s = Jdash0s(1:cutoff);
n = n(1:cutoff);
 

%% P AND Q VALUES
rowindex = mod(n,q_max);
columnindex = ceil(n/(q_max)) - 1;

modes = zeros(2*cutoff+1,6);
%count degeneracies
degcounter = 0;
for alpha = 0:cutoff-1
    if columnindex(alpha+1) == 0
        modes(alpha+2+degcounter,2) = Jdash0s(alpha+1);
        modes(alpha+2+degcounter,3) = 0;
        modes(alpha+2+degcounter,4) = rowindex(alpha+1);
    else
        % eigenvalue
        modes(alpha+2+degcounter,2) = Jdash0s(alpha+1);
        modes(alpha+3+degcounter,2) = Jdash0s(alpha+1);
        % azimuthal mode number
        modes(alpha+2+degcounter,3) = columnindex(alpha+1);
        modes(alpha+3+degcounter,3) = columnindex(alpha+1);
        % bessel derivative number
        modes(alpha+2+degcounter,4) = rowindex(alpha+1);
        modes(alpha+3+degcounter,4) = rowindex(alpha+1);
        % xi index
        modes(alpha+3+degcounter,5) = 1;
        degcounter                  = degcounter+1;
    end
end

modes = modes(1:alpha_mx+1,:);
% modenumber
modes(1:alpha_mx+1) = linspace(0,alpha_mx,alpha_mx + 1);


%% MODE NORMALISATION CONSTANTS
for alpha = 0:alpha_mx
    if modes(alpha+1,3) == 0
        modes(alpha+1,6) = 1/(abs(besselj(0,modes(alpha+1,2))));
    else
        modes(alpha+1,6) = 1/(sqrt(0.5...
            *(1 -(modes(alpha+1,3)/modes(alpha+1,2))^2))* ...
            abs(besselj(modes(alpha+1,3),modes(alpha+1,2))));
    end
end

end