function lmats = sfgen3D(modes)

% generates sans-serif matrices for projected 3D duct acoustics equations,
% given mode table

%% NUMERICAL DATA
alpha_mx = length(modes(:,1)) - 1;


%% LINEAR MATRIX DEFINITIONS     
% 3D linear building-block matrices
Pi          = zeros(alpha_mx+1);
Pi_x2       = zeros(alpha_mx+1);
Pi_x_d      = zeros(alpha_mx+1);
Pi_x2_d     = zeros(alpha_mx+1);
Phi         = zeros(alpha_mx+1);
Phi_cp      = zeros(alpha_mx+1);
Phi_sp      = zeros(alpha_mx+1);
Phi_sp_d    = zeros(alpha_mx+1);
Hsf         = zeros(alpha_mx+1);
for beta = 0:alpha_mx
    fprintf(1,'beta = %3.0f\r', beta);
    for alpha = 0:alpha_mx
        Phi(alpha+1,beta+1) ...
            = (eq(modes(alpha+1,3) + modes(beta+1,3),0) + 1)...
            *eq(modes(alpha+1,3),modes(beta+1,3))...
            *eq(modes(alpha+1,5),modes(beta+1,5));
        Phi_cp(alpha+1,beta+1) = 0.5*((-1)^modes(alpha+1,5)...
            *eq(modes(alpha+1,3) + modes(beta+1,3),1)...
            + eq(abs(modes(alpha+1,3) - modes(beta+1,3)),1))...
            *eq(modes(alpha+1,5),modes(beta+1,5));
        Phi_sp(alpha+1,beta+1) = 0.5*(eq(modes(alpha+1,3) ...
            + modes(beta+1,3),1)*eq(modes(alpha+1,5) ...
            + modes(beta+1,5),1) + (modes(alpha+1,3) ...
            - modes(beta+1,3))*eq(abs(modes(alpha+1,3) ...
            - modes(beta+1,3)),1)*(-1)^modes(beta+1,5)...
            *eq(modes(alpha+1,5) + modes(beta+1,5),1));
        Phi_sp_d(alpha+1,beta+1) = -0.5...
            *(eq(modes(alpha+1,3),1)*eq(modes(beta+1,3),0)...
            *eq(modes(alpha+1,5),0) + modes(alpha+1,3)*(modes(alpha+1,3)...
            - modes(beta+1,3)))*eq(abs(modes(alpha+1,3) ...
            - modes(beta+1,3)),1)*eq(modes(alpha+1,5),modes(beta+1,5));
        if Phi(alpha+1,beta+1) ~= 0
            Pi_x2_d(alpha+1,beta+1) = modes(alpha+1,6)*modes(beta+1,6)...
                *integral(@(x) x.*(modes(alpha+1,3)...
                .*besselj(modes(alpha+1,3),modes(alpha+1,2).*x)...
                - modes(alpha+1,2).*x...
                .*besselj(modes(alpha+1,3) + 1,modes(alpha+1,2).*x))...
                .*besselj(modes(beta+1,3),modes(beta+1,2).*x),0,1);
        end
        if Phi_cp(alpha+1,beta+1) ~= 0 || Phi_sp(alpha+1,beta+1) ~= 0
            Pi_x2(alpha+1,beta+1) = modes(alpha+1,6)*modes(beta+1,6)...
                *integral(@(x) x.^2 ...
                .*besselj(modes(alpha+1,3),modes(alpha+1,2).*x)...
                .*besselj(modes(beta+1,3),modes(beta+1,2).*x),0,1);
        end
        if Phi_cp(alpha+1,beta+1) ~= 0
            Pi_x_d(alpha+1,beta+1) = modes(alpha+1,6)*modes(beta+1,6)...
                *integral(@(x) (modes(alpha+1,3)...
                *besselj(modes(alpha+1,3),modes(alpha+1,2).*x)...
                - modes(alpha+1,2).*x...
                .*besselj(modes(alpha+1,3) + 1,modes(alpha+1,2).*x))...
                .*besselj(modes(beta+1,3),modes(beta+1,2).*x),0,1);
        end
        if Phi_sp_d(alpha+1,beta+1) ~= 0
            Pi(alpha+1,beta+1) = modes(alpha+1,6)*modes(beta+1,6)...
                *integral(@(x) besselj(modes(alpha+1,3),...
                modes(alpha+1,2).*x).*besselj(modes(beta+1,3),...
                modes(beta+1,2).*x),0,1);
        end
        Hsf(alpha+1,beta+1) = -modes(alpha+1,3)...
            *eq(modes(alpha+1,3),modes(beta+1,3))...
            *(-1)^(modes(alpha+1,5))...
            *eq(modes(alpha+1,5) + modes(beta+1,5),1)...
            *eq(modes(alpha+1,4),modes(beta+1,4));
    end
end

Lambdasf    = diag(modes(:,2));
Wsf         = eye(alpha_mx + 1) + Pi_x2_d.*Phi;


Asf         = Pi_x2.*Phi_cp;
Atilsf      = Pi_x_d.*Phi_cp - Pi.*Phi_sp_d;

lmats.Lambdasf  = Lambdasf;
lmats.Wsf       = Wsf;
lmats.Hsf       = Hsf;
lmats.Asf       = Asf;
lmats.Atilsf    = Atilsf;
lmats.Pi_x2     = Pi_x2;
lmats.Phi       = Phi;
lmats.Phi_cp    = Phi_cp;
lmats.Phi_sp    = Phi_sp;

end