function [s_grid,Ysfsol_pos,norms] ...
    = Ysfmagnusmobius(sspan,Ysfpl_o_pos,numparams,geom,lmats)

%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
delta       = numparams.delta;

s_grid  = (sspan(2):delta:sspan(1))';
n_s = length(s_grid);

Ysfsol_pos = zeros(n_s,alpha_mx+1,alpha_mx+1,a_mx);
Ysfsol_pos(n_s,:,:,:) = Ysfpl_o_pos;

Zsfsol_pos = zeros(n_s,alpha_mx+1,alpha_mx+1,a_mx);
for a = 1:a_mx
    Zsfsol_pos(n_s,:,:,a) = inv(reshape(Ysfsol_pos(n_s,:,:,a),...
        alpha_mx+1,alpha_mx+1));
end

Zsf_posnorm = zeros(n_s,1);
Ysf_posnorm = zeros(n_s,1);

Zsf_posnorm_a = zeros(1,a_mx);
Ysf_posnorm_a = zeros(1,a_mx);


for I_s = n_s-1:-1:1
    s = (s_grid(I_s) + s_grid(I_s+1))/2;
    for a = 1:a_mx
        if geom.dimensions == 2
            Lsf = Ldefs2D(s,a,numparams,geom,lmats,0);
        elseif geom.dimensions == 3
            Lsf = Ldefs3D(s,a,numparams,geom,lmats,0);
        end
        Esf     = expm(-delta*Lsf);
        Esf1    = Esf(1:alpha_mx+1,1:alpha_mx+1);
        Esf2    = Esf(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1));
        Esf3    = Esf(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1);
        Esf4    = Esf(alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:2*(alpha_mx+1));
        Ysf     = reshape(Ysfsol_pos(I_s+1,:,:,a),alpha_mx+1,alpha_mx+1);
        Ysfsol_pos(I_s,:,:,a) = (Esf1*Ysf+Esf2)/(Esf3*Ysf+Esf4);
        
        Lsf1    = Lsf(1:alpha_mx+1,1:alpha_mx+1);
        Lsf2    = Lsf(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1));
        Lsf3    = Lsf(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1);
        Lsf4    = Lsf(alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:2*(alpha_mx+1));
        Zsfsol_pos(I_s,:,:,a) = inv(reshape(Ysfsol_pos(I_s,:,:,a),...
            alpha_mx+1,alpha_mx+1));
        Zsf = reshape(Zsfsol_pos(I_s+1,:,:,a),alpha_mx+1,alpha_mx+1);
        dZsfds_pos      = (Zsf - reshape(Zsfsol_pos(I_s,:,:,a),...
            alpha_mx+1,alpha_mx+1))/delta;
        Zsf_posnorm_a(a)= norm(dZsfds_pos + Zsf*Lsf2*Zsf + Zsf*Lsf1 ...
            - Lsf4*Zsf-Lsf3,'fro')/norm(Zsf,'fro');
        dYsfdsgridhalf  = (Ysf - reshape(Ysfsol_pos(I_s,:,:,a),...
            alpha_mx+1,alpha_mx+1))/delta;
        Ysf_posnorm_a(a)= norm(dYsfdsgridhalf + Ysf*Lsf3*Ysf + Ysf*Lsf4...
            - Lsf1*Ysf - Lsf2,'fro')/norm(Ysf,'fro');
    end
    Zsf_posnorm(I_s) = Zsf_posnorm_a*ones(a_mx,1);
    Ysf_posnorm(I_s) = Ysf_posnorm_a*ones(a_mx,1);
end

norms.Ysf_posnorm = Ysf_posnorm;
norms.Zsf_posnorm = Zsf_posnorm;

Ysfsol_pos = reshape(Ysfsol_pos,n_s,[]);

end