function [s_grid,Ycalsol,norms] ...
    = Ycalmagnusmobius(sspan,Ycalpl_o,numparams,geom,lmats,nlmats)

%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
delta       = numparams.delta;

s_grid      = (sspan(2):delta:sspan(1))';
n_s         = length(s_grid);

Ysfint = geom.Ysfint;
Ysf = reshape(Ysfint({sspan(1),1:(2*a_mx+1)*(alpha_mx+1)^2}),...
    [alpha_mx+1,alpha_mx+1,2*a_mx+1]);
Zsf = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
for a = -a_mx:a_mx
    if a ~= 0
        Zsf(:,:,a+a_mx+1) = inv(Ysf(:,:,a+a_mx+1));
    end
end

Ycalsol ...
    = zeros(n_s,alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1);
Zcalsol ...
    = zeros(n_s,alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1);

Ycalsol(n_s,:,:,:,:,:) = Ycalpl_o;
for a = 1:a_mx
    for b = -a_mx+a:a_mx
        if b ~= 0 && a ~= b
            Zcalsol(n_s,:,:,:,a,b+a_mx+1) = -tensorprod(tensorprod(...
                tensorprod(Zsf(:,:,a+a_mx+1), ...
                reshape(Ycalsol(n_s,:,:,:,a,b+a_mx+1),alpha_mx+1,...
                alpha_mx+1,alpha_mx+1),2,1),Zsf(:,:,a-b+a_mx+1),2,1),...
                Zsf(:,:,b+a_mx+1),2,1);
        end
    end
end

Lsf         = zeros(2*(alpha_mx+1),2*(alpha_mx+1),2*a_mx+1);
Esf         = zeros(2*(alpha_mx+1),2*(alpha_mx+1),2*a_mx+1);
Esfsqrt     = zeros(2*(alpha_mx+1),2*(alpha_mx+1),2*a_mx+1);
Esf1        = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
Esf3        = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
Esf4        = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
Zcalnorm    = zeros(n_s,1);
Ycalnorm    = zeros(n_s,1);
Zcalnorm_ab = zeros(2*a_mx+1);
Ycalnorm_ab = zeros(2*a_mx+1);

dot = ones(2*a_mx+1,1);

for I_s = n_s-1:-1:1
    s = (s_grid(I_s) + s_grid(I_s+1))/2;
    fprintf(1,'s = %6.3f\r', s);
    Ysf = reshape(Ysfint({s_grid(I_s),1:(2*a_mx+1)*(alpha_mx+1)^2}),...
        [alpha_mx+1,alpha_mx+1,2*a_mx+1]);
    for a = -a_mx:a_mx
        if a ~= 0
            Zsf(:,:,a+a_mx+1) = inv(Ysf(:,:,a+a_mx+1));
            if geom.dimensions == 2
                Lsf(:,:,a+a_mx+1) = Ldefs2D(s,a,numparams,geom,lmats,0);
            elseif geom.dimensions == 3
                Lsf(:,:,a+a_mx+1) = Ldefs3D(s,a,numparams,geom,lmats,0);
            end
            Esf(:,:,a+a_mx+1) = expm(-delta*Lsf(:,:,a+a_mx+1));
            Esf1(:,:,a+a_mx+1) = Esf(1:alpha_mx+1,1:alpha_mx+1,a+a_mx+1);
            Esf3(:,:,a+a_mx+1) = Esf(alpha_mx+2:2*(alpha_mx+1),...
                1:alpha_mx+1,a+a_mx+1);
            Esf4(:,:,a+a_mx+1) = Esf(alpha_mx+2:2*(alpha_mx+1),...
                alpha_mx+2:2*(alpha_mx+1),a+a_mx+1);
            Esfsqrt(:,:,a+a_mx+1) = expm(-0.5*delta*Lsf(:,:,a+a_mx+1));
        end
    end
    Lsf1 = Lsf(1:alpha_mx+1,1:alpha_mx+1,:);
    Lsf2 = Lsf(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1),:);
    Lsf3 = Lsf(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,:);
    Lsf4 = Lsf(alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:2*(alpha_mx+1),:);
    for a = 1:a_mx
        for b = -a_mx+a:a_mx
            if b ~= 0 && a ~= b
                if geom.dimensions == 2
                    Ncal = Ndefs2D(s,a,b,numparams,geom,lmats,nlmats,0);
                elseif geom.dimensions == 3
                    Ncal = Ndefs3D(s,a,b,numparams,geom,lmats,nlmats,0);
                end
                Ycal = reshape(Ycalsol(I_s+1,:,:,:,a,b+a_mx+1),...
                    alpha_mx+1,alpha_mx+1,alpha_mx+1);
                Ecal = -delta*tensorprod(tensorprod(tensorprod(...
                    Esfsqrt(:,:,a+a_mx+1),Ncal,2,1),...
                    Esfsqrt(:,:,a-b+a_mx+1),2,1),...
                    Esfsqrt(:,:,b+a_mx+1),2,1);
                % Ecal = -delta*tensorprod(tensorprod(Ncal,...
                %     Esf(:,:,a-b+a_mx+1),2,1),...
                %     Esf(:,:,b+a_mx+1),2,1);
                Ecal1 = Ecal(1:alpha_mx+1,1:alpha_mx+1,1:alpha_mx+1);
                Ecal2 = Ecal(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1),...
                    1:alpha_mx+1);
                Ecal3 = Ecal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                    1:alpha_mx+1);
                Ecal4 = Ecal(alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:...
                    2*(alpha_mx+1),1:alpha_mx+1);
                Ecal5 = Ecal(1:alpha_mx+1,1:alpha_mx+1,...
                    alpha_mx+2:2*(alpha_mx+1));
                Ecal6 = Ecal(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1),...
                    alpha_mx+2:2*(alpha_mx+1));
                Ecal7 = Ecal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                    alpha_mx+2:2*(alpha_mx+1));
                Ecal8 = Ecal(alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:...
                    2*(alpha_mx+1),alpha_mx+2:2*(alpha_mx+1));
                Ycalsol(I_s,:,:,:,a,b+a_mx+1) = tensorprod(tensorprod(...
                    tensorprod(Esf1(:,:,a+a_mx+1) ...
                    - Ysf(:,:,a+a_mx+1)*Esf3(:,:,a+a_mx+1),Ycal,2,1) ...
                    + tensorprod(tensorprod(Ecal1 ...
                    - tensorprod(Ysf(:,:,a+a_mx+1),Ecal3,2,1),...
                    Ysf(:,:,a-b+a_mx+1),2,1),Ysf(:,:,b+a_mx+1),2,1) ...
                    + tensorprod(Ecal2 - tensorprod(Ysf(:,:,a+a_mx+1),...
                    Ecal4,2,1),Ysf(:,:,b+a_mx+1),3,1) ...
                    + permute(tensorprod(Ecal5...
                    - tensorprod(Ysf(:,:,a+a_mx+1),Ecal7,2,1),...
                    Ysf(:,:,a-b+a_mx+1),2,1),[1 3 2]) + Ecal6 ...
                    - tensorprod(Ysf(:,:,a+a_mx+1),Ecal8,2,1),...
                    inv(Esf3(:,:,a-b+a_mx+1)*Ysf(:,:,a-b+a_mx+1) ...
                    + Esf4(:,:,a-b+a_mx+1)),2,1),...
                    inv(Esf3(:,:,b+a_mx+1)*Ysf(:,:,b+a_mx+1) ...
                    + Esf4(:,:,b+a_mx+1)),2,1);
                Zcalsol(I_s,:,:,:,a,b+a_mx+1) = -tensorprod(...
                    tensorprod(tensorprod(Zsf(:,:,a+a_mx+1),...
                    reshape(Ycalsol(I_s,:,:,:,a,b+a_mx+1),...
                    alpha_mx+1,alpha_mx+1,alpha_mx+1),2,1),...
                    Zsf(:,:,a-b+a_mx+1),2,1),Zsf(:,:,b+a_mx+1),2,1);
                N1 = Ncal(1:alpha_mx+1,1:alpha_mx+1,1:alpha_mx+1);
                N3 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                    1:alpha_mx+1);
                N6 = Ncal(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1),...
                    alpha_mx+2:2*(alpha_mx+1));
                N7 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                    alpha_mx+2:2*(alpha_mx+1));
                Zcal = reshape(Zcalsol(I_s+1,:,:,:,a,b+a_mx+1),...
                    alpha_mx+1,alpha_mx+1,alpha_mx+1);
                dZcalds = (Zcal - reshape(Zcalsol(I_s,:,:,:,a,b+a_mx+1),...
                    alpha_mx+1,alpha_mx+1,alpha_mx+1))/delta;
                dYcalds = (Ycal - reshape(Ycalsol(I_s,:,:,:,a,b+a_mx+1),...
                    alpha_mx+1,alpha_mx+1,alpha_mx+1))/delta;
                Ycalnorm_ab(a,b+a_mx+1) = norm(dYcalds + tensorprod(...
                    tensorprod(tensorprod(Ysf(:,:,a+a_mx+1),N3,2,1),...
                    Ysf(:,:,a-b+a_mx+1),2,1),Ysf(:,:,b+a_mx+1),2,1) ...
                    + permute(tensorprod(tensorprod(Ysf(:,:,a+a_mx+1),...
                    N7,2,1),Ysf(:,:,a-b+a_mx+1),2,1),[1 3 2]) - N6 ...
                    - tensorprod(tensorprod(N1,Ysf(:,:,a-b+a_mx+1),2,1),...
                    Ysf(:,:,b+a_mx+1),2,1)-tensorprod(Lsf1(:,:,a+a_mx+1)...
                    - Ysf(:,:,a+a_mx+1)*Lsf3(:,:,a+a_mx+1),Ycal,2,1) ...
                    + permute(tensorprod(Ycal,Lsf4(:,:,a-b+a_mx+1) ...
                    + Lsf3(:,:,a-b+a_mx+1)*Ysf(:,:,a-b+a_mx+1),2,1),...
                    [1 3 2]) + tensorprod(Ycal,Lsf4(:,:,b+a_mx+1) ...
                    + Lsf3(:,:,b+a_mx+1)*Ysf(:,:,b+a_mx+1),3,1),'fro')...
                    /norm(Ycal,'fro');
                Zcalnorm_ab(a+a_mx+1,b+a_mx+1) = norm(dZcalds ...
                    + permute(tensorprod(Zcal,Lsf1(:,:,a-b+a_mx+1) ...
                    + Lsf2(:,:,a-b+a_mx+1)*Zsf(:,:,a-b+a_mx+1),2,1),...
                    [1 3 2]) + tensorprod(Zcal,Lsf1(:,:,b+a_mx+1) ...
                    + Lsf2(:,:,b+a_mx+1)*Zsf(:,:,b+a_mx+1),3,1) ...
                    - tensorprod(Lsf4(:,:,a+a_mx+1) - Zsf(:,:,a+a_mx+1)...
                    *Lsf2(:,:,a+a_mx+1),Zcal,2,1) ...
                    + tensorprod(Zsf(:,:,a+a_mx+1),N1,2,1) - N3 ...
                    + tensorprod(tensorprod(tensorprod(...
                    Zsf(:,:,a+a_mx+1),N6,2,1),Zsf(:,:,a-b+a_mx+1),2,1),...
                    Zsf(:,:,b+a_mx+1),2,1) - tensorprod(N7,...
                    Zsf(:,:,b+a_mx+1),3,1),'fro')/norm(Zcal,'fro');
            end
        end
    end
    Ycalnorm(I_s) = dot'*Ycalnorm_ab*dot;
    Zcalnorm(I_s) = dot'*Zcalnorm_ab*dot;
end


norms.Ycalnorm = Ycalnorm;
norms.Zcalnorm = Zcalnorm;

Ycalsol = reshape(Ycalsol,n_s,[]);

end