function Nab = Ndefs3D(s,a,b,numparams,geom,lmats,nlmats,Ntype)

% generates tensor blocks N1 N3 N6 N7 in 3D, given numerical and
% geometrical parameters

%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
beta0       = numparams.beta0;
omega       = numparams.omega;


%% DUCT GEOMETRY
R_func      = geom().R;
Rdash_func  = geom().Rdash;
kappa_func  = geom().kappa;

R       = R_func(s);
if Ntype == 0
    curv = true;
    Rvar = true;
elseif Ntype == 1
    curv = false;
    Rvar = false;
elseif Ntype == 2 || Ntype == 3
    curv = true;
    Rvar = false;
else
    disp('error: specify Ntype')
end

if curv == true
    kappa   = kappa_func(s);
else
    kappa   = 0;
end
if Rvar == true
    Rdash   = Rdash_func(s);
else
    Rdash   = 0;
end


%% LINEAR MATRIX DEFINITIONS
Isf         = eye(alpha_mx + 1);
Lambdasf    = lmats.Lambdasf;


%% NONLINEAR MATRIX DEFINITIONS
Ical        = nlmats.Ical;
Wbarcal     = nlmats.Wbarcal;
Acal        = nlmats.Acal;
Atilcal     = nlmats.Atilcal;
IEcal       = nlmats.IEcal;
AEcal       = nlmats.AEcal;
AtilEcal    = nlmats.AtilEcal;


%% N DEFINITION
Nab = zeros(2*(alpha_mx+1),2*(alpha_mx+1),2*(alpha_mx+1));
Nab(1:alpha_mx+1,1:alpha_mx+1,1:alpha_mx+1) ...
    = -(1i*a*omega/(2*sqrt(pi)*R))...
    *(tensorprod(Isf + Lambdasf^2/(a^2*omega^2*R^2),...
    Ical - kappa*R*Acal,2,1) + kappa*Atilcal/(a^2*omega^2*R));
Nab(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,1:alpha_mx+1) ...
    = (sqrt(pi)*R)^-1*(Rdash/R)*Wbarcal;
Nab(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:2*(alpha_mx+1)) = ...
    -Nab(1:alpha_mx+1,1:alpha_mx+1,1:alpha_mx+1) ...
    + 1i*a*omega/(sqrt(pi)*R)*((tensorprod(Isf ...
    + Lambdasf^2/(a^2*omega^2*R^2),IEcal - kappa*R*AEcal,2,1) ...
    + kappa*AtilEcal/(a^2*omega^2*R))/(2*(a - b)*b*omega^2*R^2) ...
    - beta0*(Ical - kappa*R*Acal));
Nab(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1)) ...
    = 1i*omega/(sqrt(pi)*R)*(tensorprod(Ical - kappa*R*Acal,(a-b)*Isf ...
    - b*(Isf - Lambdasf^2/(b^2*omega^2*R^2)),3,1) ...
    + (IEcal - kappa*R*AEcal)/(b*omega^2*R^2));

end