function Nab = Ndefs2D(s,a,b,numparams,geom,lmats,nlmats,Ntype)

% generates tensor blocks N1 N3 N6 N7 in 2D, given numerical and
% geometrical parameters

%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
beta0       = numparams.beta0;
omega       = numparams.omega;


%% DUCT GEOMETRY
X_func      = geom().X;
Xpldash_func= geom().Xpldash;
Xmn_func    = geom().Xmn;
Xmndash_func= geom().Xmndash;
kappa_func  = geom().kappa;

X       = X_func(s);
Xmn     = Xmn_func(s);
if Ntype == 0
    curv = true;
    Xvar = true;
elseif Ntype == 1
    curv = false;
    Xvar = false;
elseif Ntype == 2
    curv = true;
    Xvar = false;
else
    disp('error: specify Ntype')
end
if curv == true
    kappa   = kappa_func(s);
else
    kappa   = 0;
end
if Xvar == true
    Xpldash = Xpldash_func(s);
    Xmndash = Xmndash_func(s);
else
    Xpldash = 0;
    Xmndash = 0;
end


%% LINEAR MATRIX DEFINITIONS
Isf         = eye(alpha_mx + 1);
Lambdasf    = lmats.Lambdasf;


%% NONLINEAR MATRIX DEFINITIONS
Ical        = nlmats.Ical;
Wplbarcal   = nlmats.Wplbarcal;
Wmnbarcal   = nlmats.Wmnbarcal;
Acal        = nlmats.Acal;
Atilcal     = nlmats.Atilcal;
IEcal       = nlmats.IEcal;
AEcal       = nlmats.AEcal;
AtilEcal    = nlmats.AtilEcal;


%% N DEFINITION
Nab = zeros(2*(alpha_mx+1),2*(alpha_mx+1),2*(alpha_mx+1));
Nab(1:alpha_mx+1,1:alpha_mx+1,1:alpha_mx+1) = -(1i*a*omega/2*sqrt(X))...
    *(tensorprod(Isf + Lambdasf^2/(a^2*omega^2*X^2),...
    (1 - kappa*Xmn)*Ical - kappa*X*Acal,2,1) ...
    + kappa*Atilcal/(a^2*omega^2*X));
Nab(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,1:alpha_mx+1) ...
    = X^-1.5*(Xpldash*Wplbarcal - Xmndash*Wmnbarcal);
Nab(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:2*(alpha_mx+1)) = ...
    -Nab(1:alpha_mx+1,1:alpha_mx+1,1:alpha_mx+1) ...
    + 1i*a*omega/sqrt(X)*((tensorprod(Isf + Lambdasf^2/(a^2*omega^2*X^2),...
    (1 - kappa*Xmn)*IEcal -kappa*X*AEcal,2,1)...
    + kappa*AtilEcal/(a^2*omega^2*X))/(2*(a - b)*b*omega^2*X^2)...
    - beta0*((1 - kappa*Xmn)*Ical - kappa*X*Acal));
Nab(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1)) ...
    = 1i*omega/sqrt(X)*(tensorprod((1 - kappa*Xmn)*Ical ...
    - kappa*X*Acal,(a-b)*Isf - b*(Isf - Lambdasf^2/(b^2*omega^2*X^2)),...
    3,1) + ((1 - kappa*Xmn)*IEcal - kappa*X*AEcal)/(b*omega^2*X^2));


end