function geom = outerstraightduct2D(geomparams)


%% PARAMETERS
%duct length s_o and width R_i
if ~exist('geomparams','var')
    geomparams.s_o     = 6;
    geomparams.X_i     = 20;
end

s_o = geomparams.s_o;
X_i = geomparams.X_i;

geom.geomparams = geomparams;


%% SCALAR S-FUNCTIONS
geom.L      = s_o;
geom.X      = @(s) X_i;
geom.Xdash  = @(s) 0;
geom.Xpl    = @(s) 0.5*X_i;
geom.Xpldash= @(s) 0;
geom.Xmn    = @(s) -0.5*X_i;
geom.Xmndash= @(s) 0;
geom.kappa  = @(s) 0;
geom.qyvar  = false;
geom.dim    = 2;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) s;
geom.qy = @(s) 0;
geom.nx = @(s) 0;
geom.ny = @(s) 1;


%% GEOMETRY NAME
geom.name = 'outerstraightduct2D';

end