function geom = exphorndecrease2D(geomparams)


%% PARAMETERS
%width decrease ratio > 1, start width R_i, length s_o, exponent m
if ~exist('geomparams','var')
    geomparams.ratio    = 4;
    geomparams.X_i      = 1;
    geomparams.Xmn_i    = -geomparams.X_i/2;
    geomparams.s_o      = 4.5*geomparams.X_i;
end

ratio   = geomparams.ratio;
X_i     = geomparams.X_i;
s_o     = geomparams.s_o;
m       = -log(ratio)/(2*s_o);

geom.geomparams = geomparams;


%% SCALAR S-FUNCTIONS
    function X = ductradius(s)
        if s <= s_o
            X = X_i*exp(2*m*s);
        else
            X = ratio*X_i;
        end
    end
    function Xdash = ductradiusderiv(s)
        if s <= s_o
            Xdash = 2*m*X_i*exp(2*m*s);
        else
            Xdash = 0;
        end
    end
geom.L      = s_o;
geom.X      = @(s) ductradius(s);
geom.Xdash  = @(s) ductradiusderiv(s);
geom.Xpl    = @(s) 0.5*ductradius(s);
geom.Xpldash= @(s) 0.5*ductradiusderiv(s);
geom.Xmn    = @(s) -0.5*ductradius(s);
geom.Xmndash= @(s) -0.5*ductradiusderiv(s);
geom.kappa  = @(s) 0;
geom.qyvar  = false;
geom.dim    = 2;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) s;
geom.qy = @(s) 0;
geom.nx = @(s) 0;
geom.ny = @(s) 1;
geom.innerqx = @(s) -(s_o - s);
geom.innerqy = @(s) 0;
geom.innernx = @(s) 0;
geom.innerny = @(s) 1;

%% GEOMETRY NAME
geom.name = 'exphorndecrease2D';

end