function geom = Mbend3D(geomparams)


%% PARAMETERS
%pre-bend straight length L1, post-bend straight length L2, bend radius and
% and angle R_B and theta_B, duct radius R_i
if ~exist('geomparams','var')
    geomparams.Lhat     = 5;
    geomparams.R_i      = 0.9;
    geomparams.Rhat     = 1;
    geomparams.thetahat = 3*pi/8;
end


Lhat        = geomparams.Lhat;
R_i         = geomparams.R_i;
Rhat        = geomparams.Rhat;
thetahat    = geomparams.thetahat;

L1M = 7;
% L1M = (Rhat+R_i)*tan(thetahat)*(1-sin(thetahat)) -(Rhat-R_i)*cos(thetahat);

geom.geomparams = geomparams;


%% SCALAR S-FUNCTIONS
s1M     = L1M;
s2M     = s1M + Rhat*(pi/2 + thetahat);
s3M     = s2M + Lhat;
s4M     = s3M + 2*Rhat*thetahat;
s5M     = s4M + Lhat;
s6M     = s5M + Rhat*(pi/2 + thetahat);
    function kappa = ductcurvature(s)
        if s > s1M && s <= s2M || s > s5M && s <= s6M
            kappa = 1/Rhat;
        elseif s > s3M && s <= s4M
            kappa = -1/Rhat;
        else
            kappa = 0;
        end
    end
geom.L      = s6M + L1M;
geom.R      = @(s) R_i;
geom.Rdash  = @(s) 0;
geom.kappa  = @(s) ductcurvature(s);
geom.tau    = @(s) 0;
geom.theta0 = @(s) 0;
geom.qyvar  = true;
geom.qzvar  = false;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS
    function x = ductpathx(s,parity,cl)
        if s <= s1M
            x = 1 - cl;
        elseif s > s1M && s <= s2M
            x = cl*Rhat - parity*cos((s - s1M)/Rhat);
        elseif s > s2M && s <= s3M
            x = cl*Rhat - parity*cos(pi/2 + thetahat) ...
                + cl*Lhat*cos(thetahat)*(s - s2M)/(s3M - s2M);
        elseif s > s3M && s <= s4M
            x = cl*(Rhat +Lhat*cos(thetahat) + 2*Rhat*sin(thetahat))...
                - parity*sin(thetahat -(s - s3M)/Rhat);
        elseif s > s4M && s <= s5M
            x = cl*(Rhat + Lhat*cos(thetahat)*(1+(s - s4M)/(s5M - s4M)) + 4*Rhat*sin(thetahat))...
                - parity*sin(thetahat);
        elseif s > s5M && s <= s6M
            x = cl*(Rhat + 2*Lhat*cos(thetahat) + 4*Rhat*sin(thetahat)) ...
                - parity*sin(thetahat - (s - s5M)/Rhat);
        elseif s > s6M
            x = cl*(Rhat + 2*Lhat*cos(thetahat) + 4*Rhat*sin(thetahat)) ...
                + parity;
        end
    end
    function y = ductpathy(s,parity,cl)
        if s <= s1M
            y = cl*s;
        elseif s > s1M && s <= s2M
            y = cl*L1M + parity*sin((s - s1M)/Rhat);
        elseif s > s2M && s <= s3M
            y = cl*(L1M - Lhat*sin(thetahat)*(s - s2M)/(s3M - s2M)) ...
                + parity*sin(pi/2 + thetahat);
        elseif s > s3M && s <= s4M
            y = cl*(L1M - Lhat*sin(thetahat) + 2*Rhat*cos(thetahat))...
                - parity*cos(thetahat - (s - s3M)/Rhat);
        elseif s > s4M && s <= s5M
            y = cl*(L1M + Lhat*sin(thetahat)*((s - s4M)/(s5M - s4M)-1))...
                + parity*cos(thetahat);
        elseif s > s5M && s <= s6M
            y = cl*L1M + parity*cos(thetahat - (s - s5M)/Rhat);
        elseif s > s6M
            y = cl*L1M*(1 - (s - s6M)/L1M);
        end
    end

geom.qx = @(s) ductpathx(s,Rhat,1);
geom.qy = @(s) ductpathy(s,Rhat,1);
geom.qz = @(s) 0;
geom.nx = @(s) ductpathx(s,-1 + 2*eq(sign(ductcurvature(s)),-1),0);
geom.ny = @(s) ductpathy(s,-1 + 2*eq(sign(ductcurvature(s)),-1),0);
geom.nz = @(s) 0;
geom.bx = @(s) 0;
geom.by = @(s) 0;
geom.bz = @(s) 1;


%% GEOMETRY NAME
geom.name = 'Mbend3D';

end