function [P_sh,Phi_sh] = sincrootfind(sigma)
% given sigma, finds roots of the related transcendental equations
% sin(sigma*P) = P and Phi = sigma*sin(Phi)

if sigma <= 1 + 1e-8
    P_sh = 0;
    Phi_sh = 0;
elseif sigma >= 5*pi/2 - 0.08
    P_sh = pi/(1 + sigma);
    Phi_sh = pi - asin(P_sh);
else
    syms P
    P_sh = vpasolve(sin(sigma*P) == P,[1e-15 1]);
    syms Phi
    Phi_sh = vpasolve(Phi == sigma*sin(Phi),[1e-15 pi]);
end
end