function PwebsRMS = RMSWebsterSol3D(s,geom,numparams,pressuredirection)
s_o     = geom.L;
R_func  = geom().R;
R_o     = R_func(s_o);
ratio   = R_o/R_func(0);

mach    = numparams.mach;
omega   = numparams.omega;
pfwd    = numparams.pfwd;
m       = log(ratio)/s_o;
n       = sqrt(omega^2 - m^2);

if pfwd == true
    denom = sqrt(omega^2 - m^2*cos(n*s_o)^2);
else
    denom = sqrt(omega^2 - m^2*cos(2*n*s_o) - n*m*sin(2*n*s_o));
end
    

if s < s_o
    if pressuredirection == 1
        PwebsRMS = mach*sqrt(pi/omega)*exp(-m*s)...
            *sqrt(omega^2 - m^2*cos(n*(s_o - s))^2)./denom;
    elseif pressuredirection == 0
        PwebsRMS = mach*sqrt(pi/omega)*exp(-m*s)...
            *sqrt(omega^2 - m^2*cos(2*n*(s_o - s)) ...
            - n*m*sin(2*n*(s_o - s)))./denom;
    elseif pressuredirection == -1
        PwebsRMS = mach*sqrt(pi/omega)*exp(-m*s)...
            *sqrt(m^2*sin(n*(s_o - s))^2)/denom;
    end
else
    if pressuredirection == 1 || pressuredirection == 0
        PwebsRMS = mach*sqrt(pi/omega)*exp(-m*s_o)*n/denom;
    elseif pressuredirection == -1
        PwebsRMS = 0;
    end
end