function PwebsRMS = RMSWebsterSol2D(s,geom,numparams,pressuredirection)
s_o     = geom.L;

X_func  = geom().X;
X_o     = X_func(s_o);
ratio   = X_o/X_func(0);

mach    = numparams.mach;
omega   = numparams.omega;
pfwd    = numparams.pfwd;
m       = log(ratio)/(2*s_o);
n       = sqrt(omega^2 - m^2/4);
    
if pfwd == true
    denom = sqrt(omega^2 - m^2*cos(n*s_o))^2;
else
    denom = sqrt(omega^2 - m^2*cos(2*n*s_o) - n*m*sin(2*n*s_o));
end

if s < s_o
    if pressuredirection == 1
        PwebsRMS = mach*exp(-m*s)...
            *sqrt(omega^2 - m^2*cos(n*(s_o - s))^2)./denom;
    elseif pressuredirection == 0
        PwebsRMS = mach*exp(-m*s)...
            *sqrt(omega^2 - m^2*cos(2*n*(s_o - s)) ...
            - n*m*sin(2*n*(s_o - s)))./denom;
    elseif pressuredirection == -1
        PwebsRMS = mach*exp(-m*s)...
            *sqrt(m^2*sin(n*(s_o - s))^2)/denom;
    end
else
    if pressuredirection == 1 || pressuredirection == 0
        PwebsRMS = mach*exp(-m*s_o)*n/denom;
    elseif pressuredirection == -1
        PwebsRMS = 0;
    end
end