function PwebsRMS = RMSNonPlaneSol3D(s,geom,numparams,lmats,pressuredirection)

s_o     = geom.L;

R_func  = geom().R;
R       = R_func(s);
R_o     = R_func(s_o);
R_i     = R_func(0);
ratio   = R_func(0)/R_o;

mach        = numparams.mach;
omega       = real(numparams.omega);
pfwd        = numparams.pfwd;
alpha_entry = numparams.alpha_entry;
modes       = numparams.modes;
m           = -log(ratio)/s_o;
Wsf         = lmats.Wsf;
W_alpha     = Wsf(alpha_entry+1,alpha_entry+1);
nu          = sqrt(W_alpha^2 - omega^2/m^2);

lambda_alpha= modes(alpha_entry+1,2);
p_alpha     = modes(alpha_entry+1,3);

sigma       = -lambda_alpha*exp(-m*s)/(m*R_i);
sigma_o     = -lambda_alpha*exp(-m*s_o)/(m*R_i);
sigma_i     = -lambda_alpha/(m*R_i);



    function I = exbesseli(nu,sigma)
        if imag(nu) == 0
            I = besseli(nu,sigma);
        else
        % elseif imag(nu) ~= 0 && real(nu) == 0
            alpha = imag(nu);
            I = 1/pi*integral(@(theta) exp(sigma*cos(theta))...
                .*cosh(alpha*theta),0,pi) - 1i*sinh(alpha*pi)/pi...
                *integral(@(t) exp(-sigma.*cosh(t)-1i*alpha.*t),0,Inf);
        % else
        %     disp('nu must be purely real or imaginary')
        end
    end
    function K = exbesselk(nu,sigma)
        if imag(nu) == 0
            K = besselk(nu,sigma);
        else
        % else imag(nu) ~= 0 && real(nu) == 0
            alpha = imag(nu);
            K = integral(@(t) exp(-sigma.*cosh(t)).*cos(alpha.*t),0,Inf);
        % else
        %     disp('nu must be purely real or imaginary')
        end
    end

    function sol1 = f1(nu,sigma)
        sol1 = exbesseli(nu,sigma);
    end
    function sol2 = f2(nu,sigma)
        sol2 = exbesselk(nu,sigma);
    end
    function modsol1 = f1til(nu,sigma)
        if imag(nu) == 0
            modsol1 = sigma*f1(nu+1,sigma) ...
                + (nu+W_alpha)*f1(nu,sigma);
        else
            mu = imag(nu);
            % modsol1 = 1/pi*integral(@(theta) (W_alpha + sigma.*cos(theta))...
            %     .*exp(sigma*cos(theta)).*cosh(mu*theta),0,pi) ...
            %     - 1i*sinh(mu*pi)/pi*integral(@(t) (W_alpha -sigma.*cosh(t))...
            %     .*exp(-sigma.*cosh(t)-1i*mu.*t),0,1000);
            modsol1 = 1/pi*integral(@(theta)exp(sigma.*cos(theta))...
                .*((W_alpha + sigma.*cos(theta)).*cosh(mu.*theta) ...
                + 1i.*(mu*cosh(mu.*theta) ...
                - sigma.*sinh(mu.*theta).*sin(theta))),0,pi) ...
                - sinh(mu.*pi)./pi.*integral(@(t)exp(-sigma.*cosh(t) ...
                -1i.*mu.*t).*(-mu + 1i*(W_alpha...
                - sigma.*exp(-t))),0,inf);
        end
    end
    function modsol2 = f2til(nu,sigma)
        if imag(nu) == 0
            modsol2 = -sigma*f2(nu+1,sigma) + (nu+W_alpha)*f2(nu,sigma);
        else
            mu   = imag(nu);
            modsol2 = integral(@(t) (W_alpha + sigma.*cosh(t))...
                .*exp(-sigma.*cosh(t)).*cos(mu.*t),0,625);
            % phi     = (1 + sigma.^2).^(1/4);
            % t0      = asinh(1/sigma);
            % modsol2 = integral(@(t)exp(-sigma.*cosh(t)).*cos(alpha.*t)...
            %     ,0,Inf) ...
            %     - integral(@(t)exp(-sigma.*cosh(t)).*cos(alpha.*t)...
            %     .*sigma.*cosh(t),0,625)...
            %     + 1i*integral(@(t)exp(-sigma.*cosh(t))...
            %     .*alpha.*cos(alpha.*t),0,inf)...
            %     - 1i*integral(@(t)exp(-sigma.*cosh(t))...
            %     .*sigma.*sin(alpha.*t).*sinh(t),0,inf);
            % modsol2 = integral(@(t)exp(-sigma.*cosh(t)).*cos(alpha.*t)...
            %     .*(1 + 0.5.*sigma.*exp(-t)),0,Inf)...
            %     + (phi + 1./phi)/2.*exp(-phi.^2).*integral(@(y) ...
            %     exp(-y.^2/2).*cos(alpha.*(t0 + y./phi)),-phi.*t0,Inf);
        end
    end



Ypl_o = 1i*exp(-1i*pi/4*(sign(1 - m^2*sigma_o^2/omega^2) + 1))...
    *sqrt(abs(1 - m^2*sigma_o^2/omega^2));
Ypl_i = 1i*exp(-1i*pi/4*(sign(1 - m^2*sigma_i^2/omega^2) + 1))...
    *sqrt(abs(1 - m^2*sigma_i^2/omega^2));
Ypl = 1i*exp(-1i*pi/4*(sign(1 - m^2*sigma^2/omega^2) + 1))...
    *sqrt(abs(1 - m^2*sigma^2/omega^2));


c1 = 1;
c2 = -c1*(f1til(nu,sigma_o) - omega*Ypl_o/(1i*m)*f1(nu,sigma_o))...
    /(f2til(nu,sigma_o) - omega*Ypl_o/(1i*m)*f2(nu,sigma_o));



P_unnorm = c1*f1(nu,sigma) + c2*f2(nu,sigma);
U_unnorm = 1i*m/omega*(c1*f1til(nu,sigma) + c2*f2til(nu,sigma));



P_i_unnorm = c1*f1(nu,sigma_i) + c2*f2(nu,sigma_i);
U_i_unnorm = 1i*m/omega*(c1*f1til(nu,sigma_i) + c2*f2til(nu,sigma_i));

Y = U_unnorm/P_unnorm;
Y_i = U_i_unnorm/P_i_unnorm;


% disp([s,Ypl,log(U_unnorm)])


Spl_i = (2*Ypl_i)\(Y_i + Ypl_i);
Spl   = (2*Ypl)\(Y + Ypl);
Smn   = -(2*Ypl)\(Y - Ypl);


if pfwd == true
    denom = Spl_i\P_i_unnorm;
else
    denom = P_i_unnorm;
end


% disp([s,Spl])

% disp([Y,Ypl])


if s <= s_o
    if pressuredirection == 1
        PwebsRMS = sqrt(1/(1 - p_alpha^2/lambda_alpha^2))...
            *mach*R_i*abs(Spl*P_unnorm/denom)/R;
    elseif pressuredirection == 0
        PwebsRMS = sqrt(1/(1 - p_alpha^2/lambda_alpha^2))...
            *mach*R_i*abs(P_unnorm/denom)/R;
    elseif pressuredirection == -1
        PwebsRMS = sqrt(1/(1 - p_alpha^2/lambda_alpha^2))...
            *mach*R_i*abs(Smn*P_unnorm/denom)/R;
    end
else
    if pressuredirection == 1 || pressuredirection == 0
        PwebsRMS = mach*sqrt(pi/omega)*exp(-(m/2)*s_o)*nu/denom;
    elseif pressuredirection == -1
        PwebsRMS = 0;
    end
end
% disp([s,Spl,Y,Ypl,Spl*P_unnorm/denom])



end