0;

set(0,'DefaultAxesFontName','Times')
set(0,'DefaultAxesFontSize',10)
widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
figure('units','centimeters','position',[5 -5 widthCM 0.5*widthCM]);



filename1 = ...
    'exphorn2D_alpha000_a001_omega0.1865_linear_s_d10.0000_ptot.mat';
filename2 = ...
    'exphorn2D_alpha050_a001_omega0.1865_linear_s_d10.0000_ptot.mat';

% filename1 = ...
%     'exphorndecrease2D_alpha001_a001_omega4.8000_linear_s_d04.5000_ptot.mat';
% filename2 = ...
%     'exphorndecrease2D_alpha011_a001_omega4.8000_linear_s_d04.5000_ptot.mat';
pressuredirection = 0;
%pressuredirection = 0 for total, 1 for fwd, -1 for backward
load(filename1,'numparams','geomname','geomparams')
if pressuredirection == -1
    plotparams.pressurelabel = '$$p^-/M$$';
    load(filename1,'Pmnint')
    Pchoice1 = Pmnint;
elseif pressuredirection == 0
    plotparams.pressurelabel = '$$p/M$$';
    load(filename1,'Pint')
    Pchoice1 = Pint;
elseif pressuredirection == 1
    plotparams.pressurelabel = '$$p^+/M$$';
    load(filename1,'Pplint')
    Pchoice1 = Pplint;
else
    plotparams.pressurelabel = '$$p/M$$';
    disp('bad pressure direction')
end

geom        = eval(strcat(geomname,'(','geomparams',')'));
X_func      = geom().X;
Xmn_func    = geom().Xmn;

alpha_mx1   = numparams.alpha_mx;
a_mx        = numparams.a_mx;
s_d         = numparams.s_d;
omega       = numparams.omega;
modes1      = numparams.modes;
mach        = numparams.mach;
beta0       = numparams.beta0;

%pressuredirection = 0 for total, 1 for fwd, -1 for backward
load(filename2,'numparams')
if pressuredirection == -1
    plotparams.pressurelabel = '$$p^-/M$$';
    load(filename2,'Pmnint')
    Pchoice2 = Pmnint;
elseif pressuredirection == 0
    plotparams.pressurelabel = '$$p/M$$';
    load(filename2,'Pint')
    Pchoice2 = Pint;
elseif pressuredirection == 1
    plotparams.pressurelabel = '$$p^+/M$$';
    load(filename2,'Pplint')
    Pchoice2 = Pplint;
else
    plotparams.pressurelabel = '$$p/M$$';
    disp('bad pressure direction')
end


alpha_mx2   = numparams.alpha_mx;
modes2      = numparams.modes;


disp('summing over modes...')
hold off
dot     = ones(2*a_mx+1,1);
n_s = 1000;
s   = (0:s_d/n_s:s_d)';
S_P1 = {s, 1:(2*a_mx+1)*(alpha_mx1+1)};
S_P2 = {s, 1:(2*a_mx+1)*(alpha_mx2+1)};
P1   = Pchoice1(S_P1);
P2   = Pchoice2(S_P2);
Xdenom  = zeros(size(s));
for I_s = 1:length(s)
    Xdenom(I_s) = 1/sqrt(X_func(s(I_s)));
end
P1   = reshape(P1,[],alpha_mx1+1,2*a_mx+1);
P2   = reshape(P2,[],alpha_mx2+1,2*a_mx+1);
Xdenom1  = repmat(Xdenom,1,alpha_mx1+1,2*a_mx+1);
Xdenom2  = repmat(Xdenom,1,alpha_mx2+1,2*a_mx+1);
C_alpha1     = zeros(size(modes1(:,1)))';
C_alpha2     = zeros(size(modes2(:,1)))';
cos_alphaX1  = zeros(length(s),length(modes1(:,1)));
cos_alphaX2  = zeros(length(s),length(modes2(:,1)));
for alpha = 0:alpha_mx1
    C_alpha1(alpha+1) = modes1(alpha+1,3);
end
for alpha = 0:alpha_mx2
    C_alpha2(alpha+1) = modes2(alpha+1,3);
end
for I_s = 1:length(s)
    for alpha = 0:alpha_mx1
        cos_alphaX1(I_s,alpha+1) =cos(alpha*pi*Xmn_func(s(I_s))/...
            X_func(s(I_s)));
        % cos_alphaX1(I_s,alpha+1) =cos(0);
    end
    for alpha = 0:alpha_mx2
        cos_alphaX2(I_s,alpha+1) =cos(alpha*pi*Xmn_func(s(I_s))/...
            X_func(s(I_s)));
        % cos_alphaX2(I_s,alpha+1) =cos(0);
    end
end
C_alpha1 = repmat(C_alpha1,length(s),1,2*a_mx+1);
cos_alphaX1 = repmat(cos_alphaX1,1,1,2*a_mx+1);
alphadot1 = ones(alpha_mx1+1,1);
P_a1   = tensorprod(P1.*Xdenom1.*C_alpha1.*cos_alphaX1,alphadot1,2,1);
C_alpha2 = repmat(C_alpha2,length(s),1,2*a_mx+1);
cos_alphaX2 = repmat(cos_alphaX2,1,1,2*a_mx+1);
alphadot2 = ones(alpha_mx2+1,1);
P_a2   = tensorprod(P2.*Xdenom2.*C_alpha2.*cos_alphaX2,alphadot2,2,1);
Pwebs_RMS = zeros(size(s));
for I_s = 1:length(s)
    Pwebs_RMS(I_s) = RMSWebsterSol2D(s(I_s),geom,numparams,...
        pressuredirection);
end
plot(s,Pwebs_RMS/mach,'k-','DisplayName','Analytic');
hold on
plot(s,sqrt(2*P_a1.*conj(P_a1)*dot)/mach,'g-.','DisplayName',...
    '1 mode')
plot(s,sqrt(2*P_a2.*conj(P_a2)*dot)/mach,'r-.','DisplayName',...
    '50 modes')
xlabel('$$s$$')
if pressuredirection == 1
    ylabel('$$\frac{\sqrt{\sum_{a = -\infty}^\infty|P^{a+}|^2}}{M}$$',...
        'Rotation',0,'HorizontalAlignment','right',...
        'VerticalAlignment','middle')
elseif pressuredirection == 0
    ylabel('$$\frac{\sqrt{\sum_{a = -\infty}^\infty|P^a|^2}}{M}$$',...
        'Rotation',0,'HorizontalAlignment','right',...
        'VerticalAlignment','middle')
elseif pressuredirection == -1
    ylabel('$$\frac{\sqrt{\sum_{a = -\infty}^\infty|P^{a-}|^2}}{M}$$',...
        'Rotation',0,'HorizontalAlignment','right',...
        'VerticalAlignment','middle')
end
legend
exportgraphics(gcf,'stillplaceholderp4.pdf','ContentType','vector')