function set_custom_colormap(n)
  Ncols = 256;
  colmap = zeros(Ncols,3);
  if (n == 1)
    for col = 1:Ncols
      colmap(col,:) = custom_color((col-1)/(Ncols-1));
    end
  elseif (n==2)
    for col = 1:Ncols
      colmap(col,:) = custom_color2((col-1)/(Ncols-1));
    end
  end
  colormap(colmap);
end

% gray in [0,1]
function triple = custom_color(gray)
    gray = 6*gray;
    if (gray < 1)
        r = 0;
        g=0*gray;
        b=0.5*(gray+1);
    elseif (gray < 3)
        r = 0.5*(gray-1);
        g = 0.5*(gray-1);
        b = 1;
    elseif (gray < 5)
        r = 1;
        g = 0.5*(5-gray);
        b = 0.5*(5-gray);
    else
        r = 0.5*(7-gray);
        g = 0;
        b = 0;
    end
    triple = [r,g,b];
end

% gray in [0,1]
function triple = custom_color2(gray)
    gray = 2*gray;
    if (gray < 1)
        r=gray;
        g=gray;
        b=1;
    else
        r=1;
        g=2-gray;
        b=2-gray;
    end
    triple = [r,g,b];
end
