function smats = splittingdefs(s,numparams,geom,charmats)

% defines splitting matrices at a point s in the duct, given numerical and
% geometrical parameters as well as characteristic admittances at that
% point

alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
nonlinear   = numparams.nonlinear;

if geom.inner == false
    Ysfint      = geom.Ysfint;
    Ysf         = reshape(Ysfint({s,1:(alpha_mx+1)^2*(2*a_mx+1)}),...
        alpha_mx+1,alpha_mx+1,2*a_mx+1);
    Ysf_pos     = Ysf(:,:,a_mx+2:2*a_mx+1);
else
    Ysf_pos = geom.YsfR_pos;
end
Ysfpl_pos   = charmats.Ysfpl_pos;
Ysfmn_pos   = charmats.Ysfmn_pos;
Ssfpl_pos   = zeros(alpha_mx+1,alpha_mx+1,a_mx);
Ssfmn_pos   = zeros(alpha_mx+1,alpha_mx+1,a_mx);
for a = 1:a_mx
    Ssfpl_pos(:,:,a) = (Ysfpl_pos(:,:,a)-Ysfmn_pos(:,:,a))...
        \(Ysf_pos(:,:,a) - Ysfmn_pos(:,:,a));
    Ssfmn_pos(:,:,a) = (Ysfmn_pos(:,:,a)-Ysfpl_pos(:,:,a))...
        \(Ysf_pos(:,:,a) - Ysfpl_pos(:,:,a));
end
if nonlinear == true
    if geom.inner == false
        Ycalint = geom.Ycalint;
        Ycal    = reshape(Ycalint({s,1:(alpha_mx+1)^3*(2*a_mx+1)*a_mx}),...
            alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1);
    else
        Ycal = geom.YcalR_pos;
    end
    Ssfpl   = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
    Ssfmn   = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
    Ssfpl(:,:,a_mx+2:2*a_mx+1)    = Ssfpl_pos(:,:,1:a_mx);
    Ssfpl(:,:,a_mx:-1:1)          = conj(Ssfpl_pos(:,:,1:a_mx));
    Ssfmn(:,:,a_mx+2:2*a_mx+1)    = Ssfmn_pos(:,:,1:a_mx);
    Ssfmn(:,:,a_mx:-1:1)          = conj(Ssfmn_pos(:,:,1:a_mx));
    Scalpl_pos  = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1);
    Scalmn_pos  = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1);

    Ysfpl       = charmats.Ysfpl;
    Ysfmn       = charmats.Ysfmn;
    Ycalpl_pos  = charmats.Ycalpl_pos;
    Ycalmn_pos  = charmats.Ycalmn_pos;

    for a = 1:a_mx
        for b = -a_mx+a:a_mx
            if b ~= 0 && b ~= a
                Scalpl_pos(:,:,:,a,b+a_mx+1)...
                    = tensorprod(inv(Ysfpl(:,:,a+a_mx+1) ...
                    - Ysfmn(:,:,a+a_mx+1)),Ycal(:,:,:,a,b+a_mx+1) ...
                    -tensorprod(tensorprod(Ycalpl_pos(:,:,:,a,b+a_mx+1),...
                    Ssfpl(:,:,a-b+a_mx+1),2,1),Ssfpl(:,:,b+a_mx+1),2,1) ...
                    -tensorprod(tensorprod(Ycalmn_pos(:,:,:,a,b+a_mx+1),...
                    Ssfmn(:,:,a-b+a_mx+1),2,1),...
                    Ssfmn(:,:,b+a_mx+1),2,1),2,1);
                Scalmn_pos(:,:,:,a,b+a_mx+1)...
                    = tensorprod(inv(Ysfmn(:,:,a+a_mx+1) ...
                    - Ysfpl(:,:,a+a_mx+1)),Ycal(:,:,:,a,b+a_mx+1) ...
                    -tensorprod(tensorprod(Ycalpl_pos(:,:,:,a,b+a_mx+1),...
                    Ssfpl(:,:,a-b+a_mx+1),2,1),Ssfpl(:,:,b+a_mx+1),2,1) ...
                    -tensorprod(tensorprod(Ycalmn_pos(:,:,:,a,b+a_mx+1),...
                    Ssfmn(:,:,a-b+a_mx+1),2,1),...
                    Ssfmn(:,:,b+a_mx+1),2,1),2,1);
            end
        end
    end
end

smats.Ssfpl_pos = Ssfpl_pos;
smats.Ssfmn_pos = Ssfmn_pos;
smats.Ysfpl_pos = Ysfpl_pos;
smats.Ysfmn_pos = Ysfmn_pos;

if nonlinear == true
    smats.Ssfpl         = Ssfpl;
    smats.Ssfmn         = Ssfmn;
    smats.Ysfpl         = Ysfpl;
    smats.Ysfmn         = Ysfmn;
    smats.Scalpl_pos    = Scalpl_pos;
    smats.Scalmn_pos    = Scalmn_pos;
    smats.Ycalpl_pos    = Ycalpl_pos;
    smats.Ycalmn_pos    = Ycalmn_pos;
end