function dYcal_ds_pos = dYcal_ds_def(s,Ycal_pos,numparams,geom,lmats,...
    nlmats)

% defines tensor d(Ycal)ds at a point s in the duct, given numerical and 
% geometrical parameters

fprintf(1,'s = %6.3f\r', s);

%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;


%% DUCT DATA
Ysfint          = geom.Ysfint;
S_Ysf_Ycalsol   = {(s),1:(2*a_mx+1)*(alpha_mx+1)^2};
Ysf             = reshape(Ysfint(S_Ysf_Ycalsol),...
    [alpha_mx+1,alpha_mx+1,2*a_mx+1]);


%forcing matrix
dYcal_ds_pos    = zeros(alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1);
%matrix multiplication requires column vector to become matrix
Ycal_pos = reshape(Ycal_pos,[alpha_mx+1,alpha_mx+1,alpha_mx+1,...
    a_mx,2*a_mx+1]);


Lsf1 = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
Lsf2 = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
Lsf3 = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
Lsf4 = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);

for a = -a_mx:a_mx
    if a ~=0
        if geom.dim == 2
            Lsf  = Ldefs2D(s,a,numparams,geom,lmats,0);
        elseif geom.dim == 3
            Lsf = Ldefs3D(s,a,numparams,geom,lmats,0);
        end
        Lsf1(:,:,a+a_mx+1) = Lsf(1:alpha_mx+1,1:alpha_mx+1);
        Lsf2(:,:,a+a_mx+1) = Lsf(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1));
        Lsf3(:,:,a+a_mx+1) = Lsf(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1);
        Lsf4(:,:,a+a_mx+1) = Lsf(alpha_mx+2:2*(alpha_mx+1),...
            alpha_mx+2:2*(alpha_mx+1));
    end
end
for a = 1:a_mx
    for b = -a_mx+a:a_mx
        if b ~= 0 && b ~= a
            if geom.dim == 2
                Ncal= Ndefs2D(s,a,b,numparams,geom,lmats,nlmats,0);
            elseif geom.dim == 3
                Ncal= Ndefs3D(s,a,b,numparams,geom,lmats,nlmats,0);
            end
            N1 = Ncal(1:alpha_mx+1,1:alpha_mx+1,1:alpha_mx+1);
            N3 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                1:alpha_mx+1); 
            N6 = Ncal(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1),...
                alpha_mx+2:2*(alpha_mx+1));
            N7 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                alpha_mx+2:2*(alpha_mx+1));
            dYcal_ds_pos(:,:,:,a,b+a_mx+1) = -tensorprod(...
                tensorprod(tensorprod(Ysf(:,:,a+a_mx+1),N3,2,1),...
                Ysf(:,:,a-b+a_mx+1),2,1),Ysf(:,:,b+a_mx+1),2,1) ...
                - permute(tensorprod(tensorprod(Ysf(:,:,a+a_mx+1),...
                N7,2,1),Ysf(:,:,a-b+a_mx+1),2,1),[1 3 2]) + N6 ...
                + tensorprod(tensorprod(N1,Ysf(:,:,a-b+a_mx+1),2,1),...
                Ysf(:,:,b+a_mx+1),2,1) + tensorprod(Lsf1(:,:,a+a_mx+1) ...
                - Ysf(:,:,a+a_mx+1)*Lsf3(:,:,a+a_mx+1),...
                Ycal_pos(:,:,:,a,b+a_mx+1),2,1) ...
                - permute(tensorprod(Ycal_pos(:,:,:,a,b+a_mx+1),...
                Lsf4(:,:,a-b+a_mx+1) + Lsf3(:,:,a-b+a_mx+1)...
                *Ysf(:,:,a-b+a_mx+1),2,1),[1 3 2]) ...
                - tensorprod(Ycal_pos(:,:,:,a,b+a_mx+1),...
                Lsf4(:,:,b+a_mx+1) + Lsf3(:,:,b+a_mx+1)...
                *Ysf(:,:,b+a_mx+1),3,1);
        end
    end
end

%convert back to column vector
dYcal_ds_pos = reshape(dYcal_ds_pos,[a_mx*(2*a_mx+1)*(alpha_mx+1)^3,1]);

end