function dPds_pos = dPds_def(s,P_pos,numparams,geom,lmats,nlmats)

% defines dPds at a point s in the duct, given numerical and geometrical
% parameters

fprintf(1,'s = %6.3f\r', s);

%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
nonlinear   = numparams.nonlinear;
omega       = real(numparams.omega);


%% DUCT DATA
Ysf         = geom.Ysfint({s,1:(2*a_mx+1)*(alpha_mx+1)^2});
Ysf_pos     = Ysf(:,(a_mx+1)*(alpha_mx+1)^2+1:(2*a_mx+1)*(alpha_mx+1)^2);


Lsf1    = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
Lsf2    = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
Lsf3    = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
Lsf4    = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);

dPds_pos= zeros(alpha_mx+1,a_mx);

%fill out the rest of p using complex conjugate rule
P = zeros(alpha_mx+1,2*a_mx+1);

%matrix multiplication requires column vector to become matrix
P_pos   = reshape(P_pos,alpha_mx+1,a_mx);
P(:,a_mx+2:2*a_mx+1) = P_pos;
P(:,a_mx:-1:1) = conj(P_pos);
Ysf_pos = reshape(Ysf_pos,[alpha_mx+1,alpha_mx+1,a_mx]);

if nonlinear == true
    dot         = ones(2*a_mx + 1,1);
    numvisc     = numparams.numvisc;
    beta0       = numparams.beta0;
    mach        = numparams.mach;
    RHS_pp      = zeros(alpha_mx+1,a_mx,a_mx);
    Ysf         = reshape(Ysf,[alpha_mx+1,alpha_mx+1,2*a_mx+1]);
    Ycal        = reshape(geom.Ycalint({s,...
        1:a_mx*(2*a_mx+1)*(alpha_mx+1)^3}),...
        [alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1]);
end


for a = -a_mx:a_mx
    if a ~=0
        if geom.dim == 2
            Lsf = Ldefs2D(s,a,numparams,geom,lmats,0);
        elseif geom.dim == 3
            Lsf = Ldefs3D(s,a,numparams,geom,lmats,0);
        end
        Lsf1(:,:,a+a_mx+1) = Lsf(1:alpha_mx+1,1:alpha_mx+1);
        Lsf2(:,:,a+a_mx+1) = Lsf(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1));
        Lsf3(:,:,a+a_mx+1) = Lsf(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1);
        Lsf4(:,:,a+a_mx+1) = Lsf(alpha_mx+2:2*(alpha_mx+1),...
            alpha_mx+2:2*(alpha_mx+1));
    end
end
for a = 1:a_mx
    if nonlinear == true
        for b = -a_mx+a:a_mx
            if b ~= 0
                if geom.dim == 2
                    Ncal = Ndefs2D(s,a,b,numparams,geom,lmats,nlmats,0);
                elseif geom.dim == 3
                    Ncal = Ndefs3D(s,a,b,numparams,geom,lmats,nlmats,0);
                end
                N3 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                    1:alpha_mx+1);
                N7 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                    alpha_mx+2:2*(alpha_mx+1));
                RHS_pp(:,a,b+a_mx+1) = tensorprod(tensorprod( ...
                    tensorprod(Lsf3(:,:,a+a_mx+1),...
                    Ycal(:,:,:,a,b+a_mx+1),2,1) ...
                    + tensorprod(tensorprod(N3,Ysf(:,:,a-b+a_mx+1),2,1),...
                    Ysf(:,:,b+a_mx+1),2,1) + permute(tensorprod(N7,...
                    Ysf(:,:,a-b+a_mx+1),2,1),[1 3 2]),...
                    P(:,a-b+a_mx+1),2,1),P(:,b+a_mx+1),2,1);
            end
        end
        dPds_pos(:,a) = (Lsf3(:,:,a+a_mx+1)*Ysf_pos(:,:,a) ...
            + Lsf4(:,:,a+a_mx+1))*P_pos(:,a)...
            + reshape(RHS_pp(:,a,:),alpha_mx+1,2*a_mx+1)*dot...
            + (numvisc)*beta0*mach*omega*a/(1 + beta0*mach*omega*s)...
            *log(1 -(a-1)/a_mx)*P_pos(:,a);
    else
        dPds_pos(:,a) = (Lsf3(:,:,a+a_mx+1)*Ysf_pos(:,:,a) ...
            + Lsf4(:,:,a+a_mx+1))*P_pos(:,a);
    end
end


%convert back to column vector
dPds_pos = reshape(dPds_pos,[a_mx*(alpha_mx+1),1]);

end