function [s_grid,P_posgrid,norms] ...
    = Pmagnusmobius(sspan,Pinput,numparams,geom,lmats,nlmats)

%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
numvisc     = numparams.numvisc;
nonlinear   = numparams.nonlinear;
beta0       = numparams.beta0;
mach        = numparams.mach;
omega       = real(numparams.omega);
delta       = numparams.delta;

s_sf        = 1/(beta0*mach*omega);
s_grid      = (sspan(1):delta:sspan(2))';
n_s         = length(s_grid);
P_posgrid   = zeros(n_s,alpha_mx+1,a_mx);
P_posgrid(1,:,:) = Pinput;

errornorm   = zeros(n_s,1);
Pnorm       = zeros(n_s,1);

%% DUCT DATA
Ysfint = geom.Ysfint;

if nonlinear == true
    Ycalint = geom.Ycalint;
end

dot = ones(2*a_mx+1,1);

Lsf = zeros(2*(alpha_mx+1),2*(alpha_mx+1),2*a_mx+1);
Lsf3  = zeros(alpha_mx+1,alpha_mx+1,2*a_mx);
Lsf4  = zeros(alpha_mx+1,alpha_mx+1,2*a_mx);
Esf = zeros(2*(alpha_mx+1),2*(alpha_mx+1),2*a_mx+1);
Esfsqrt = zeros(2*(alpha_mx+1),2*(alpha_mx+1),2*a_mx+1);
Esf3 = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
Esf4 = zeros(alpha_mx+1,alpha_mx+1,2*a_mx+1);
nlop1PP = zeros(alpha_mx+1,a_mx,2*a_mx+1);
nlop2PP = zeros(alpha_mx+1,a_mx,2*a_mx+1);

P = zeros(alpha_mx+1,a_mx);
errornorm_a = zeros(a_mx,1);
Pnorm_a     = zeros(a_mx,1);


for I_s = 2:n_s
    s = (s_grid(I_s) + s_grid(I_s - 1))/2;
    fprintf(1,'s = %6.3f\r', s);
    
    % X_func  = geom().X;
    % X       = X_func(s);
    % testmat = zeros(alpha_mx+1,a_mx);

    Ysf = reshape(Ysfint({s_grid(I_s),1:(2*a_mx+1)*(alpha_mx+1)^2}),...
        [alpha_mx+1,alpha_mx+1,2*a_mx+1]);
    if nonlinear == true
        Ycal = reshape(Ycalint({s_grid(I_s),...
            1:a_mx*(2*a_mx+1)*(alpha_mx+1)^3}),...
            [alpha_mx+1,alpha_mx+1,alpha_mx+1,a_mx,2*a_mx+1]);
    end
    %fill out the rest of p using complex conjugate rule
    P(:,a_mx+2:2*a_mx+1) = reshape(P_posgrid(I_s-1,:,:),alpha_mx+1,a_mx);
    P(:,a_mx:-1:1) = conj(P(:,a_mx+2:2*a_mx+1));
    for a = -a_mx:a_mx
        if a ~= 0
            if geom.dimensions == 2
                Lsf(:,:,a+a_mx+1) = Ldefs2D(s,a,numparams,geom,lmats,0);
            elseif geom.dimensions == 3
                Lsf(:,:,a+a_mx+1) = Ldefs3D(s,a,numparams,geom,lmats,0);
            end
            Lsf3(:,:,a+a_mx+1) = Lsf(alpha_mx+2:2*(alpha_mx+1),...
                1:alpha_mx+1,a+a_mx+1);
            Lsf4(:,:,a+a_mx+1) = Lsf(alpha_mx+2:2*(alpha_mx+1),...
                alpha_mx+2:2*(alpha_mx+1),a+a_mx+1);
            Esf(:,:,a+a_mx+1) = expm(-delta*Lsf(:,:,a+a_mx+1));
            Esf3(:,:,a+a_mx+1) = Esf(alpha_mx+2:2*(alpha_mx+1),...
                1:alpha_mx+1,a+a_mx+1);
            Esf4(:,:,a+a_mx+1) = Esf(alpha_mx+2:2*(alpha_mx+1),...
                alpha_mx+2:2*(alpha_mx+1),a+a_mx+1);
            Esfsqrt(:,:,a+a_mx+1) = expm(-0.5*delta*Lsf(:,:,a+a_mx+1));
        end
    end
    for a = 1:a_mx
        % testmat(:,a) = diag(lmats.Lambdasf)/(a*omega*X);


        P_pos = reshape(P_posgrid(I_s-1,:,a),alpha_mx+1,1);
        if nonlinear == true
            for b = -a_mx+a:a_mx
                if b ~= 0 && a ~= b
                    if geom.dimensions == 2
                        Ncal = Ndefs2D(s,a,b,numparams,geom,lmats,...
                            nlmats,0);
                    elseif geom.dimensions == 3
                        Ncal = Ndefs3D(s,a,b,numparams,geom,lmats,...
                            nlmats,0);
                    end
                    N3 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                        1:alpha_mx+1);
                    N7 = Ncal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                        alpha_mx+2:2*(alpha_mx+1));
                    Ecal = -delta*tensorprod(tensorprod(tensorprod(...
                        Esfsqrt(:,:,a+a_mx+1),Ncal,2,1),...
                        Esfsqrt(:,:,a-b+a_mx+1),2,1),...
                        Esfsqrt(:,:,b+a_mx+1),2,1);
                    % Ecal = -delta*tensorprod(tensorprod(Ncal,...
                    %     Esf(:,:,a-b+a_mx+1),2,1),...
                    %     Esf(:,:,b+a_mx+1),2,1);
                    Ecal3 = Ecal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                        1:alpha_mx+1);
                    Ecal4 = Ecal(alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:...
                        2*(alpha_mx+1),1:alpha_mx+1);
                    Ecal7 = Ecal(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1,...
                        alpha_mx+2:2*(alpha_mx+1));
                    Ecal8 = Ecal(alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:...
                        2*(alpha_mx+1),alpha_mx+2:2*(alpha_mx+1));
                    nlop1 = tensorprod(Esf3(:,:,a+a_mx+1),...
                        Ycal(:,:,:,a,b+a_mx+1),2,1) ...
                        + tensorprod(tensorprod(Ecal3,...
                        Ysf(:,:,a-b+a_mx+1),2,1),Ysf(:,:,b+a_mx+1),2,1)...
                        + tensorprod(Ecal4,Ysf(:,:,b+a_mx+1),3,1) ...
                        + permute(tensorprod(Ecal7,Ysf(:,:,a-b+a_mx+1),...
                        2,1),[1 3 2]) + Ecal8;
                    nlop1PP(:,a,b+a_mx+1) = tensorprod(tensorprod(nlop1,...
                        (Esf3(:,:,a-b+a_mx+1)*Ysf(:,:,a-b+a_mx+1) ...
                        + Esf4(:,:,a-b+a_mx+1))\P(:,a-b+a_mx+1),2,1),...
                        (Esf3(:,:,b+a_mx+1)*Ysf(:,:,b+a_mx+1) ...
                        + Esf4(:,:,b+a_mx+1))\P(:,b+a_mx+1),2,1);
                    nlop2 = tensorprod(Lsf3(:,:,a+a_mx+1),Ycal,2,1) ...
                        + tensorprod(tensorprod(N3,Ysf(:,:,a-b+a_mx+1),...
                        2,1),Ysf(:,:,b+a_mx+1),2,1) + permute(...
                        tensorprod(N7,Ysf(:,:,a-b+a_mx+1),2,1),[1 3 2]);
                    nlop2PP = tensorprod(tensorprod(nlop2,...
                        (Esf3(:,:,a-b+a_mx+1)*Ysf(:,:,a-b+a_mx+1) ...
                        + Esf4(:,:,a-b+a_mx+1))\P(:,a-b+a_mx+1),2,1),...
                        (Esf3(:,:,b+a_mx+1)*Ysf(:,:,b+a_mx+1) ...
                        + Esf4(:,:,b+a_mx+1))\P(:,b+a_mx+1),2,1);
                end
            end
            P_posgrid(I_s,:,a) =(1-a/(a_mx+1))^(numvisc*a*(delta/s_sf)...
                /(1 + s/s_sf))...
                *((Esf3(:,:,a+a_mx+1)*Ysf(:,:,a+a_mx+1) ...
                + Esf4(:,:,a+a_mx+1))\(P_pos - ...
                tensorprod(nlop1PP(:,a,:),dot,3,1)));
            dP_posds = (reshape(P_posgrid(I_s,:,a),alpha_mx+1,1) ...
                - P_pos)/delta;
            if norm(P_pos,'fro') ~= 0
                errornorm_a(a) = norm(dP_posds - (Lsf3(:,:,a+a_mx+1)...
                    *Ysf(:,:,a+a_mx+1) +Lsf4(:,:,a+a_mx+1))*P_pos ...
                    - tensorprod(nlop2PP,dot,3,1),'fro')...
                    /(norm(P_pos,'fro'));
            end
            Pnorm_a(a) = norm(P_posgrid(I_s,:,a));
        else
            P_posgrid(I_s,:,a) = (Esf3(:,:,a+a_mx+1)*Ysf(:,:,a+a_mx+1) ...
                + Esf4(:,:,a+a_mx+1))\P_pos;
            dP_posds = (reshape(P_posgrid(I_s,:,a),alpha_mx+1,1) ...
                - P_pos)/delta;
            errornorm_a(a) = norm(dP_posds ...
                - (Lsf3(:,:,a+a_mx+1)*Ysf(:,:,a+a_mx+1) +Lsf4(:,:,a+a_mx+1))...
                *P_pos,'fro')/(norm(P_pos,'fro')+eq(norm(P_pos,'fro'),0));
            Pnorm_a(a) = norm(P_posgrid(I_s,:,a));
        end
    end
    errornorm(I_s) = ones(1,a_mx)*errornorm_a;
    Pnorm(I_s) = ones(1,a_mx)*Pnorm_a;
    % fprintf(1,'Pnorm/M = %6.3f\r',Pnorm(I_s)/mach);
    if Pnorm(I_s)/mach > 10^3
        % reshape(Ycal,a_mx,2*a_mx+1)'
        % reshape(P_posgrid(I_s,:,:),1,a_mx)
    end
    if isnan(Pnorm(I_s))
        disp('Infinite pressure reached')
        disp(strcat('Terminating at s=',num2str(s)))
        break
    end
    % disp(max(abs(testmat)))
end
norms.Pnorm_pos = errornorm;
P_posgrid = reshape(P_posgrid,length(s_grid),[]);
end