function La = Ldefs3D(s,a,numparams,geom,lmats,Ltype)

% generates matrix blocks L1 L2 L3 L4 in 3D, given numerical and
% geometrical parameters

%% NUMERICAL DATA
alpha_mx    = numparams.alpha_mx;
omega       = numparams.omega;


%% DUCT GEOMETRY
R_func      = geom().R;
Rdash_func  = geom().Rdash;
kappa_func  = geom().kappa;
tau_func    = geom().tau;

R       = R_func(s);
if Ltype == 0
    curv = true;
    tors = true;
    Rvar = true;
elseif Ltype == 1
    curv = false;
    tors = false;
    Rvar = false;
elseif Ltype == 2
    curv = true;
    tors = false;
    Rvar = false;
elseif Ltype == 3
    curv = true;
    tors = true;
    Rvar = false;
else
    disp('error: specify Ltype')
end
if curv == true
    kappa   = kappa_func(s);
    if tors == true
        tau = tau_func(s);
    else
        tau = 0;
    end
else
    kappa   = 0;
    tau     = 0;
end
if Rvar == true
    Rdash   = Rdash_func(s);
else
    Rdash = 0;
end


%% LINEAR MATRIX DEFINITIONS
Isf         = eye(alpha_mx + 1);
Lambdasf    = lmats.Lambdasf;
Wsf         = lmats.Wsf;
Hsf         = lmats.Hsf;
Asf         = lmats.Asf;
Atilsf      = lmats.Atilsf;


%% L DEFINITION
La = zeros(2*(alpha_mx+1),2*(alpha_mx+1));
La(1:alpha_mx+1,1:alpha_mx+1) = -Rdash/R*Wsf - tau*Hsf;
La(1:alpha_mx+1,alpha_mx+2:2*(alpha_mx+1)) = 1i*a*omega...
    *((Isf - (Lambdasf/(a*omega*R))^2)*(Isf ...
    - kappa*R*Asf) - kappa*Atilsf/(a^2*omega^2*R));
La(alpha_mx+2:2*(alpha_mx+1),1:alpha_mx+1) = ...
    1i*a*omega*(Isf - kappa*R*Asf);
La(alpha_mx+2:2*(alpha_mx+1),alpha_mx+2:2*(alpha_mx+1)) ...
    = Rdash/R*Wsf' + tau*Hsf';


end