function geom = torus3D(geomparams)


%% PARAMETERS
%number of rotations n, half-width R_i, curvature, toroidal radius a,
%length s_o
if ~exist('geomparams','var')
    geomparams.n       = 0.5;
    geomparams.R_i     = 0.5;
    geomparams.kappa   = (2/3)/geomparams.R_i;
    geomparams.s_o     = 2*pi*geomparams.n/geomparams.kappa;
end

R_i     = geomparams.R_i;
kappa   = geomparams.kappa;
a       = 1/kappa;
s_o     = 2*pi*n/kappa;

geom.geomparams = geomparams;


%% SCALAR S-FUNCTIONS
geom.L      = s_o;
geom.R      = @(s) R_i;
geom.Rdash  = @(s) 0;
geom.kappa  = @(s) kappa;
geom.tau    = @(s) 0;
geom.theta0 = @(s) 0;
geom.qyvar  = true;
geom.qzvar  = false;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) a*cos(kappa*s);
geom.qy = @(s) a*sin(kappa*s);
geom.qz = @(s) 0;
geom.nx = @(s) -cos(kappa*s);
geom.ny = @(s) -sin(kappa*s);
geom.nz = @(s) 0;
geom.bx = @(s) 0;
geom.by = @(s) 0;
geom.bz = @(s) 1;


%% GEOMETRY NAME
geom.name = 'torus3D';

end