function geom = straightduct3D(geomparams)


%% PARAMETERS
%duct length s_o and width R_i
if ~exist('geomparams','var')
    geomparams.s_o     = 8;
    geomparams.R_i     = 0.5;
end

s_o = geomparams.s_o;
R_i = geomparams.R_i;

geom.geomparams = geomparams;


%% SCALAR S-FUNCTIONS
geom.L      = s_o;
geom.R      = @(s) R_i;
geom.Rdash  = @(s) 0;
geom.kappa  = @(s) 0;
geom.tau    = @(s) 0;
geom.theta0 = @(s) 0;
geom.qyvar  = false;
geom.qzvar  = false;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) s;
geom.qy = @(s) 0;
geom.qz = @(s) 0;
geom.nx = @(s) 0;
geom.ny = @(s) 1;
geom.nz = @(s) 0;
geom.bx = @(s) 0;
geom.by = @(s) 0;
geom.bz = @(s) 1;

geom.innerqx = @(s) -(s_o - s);
geom.innerqy = @(s) 0;
geom.innernx = @(s) 0;
geom.innerny = @(s) 1;

%% GEOMETRY NAME
geom.name = 'straightduct3D';

end