function geom = lineartaper3D(geomparams)


%% PARAMETERS
%length before narrowing L1, after narrowing L2, width gradient Rdash0,
% decrease ratio, inlet width R_i
if ~exist('geomparams','var')
    geomparams.L1      = 1;
    geomparams.L2      = 1;
    geomparams.Rdash0  = -0.5;
    geomparams.ratio   = 0.5;
    geomparams.R_i     = 0.5;
end

L1      = geomparams.L1;
L2      = geomparams.L2;
Rdash0  = geomparams.Rdash0;
ratio   = geomparams.ratio;
R_i     = geomparams.R_i;

geom.geomparams = geomparams;

%% SCALAR S-FUNCTIONS
    function R = ductradius(s)
        if s < L1
            R = R_i;
        elseif s >= L1 && s <= L1 - R_i*(1 - ratio)/Rdash0
            R = R_i + Rdash0*(s - L1);
        else
            R = R_i*ratio;
        end
    end
    function Rdash = ductradiusderiv(s)
        if s >= L1 && s <= L1 - R_i*(1 - ratio)/Rdash0
            Rdash = Rdash0;
        else
            Rdash = 0;
        end
    end
s_o         = L1 - R_i*(1 - ratio)/Rdash0 + L2;
geom.L      = s_o;
geom.R      = @(s) ductradius(s);
geom.Rdash  = @(s) ductradiusderiv(s);
geom.kappa  = @(s) 0;
geom.tau    = @(s) 0;
geom.theta0 = @(s) 0;
geom.qyvar  = false;
geom.qzvar  = false;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) s;
geom.qy = @(s) 0;
geom.qz = @(s) 0;
geom.nx = @(s) 0;
geom.ny = @(s) 1;
geom.nz = @(s) 0;
geom.bx = @(s) 0;
geom.by = @(s) 0;
geom.bz = @(s) 1;

geom.innerqx = @(s) -(s_o - s);
geom.innerqy = @(s) 0;
geom.innernx = @(s) 0;
geom.innerny = @(s) 1;


%% GEOMETRY NAME
geom.name = 'lineartaper3D';

end