function geom = exphorndecrease3D(geomparams)


%% PARAMETERS
%width decrease ratio > 1, start width R_i, length s_o, exponent m
if ~exist('geomparams','var')
    geomparams.ratio    = 4;
    geomparams.R_i      = 1;
    geomparams.Rmn_i    = -geomparams.R_i/2;
    geomparams.s_o      = 4.5*geomparams.R_i;
end

ratio   = geomparams.ratio;
R_i     = geomparams.R_i;
s_o     = geomparams.s_o;
m       = -log(ratio)/s_o;

geom.geomparams = geomparams;


%% SCALAR S-FUNCTIONS
    function R = ductradius(s)
        if s <= s_o
            R = R_i*exp(m*s);
        else
            R = ratio*R_i;
        end
    end
    function Rdash = ductradiusderiv(s)
        if s <= s_o
            Rdash = m*R_i*exp(m*s);
        else
            Rdash = 0;
        end
    end
geom.L      = s_o;
geom.R      = @(s) ductradius(s);
geom.Rdash  = @(s) ductradiusderiv(s);
geom.kappa  = @(s) 0;
geom.tau    = @(s) 0;
geom.theta0 = @(s) 0;
geom.qyvar  = true;
geom.qzvar  = false;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS
geom.qx = @(s) s;
geom.qy = @(s) 0;
geom.qz = @(s) 0;
geom.nx = @(s) 0;
geom.ny = @(s) 1;
geom.nz = @(s) 0;
geom.bx = @(s) 0;
geom.by = @(s) 0;
geom.bz = @(s) 1;

geom.innerqx = @(s) -(s_o - s);
geom.innerqy = @(s) 0;
geom.innernx = @(s) 0;
geom.innerny = @(s) 1;


%% GEOMETRY NAME
geom.name = 'exphorndecrease3D';

end