function geom = cubicnobend3D(geomparams)


%% PARAMETERS
%duct start width R_i, length s_o, decrease ratio > 1, curvature, bend
%radius R_B and bend angle theta_B
if ~exist('geomparams','var')
    geomparams.R_i      = 0.5;
    geomparams.s_o      = 3.275*2*geomparams.R_i;
    geomparams.ratio    = 4;
end

R_i     = geomparams.R_i;
s_o     = geomparams.s_o;
ratio   = geomparams.ratio;

geom.geomparams = geomparams;

%% SCALAR S-FUNCTIONS
    function R = ductradius(s)
        if s < s_o
            R = R_i*(1 - 1/ratio)*(s/s_o)^2*(2*s/s_o - 3) + R_i;
        else
            R = R_i/ratio;
        end
    end
    function Rdash = ductradiusderiv(s)
        if s <= s_o
            Rdash = (6*R_i)*(1 - 1/ratio)*(s/s_o)*(s/s_o - 1);
        else
            Rdash = 0;
        end
    end
geom.L      = s_o;
geom.R      = @(s) ductradius(s);
geom.Rdash  = @(s) ductradiusderiv(s);
geom.kappa  = @(s) 0;
geom.tau    = @(s) 0;
geom.theta0 = @(s) 0;
geom.qyvar  = true;
geom.qzvar  = false;
geom.dim    = 3;


%% VECTOR S-FUNCTIONS

geom.qx = @(s) s;
geom.qy = @(s) 0;
geom.qz = @(s) 0;
geom.nx = @(s) 0;
geom.ny = @(s) 1;
geom.nz = @(s) 0;
geom.bx = @(s) 0;
geom.by = @(s) 0;
geom.bz = @(s) 1;

geom.innerqx = @(s) -(s_o - s);
geom.innerqy = @(s) 0;
geom.innernx = @(s) 0;
geom.innerny = @(s) 1;


%% GEOMETRY NAME
geom.name = 'cubicnobend3D';

end