function ductplot3D(filename,plotconst,pressuredirection)
%pressuredirection = 0 for total, 1 for fwd, -1 for backward
load(filename,'numparams','geomname','geomparams')
if numparams.lightload == false
    load(filename,'Ysfint')
end

geom        = eval(strcat(geomname,'(','geomparams',')'));
geom.inner  = false;
s_o         = geom.L;
R_func      = geom().R;

alpha_mx    = numparams.alpha_mx;
a_mx        = numparams.a_mx;
s_d         = numparams.s_d;
omega       = real(numparams.omega);
modes       = numparams.modes;
mach        = numparams.mach;
beta0       = numparams.beta0;


%% PLOTTING
disp('defining plotting parameters...')
%pick constant coordinate:
%s is 0 (circular cross section)
%r is 1 (exterior of duct)
%theta is 2 (longitudinal slice-through)
%admittance plot is 3 (Y_11(s))
%RMS pressure is 4
%Fourier coefficients along centreline is 5
if pressuredirection == -1
    pressurelabel = '$$p^-/M$$';
    load(filename,'Pmnint')
    Pchoice = Pmnint;
elseif pressuredirection == 0
    pressurelabel = '$$p/M$$';
    load(filename,'Pint')
    Pchoice = Pint;
elseif pressuredirection == 1
    pressurelabel = '$$p^+/M$$';
    load(filename,'Pplint')
    Pchoice = Pplint;
else
    pressurelabel = '$$p/M$$';
    disp('bad pressure direction')
end
if plotconst == 0 || plotconst == 1 || plotconst == 2
    %real part or absolute value: false is re, true is abs
    absol = false;
    contours = true;
    n_contours = 15;
    %framerate, cycles per second, tildes indicate dimensionality
    %(t_end_tilde*fps must be an integer)
    fps         = 30;
    cps         = 1;
    omega_tilde = 2*pi*cps;
    t_end_tilde = 1;
    t_end       = omega_tilde*t_end_tilde/omega;
    %minimum time necessary for plotting; minimum number of frames required
    t_min_tilde = min(t_end_tilde,2*pi/omega_tilde);
    n_frames    = t_min_tilde*fps;
    %point through first cycle at which frames begin, in [0.5,0.5)
    startfrac   = 0;
    t_grid      = 0 + startfrac*2*pi/omega:omega_tilde/(fps*omega)...
        :t_end -omega_tilde/(fps*omega) + startfrac*2*pi/omega;
    %a-vector with all temporal mode information
    exp_a_grid  = zeros(2*a_mx+1,length(t_grid));
    exp_a_gridq = zeros(2*a_mx+1,length(t_grid));
    for I_t = 1:length(t_grid)
        exp_a_grid(:,I_t) ...
            = exp(-1i*linspace(-a_mx,a_mx,2*a_mx+1)*omega*t_grid(I_t));
        exp_a_gridq(:,I_t) ...
            = exp(-1i*linspace(-a_mx,a_mx,2*a_mx+1)*omega*(t_grid(I_t) ...
            + 0.5*pi/omega));
    end
    
    if plotconst == 0
        %% R-THETA PLOT
        filename ...
            =strcat(pwd,'\DuctAcoustics\plotting\plots\placeholderp0.gif');

        n_r = 100;
        n_theta = 100;
        plotparams.s_0    = (45/90)*s_o;
        plotparams.n_r     = n_r;
        plotparams.n_theta = n_theta;

        grids = rthetaframe(geom,numparams,plotparams,Pchoice);

        xx = grids.xx;
        yy = grids.yy;
        P_a = grids.P_a;

        pp = zeros(n_r+1,n_theta+1,n_frames);
        for I_t = 1:n_frames
            fprintf(1,'frame %2.0f\r', I_t);
            for I_r = 1:n_r+1
                for I_theta = 1:n_theta+1
                    pp(I_r,I_theta,I_t) ...
                        = P_a((I_r-1)*(n_theta+1)+I_theta,:)...
                        *exp_a_grid(:,I_t)/mach ...
                        + 1i*real(P_a((I_r-1)*(n_theta+1)+I_theta,:)...
                        *exp_a_gridq(:,I_t))/mach;
                end
            end
        end
        outerclim = max(abs(pp),[],'all');

    elseif plotconst == 1
        %% S-THETA PLOT
        filename ....
            =strcat(pwd,'\DuctAcoustics\plotting\plots\placeholderp1.gif');

        n_s     = 400;
        n_r     = 250;
        n_theta = 150;
        plotparams.s1       = 0;
        plotparams.s2       = s_d;
        plotparams.r_0    = 1;
        plotparams.n_r     = n_r;
        plotparams.n_s     = n_s;
        plotparams.n_theta = n_theta;

        grids = sthetaframe(geom,numparams,plotparams,Pchoice);

        xx = grids.xx;
        yy = grids.yy;
        zz = grids.zz;

        xx_pl1  = xx.xx_pl1;
        xx_pl01 = xx.xx_pl01;
        xx_pl02 = xx.xx_pl02;
        yy_pl1  = yy.yy_pl1;
        yy_pl01 = yy.yy_pl01;
        yy_pl02 = yy.yy_pl02;
        zz_pl1  = zz.zz_pl1;
        zz_pl01 = zz.zz_pl01;
        zz_pl02 = zz.zz_pl02;


        P_a = grids.P_a;
        P_a_pl01 = P_a.P_a_pl01;
        P_a_pl02 = P_a.P_a_pl02;
        P_a_pl1 = P_a.P_a_pl1;

        pp_pl01 = zeros(n_r+1,n_theta+1,n_frames);
        pp_pl02 = zeros(n_r+1,n_theta+1,n_frames);
        pp_pl1  = zeros(n_s+1,n_theta+1,n_frames);
        for I_t = 1:n_frames
            fprintf(1,'frame %2.0f\r', I_t);
            for I_r = 1:n_r+1
                for I_theta = 1:n_theta+1
                    pp_pl01(I_r,I_theta,I_t)...
                        = real(P_a_pl01((I_r-1)*(n_theta+1)+I_theta,:)...
                        *exp_a_grid(:,I_t))/mach ...
                        +1i*real(P_a_pl01((I_r-1)*(n_theta+1)+I_theta,:)...
                        *exp_a_gridq(:,I_t))/mach;
                    pp_pl02(I_r,I_theta,I_t)...
                        = real(P_a_pl02((I_r-1)*(n_theta+1)+I_theta,:)...
                        *exp_a_grid(:,I_t))/mach ...
                        +1i*real(P_a_pl02((I_r-1)*(n_theta+1)+I_theta,:)...
                        *exp_a_gridq(:,I_t))/mach;
                end
            end
            for I_s = 1:n_s+1
                for I_theta = 1:n_theta+1
                    pp_pl1(I_s,I_theta,I_t)...
                        = real(P_a_pl1((I_s-1)*(n_theta+1)+I_theta,:)...
                        *exp_a_grid(:,I_t))/mach ...
                        + 1i*real(P_a_pl1((I_s-1)*(n_theta+1)+I_theta,:)...
                        *exp_a_gridq(:,I_t))/mach;
                end
            end
        end
        outerclim       = max([max(abs(pp_pl01),[],'all'),...
            max(abs(pp_pl02),[],'all'),max(abs(pp_pl1),[],'all')]);
    elseif plotconst == 2
        %% S-R PLOT
        filename ...
            =strcat(pwd,'\DuctAcoustics\plotting\plots\placeholderp2.gif');

        n_s = 500;
        n_r = 200;
        plotparams.s1       = 0;
        plotparams.s2       = s_d;
        plotparams.r_0      = 1;
        plotparams.n_s     = n_s;
        plotparams.n_r     = n_r;

        grids = rsframe(geom,numparams,plotparams,Pchoice);

        xx = grids.xx;
        yy = grids.yy;
        P_a = grids.P_a;

        pp          = zeros(2*n_r+1,n_s+1,n_frames);

        for I_t = 1:n_frames
            fprintf(1,'frame %2.0f\r', I_t);
            for I_s = 1:n_s+1
                for I_r = 1:2*n_r+1
                    pp(I_r,I_s,I_t) ...
                        = real(P_a((I_s-1)*(2*n_r+1)+I_r,:)...
                        *exp_a_grid(:,I_t))/mach ...
                        + 1i*real(P_a((I_s-1)*(2*n_r+1) + I_r,:)...
                        *exp_a_gridq(:,I_t))/mach;
                end
            end
        end
        outerclim = max(abs(pp),[],'all');
    end
    %% DRAW
    disp('plotting...')
    fig = figure;
    axis tight
    clim manual
    if absol == false
        contourlevels = -outerclim:2*outerclim/(2*n_contours+1):outerclim;
        set_custom_colormap(1);
    else
        contourlevels = 0:outerclim/(2*n_contours+1):outerclim;
        colormap("turbo");
    end
    for I_t = 1:length(t_grid)
        I_tmod ...
            = round(rem(t_grid(I_t),2*pi/omega)*fps*omega/(omega_tilde)+1);
        if plotconst == 0
            if absol == false
                plotquantity = real(pp(:,:,I_tmod))';
            else
                plotquantity = abs(pp(:,:,I_tmod)');
            end
            if contours == false
                plot_pl0 = pcolor(xx,yy,plotquantity);
                set(plot_pl0,'EdgeColor','none');
            else
                [~,c] = contourf(xx,yy,plotquantity);
                c.LevelList = contourlevels;
            end
            clim([contourlevels(1),contourlevels(length(contourlevels))]);
            hold on
            plot(xx(:,length(xx(1,:))),yy(:,length(yy(1,:))),...
                'LineWidth',2,'Color','k')
        elseif plotconst == 1
            if absol == false
                plotquantity01  = real(pp_pl01(:,:,I_tmod));
                plotquantity02  = real(pp_pl02(:,:,I_tmod));
                plotquantity1   = real(reshape(pp_pl1(:,:,I_tmod),n_s+1,...
                    n_theta+1));
            else
                plotquantity01  = abs(pp_pl01(:,:,I_tmod));
                plotquantity02  = abs(pp_pl02(:,:,I_tmod));
                plotquantity1   = abs(reshape(pp_pl1(:,:,I_tmod),n_s+1,...
                    n_theta+1));
            end
            plot_pl01 = surf(xx_pl01,yy_pl01,zz_pl01,plotquantity01);
            set(plot_pl01, 'EdgeColor', 'none');
            hold on
            plot_pl02 = surf(xx_pl02,yy_pl02,zz_pl02,plotquantity02);
            set(plot_pl02, 'EdgeColor', 'none');
            plot_pl1 = surf(xx_pl1,yy_pl1,zz_pl1,plotquantity1);
            set(plot_pl1, 'EdgeColor', 'none');
            plot3(xx_pl01(length(xx_pl01(:,1)),:),...
                yy_pl01(length(yy_pl01(:,1)),:),...
                zz_pl01(length(zz_pl01(:,1)),:),'Color','k');
            plot3(xx_pl02(length(xx_pl02(:,1)),:),...
                yy_pl02(length(yy_pl02(:,1)),:),...
                zz_pl02(length(zz_pl02(:,1)),:),'Color','k');
            zlabel('$$z$$')
            view(250,14)
        elseif plotconst == 2
            if absol == false
                plotquantity = real(pp(:,:,I_tmod));
            else
                plotquantity = abs(pp(:,:,I_tmod));
            end
            if contours == false
                plot_pl2 = pcolor(xx,yy,plotquantity);
                % set(gca,'xtick',[])
                % set(gca,'ytick',[])
                % box off
                set(plot_pl2, 'EdgeColor', 'none');
            else
                [~,c] = contourf(xx,yy,plotquantity);
                c.LevelList = contourlevels;
            end
            hold on
            plot(xx(1,:),yy(1,:),'LineWidth',2,'Color','k')
            plot(xx(2*n_r+1,:),yy(2*n_r+1,:),...
                'LineWidth',2,'Color','k')
        end
        clim([contourlevels(1),contourlevels(length(contourlevels))]);
        xlabel('$$x$$')
        ylabel('$$y$$')
        C = colorbar;
        C.Label.Interpreter = 'latex';
        C.Label.String = pressurelabel;
        C.Label.FontSize = 12;
        daspect([1 1 1])
        title(strcat('$$t=$$',...
            sprintf(' %5.3f',omega*t_grid(I_t)/omega_tilde)));
        drawnow
        [imind,cm] = rgb2ind(frame2im(getframe(fig)),256);
        if I_t == 1
            imwrite(imind,cm,filename,'gif','Loopcount',inf,'DelayTime',...
                1/fps);
        else
            imwrite(imind,cm,filename,'gif','WriteMode','append',...
                'DelayTime',1/fps);
        end
        if fps == 1
            title('')
            exportgraphics(gcf,'stillplaceholderp2.pdf','ContentType',...
                'vector')
        end
    end
elseif plotconst == 3
    %% ADMITTANCE PLOT
    hold off
    n_s = 1000;
    s_grid   = (0:s_d/n_s:s_d);
    S_Y = {s_grid, 1:(2*a_mx+1)*(alpha_mx+1)^2};
    Ysf     = Ysfint(S_Y);
    Ysfpl   = Ysfplint(S_Y);
    Ysf     = reshape(Ysf,[],alpha_mx+1,alpha_mx+1,2*a_mx+1);
    Ysfpl   = reshape(Ysfpl,[],alpha_mx+1,alpha_mx+1,2*a_mx+1);
    index = 2;
    plot(s_grid,real(Ysf(:,index,index,2*a_mx+1)))
    hold on
    plot(s_grid,0*imag(Ysf(:,index,index,2*a_mx+1)))
    xlabel('$$s$$')
    plot(s_grid,real(Ysfpl(:,index,index,2*a_mx+1)))
    plot(s_grid,imag(Ysfpl(:,index,index,2*a_mx+1)))
    legend('$$\Re(Y_{11})$$','$$\Im(Y_{11})$$',...
        '$$\Re(Y_{11}^+)$$','$$\Im(Y_{11}^+)$$')
elseif plotconst == 4
    %% PRESSURE RMS CENTRELINE PLOT
    disp('summing over modes...')
    set(0,'DefaultAxesFontName','Times')
    set(0,'DefaultAxesFontSize',10)
    widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
    figure('units','centimeters','position',[5 -5 widthCM widthCM]);

    
    dot     = ones(2*a_mx+1,1);
    n_s = 1000;
    s   = (0:s_d/n_s:s_d)';
    S_P = {s, 1:(2*a_mx+1)*(alpha_mx+1)};
    P   = Pchoice(S_P);
    Rdenom  = zeros(size(s));
    for I_s = 1:length(s)
        Rdenom(I_s) = 1/R_func(s(I_s));
    end
    P   = reshape(P,[],alpha_mx+1,2*a_mx+1);
    Rdenom  = repmat(Rdenom,1,alpha_mx+1,2*a_mx+1);
    delta_p_alpha0  = eq(modes(:,3),zeros(alpha_mx+1,1));
    besseldenom     = zeros(size(modes(:,1)))';
    for alpha = 0:alpha_mx
        besseldenom(alpha+1) ...
            = 1/abs(besselj(modes(alpha+1,3),modes(alpha+1,2)));
    end
    besseldenom = repmat(besseldenom,length(s),1,2*a_mx+1);
    P_a         = tensorprod(double(P.*Rdenom.*besseldenom),...
        double(delta_p_alpha0),2,1)/sqrt(pi);
    plot(s,sqrt(2*pi/omega)*sqrt(P_a.*conj(P_a)*dot)/mach)
    hold on
    Pwebs_RMS = zeros(size(s));
    for I_s = 1:length(s)
        Pwebs_RMS(I_s) = RMSWebsterSol3D(s(I_s),geom,numparams,...
            pressuredirection);
    end
    plot(s,Pwebs_RMS/mach);
    xlabel('$$s$$')
    ylabel('$$2\sqrt{\frac{\pi}{\omega}\sum_{a = 1}^\infty|P^a|^2}$$',...
        'Rotation',0,'HorizontalAlignment','right',...
        'VerticalAlignment','middle')
    legend('Linear','Webster')
    exportgraphics(gcf,'stillplaceholderp4.pdf','ContentType','vector')
elseif plotconst == 5
    %% FOURIER COEFFICIENTS BY AMPLITUDE (ALONG CENTRELINE)
    % these are compared with the Blackstock solution
    
    set(0,'DefaultAxesFontName','Times')
    set(0,'DefaultAxesFontSize',10)
    widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
    figure('units','centimeters','position',[5 -5 widthCM widthCM]);

    disp('calculating Blackstock solution...')
    n_s     = 200;
    s       = (0:s_d/n_s:s_d)';
    PBlackstock = zeros(length(s(:,1)),a_mx);
    for I_s = 1:n_s+1
        fprintf(1,'s = %6.3f\r',s(I_s));
        for a = 1:5
            PBlackstock(I_s,a) = BlackstockAmps(s(I_s),a,numparams);
        end
    end

    disp('summing over modes...')
    S_P     = {s, 1:(2*a_mx+1)*(alpha_mx+1)};
    P       = reshape(Pchoice(S_P),[],alpha_mx+1,2*a_mx+1);
    Rdenom      = zeros(size(s));
    for I_s = 1:length(s)
        Rdenom(I_s) = 1/R_func(s(I_s));
    end
    Rdenom          = repmat(Rdenom,1,alpha_mx+1,2*a_mx+1);
    delta_p_alpha0  = eq(modes(:,3),zeros(alpha_mx+1,1));
    besseldenom     = zeros(size(modes(:,1)))';
    for alpha = 0:alpha_mx
        besseldenom(alpha+1) ...
            = 1/abs(besselj(modes(alpha+1,3),modes(alpha+1,2)));
    end
    besseldenom = repmat(besseldenom,length(s),1,2*a_mx+1);
    P_a         = tensorprod(double(P.*Rdenom.*besseldenom),...
        double(delta_p_alpha0),2,1)/sqrt(pi);
    
    disp('plotting...')
    for a = 1:5
        colormat = get(gca,'ColorOrder');
        plot(beta0*mach*omega*s,abs(P_a(:,a_mx+1+a)/mach),'--',...
            'LineWidth',2,'Color',colormat(a,:),'DisplayName',...
            append('$$a =$$ ',string(a)));
        hold on
        plot(beta0*mach*omega*s,PBlackstock(:,a)/mach,'Color',...
            colormat(a,:),'DisplayName',append('$$a =$$ ',...
            string(a),', Blackstock'));
        legend
    end
    xlabel('$$\sigma$$')
    ylabel('$$|P^a|$$')
    exportgraphics(gcf,'placeholderp5.pdf','ContentType','vector')
elseif plotconst == 6
    %% CROSS-SECTIONAL AVERAGE ON OUTLET
    % set(0,'DefaultAxesFontName','Times')
    % set(0,'DefaultAxesFontSize',10)
    % widthCM=13.5; % width of plots in cm.  JFM width is 135mm.
    % figure('units','centimeters','position',[5 -5 widthCM widthCM]);

    s1 = 4*pi/3;
    % s1 = 1*geom.L;
    n_t = 1000;
    t_end       = 4*pi/omega;
    t_grid = 0:t_end/n_t:t_end -t_end/n_t;
    exp_a_grid  = zeros(length(t_grid),2*a_mx+1);
    P_alpha_a = reshape(Pchoice({s1,1:(2*a_mx+1)*(alpha_mx+1)}),...
        alpha_mx+1,2*a_mx+1);
    mode_ave = zeros(alpha_mx+1,1);
    for alpha = 0:alpha_mx
        mode_ave(alpha+1) = eq(alpha,0)/(sqrt(pi)*R_func(s_o));
    end
    p_ave = zeros(n_t,1);
    for I_t = 1:n_t
        exp_a_grid(I_t,:) ...
            = exp(-1i*linspace(-a_mx,a_mx,2*a_mx+1)*omega*t_grid(I_t));
        p_ave(I_t) = exp_a_grid(I_t,:)*P_alpha_a'*mode_ave;
    end
    plot(omega*t_grid,real(p_ave)/mach,'DisplayName',...
        'Re$$[\overline{p}_\mathrm{o}(t)]$$')
    % hold on
    % plot(omega*t_grid,imag(p_ave)/mach,'DisplayName',...
    %     'Im$$[\overline{p}_\mathrm{o}(t)]$$')
    % legend
    ylabel('$$\overline{p}(t)$$')
    xticks([0 pi 2*pi 3*pi 4*pi])
    xticklabels({'0','$$\pi$$','$$2\pi$$','$$3\pi$$','$$4\pi$$'})
    xlabel('$$\omega t$$')
%     exportgraphics(gcf,'stillplaceholderp6.pdf','ContentType','vector')
    exportgraphics(gcf,'stillplaceholderp6.pdf')
else
    disp('invalid choice of plotconst')
end
end